/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.EnumSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class LinePainter2D {
    /*
     * WARNING - void declaration
     */
    public static void paint(@NotNull Graphics2D g, double x1, double y1, double d, double d2) {
        void y2;
        void x2;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(0);
        }
        double sw = g.getStroke() instanceof BasicStroke ? (double)((BasicStroke)g.getStroke()).getLineWidth() : 1.0;
        LinePainter2D.paint(g, x1, y1, (double)x2, (double)y2, StrokeType.INSIDE, sw);
    }

    /*
     * WARNING - void declaration
     */
    public static void paint(@NotNull Graphics2D g, double x1, double y1, double x2, double d, @NotNull StrokeType strokeType, double d2) {
        void strokeWidth;
        void strokeType2;
        void y2;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(1);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(2);
        }
        LinePainter2D.paint(g, x1, y1, x2, (double)y2, (StrokeType)strokeType2, (double)strokeWidth, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static void paint(@NotNull Graphics2D g, @NotNull Line2D line, @NotNull StrokeType strokeType, double strokeWidth, @NotNull Object object) {
        void valueAA;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(3);
        }
        if (line == null) {
            LinePainter2D.$$$reportNull$$$0(4);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(5);
        }
        if (object == null) {
            LinePainter2D.$$$reportNull$$$0(6);
        }
        LinePainter2D.paint(g, line.getX1(), line.getY1(), line.getX2(), line.getY2(), strokeType, strokeWidth, valueAA);
    }

    /*
     * WARNING - void declaration
     */
    public static void paint(@NotNull Graphics2D g, double x1, double y1, double x2, double y2, @NotNull StrokeType strokeType, double d, @NotNull Object object) {
        void valueAA;
        void strokeWidth;
        boolean thickStroke;
        void strokeType2;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(7);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(8);
        }
        if (object == null) {
            LinePainter2D.$$$reportNull$$$0(9);
        }
        boolean horizontal = y1 == y2;
        boolean vertical = x1 == x2;
        boolean straight = horizontal || vertical;
        boolean centered = strokeType2 == StrokeType.CENTERED || strokeType2 == StrokeType.CENTERED_CAPS_SQUARE;
        boolean bl = thickStroke = PaintUtil.devValue((double)strokeWidth, g) > 1.0;
        if (g.getStroke() instanceof BasicStroke && (straight || thickStroke)) {
            double cos;
            boolean dot;
            double sw = PaintUtil.alignToInt((double)strokeWidth, g);
            boolean bl2 = dot = horizontal && vertical;
            if (dot) {
                y2 += strokeWidth - 1.0;
            }
            double angle = dot ? 0.0 : Math.atan2(y1 - y2, x2 - x1);
            double sin = dot ? 1.0 : Math.sin(angle);
            double d2 = cos = dot ? 0.0 : Math.cos(angle);
            if (straight && !dot) {
                sin = Math.abs(sin);
                cos = Math.abs(cos);
            }
            double capy_1 = 0.0;
            double capy_2 = 0.0;
            double capx_1 = 0.0;
            double capx_2 = 0.0;
            if (strokeType2 == StrokeType.CENTERED_CAPS_SQUARE) {
                double[] strokeSplit = LinePainter2D.getStrokeSplit(ScaleContext.create(g), (StrokeType)strokeType2, sw, false);
                double cap_1 = strokeSplit[0];
                double cap_2 = strokeSplit[1];
                double y_sign = straight ? 1.0 : -1.0;
                capx_1 = (straight || x1 <= x2 ? cap_1 : cap_2) * cos;
                capx_2 = (straight || x1 <= x2 ? cap_2 : cap_1) * cos;
                capy_1 = (straight || y1 <= y2 ? cap_1 : cap_2) * sin * y_sign;
                capy_2 = (straight || y1 <= y2 ? cap_2 : cap_1) * sin * y_sign;
            }
            if (vertical) {
                double y_min = Math.min(y1, y2);
                double y_max = Math.max(y1, y2);
                y1 = PaintUtil.alignToInt(y_min, g);
                y2 = y1 + y_max - y1 + 1.0;
                x1 = x2 = PaintUtil.alignToInt(x2, g);
            } else if (horizontal) {
                double x_min = Math.min(x1, x2);
                double x_max = Math.max(x1, x2);
                x1 = PaintUtil.alignToInt(x_min, g);
                x2 = x1 + x_max - x1 + 1.0;
                y1 = y2 = PaintUtil.alignToInt(y2, g);
            } else {
                x1 = PaintUtil.alignToInt(x1, g);
                x2 = PaintUtil.alignToInt(x2, g);
                y1 = PaintUtil.alignToInt(y1, g);
                y2 = PaintUtil.alignToInt(y2, g);
                if (Math.abs(angle) > 1.5707963267948966) {
                    sin *= -1.0;
                    cos *= -1.0;
                }
            }
            double swx_2 = 0.0;
            double swx_1 = 0.0;
            double swy_2 = 0.0;
            double swy_1 = 0.0;
            if (strokeType2 == StrokeType.OUTSIDE) {
                swx_1 = sw * sin;
                swy_1 = sw * cos;
            } else if (strokeType2 == StrokeType.INSIDE) {
                swx_2 = sw * sin;
                swy_2 = sw * cos;
            } else if (centered) {
                double sw_2;
                double sw_1;
                if (straight) {
                    double[] strokeSplit = LinePainter2D.getStrokeSplit(ScaleContext.create(g), (StrokeType)strokeType2, sw);
                    sw_1 = strokeSplit[0];
                    sw_2 = strokeSplit[1];
                } else {
                    sw_1 = PaintUtil.alignToInt(Math.max(sw / 2.0, 0.0), g);
                    sw_2 = Math.max(sw - sw_1, 0.0);
                }
                swx_1 = sw_1 * sin;
                swx_2 = sw_2 * sin;
                swy_1 = sw_1 * cos;
                swy_2 = sw_2 * cos;
            }
            Path2D.Double path2 = new Path2D.Double(0);
            ((Path2D)path2).moveTo(x1 - swx_1 - capx_1, y1 - swy_1 - capy_1);
            ((Path2D)path2).lineTo(x2 - swx_1 + capx_2, y2 - swy_1 + capy_2);
            ((Path2D)path2).lineTo(x2 + swx_2 + capx_2, y2 + swy_2 + capy_2);
            ((Path2D)path2).lineTo(x1 + swx_2 - capx_1, y1 + swy_2 - capy_1);
            path2.closePath();
            PaintUtil.paintWithAA(g, valueAA, () -> g.fill(path2));
        } else {
            Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
            PaintUtil.paintWithAA(g, valueAA, () -> g.draw(line));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    public static void fillPolygon(@NotNull Graphics2D g, double @NotNull [] xPoints, double @NotNull [] yPoints, int nPoints, @NotNull StrokeType strokeType, double strokeWidth, @NotNull Object object) {
        void valueAA;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(10);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(11);
        }
        if (object == null) {
            LinePainter2D.$$$reportNull$$$0(12);
        }
        if (xPoints == null) {
            LinePainter2D.$$$reportNull$$$0(13);
        }
        if (yPoints == null) {
            LinePainter2D.$$$reportNull$$$0(14);
        }
        Path2D.Double path2 = new Path2D.Double(0);
        ((Path2D)path2).moveTo(xPoints[0], yPoints[0]);
        for (int p = 1; p < nPoints; ++p) {
            ((Path2D)path2).lineTo(xPoints[p], yPoints[p]);
        }
        path2.closePath();
        PaintUtil.paintWithAA(g, valueAA, () -> g.fill(path2));
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    public static void paintPolygon(@NotNull Graphics2D g, double @NotNull [] xPoints, double @NotNull [] yPoints, int nPoints, @NotNull StrokeType strokeType, double strokeWidth, @NotNull Object object) {
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(15);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(16);
        }
        if (object == null) {
            LinePainter2D.$$$reportNull$$$0(17);
        }
        if (xPoints == null) {
            LinePainter2D.$$$reportNull$$$0(18);
        }
        if (yPoints == null) {
            LinePainter2D.$$$reportNull$$$0(19);
        }
        boolean thickPixel = JreHiDpiUtil.isJreHiDPIEnabled() && PaintUtil.devValue(strokeWidth, g) > 1.0;
        boolean prevStraight = nPoints <= 1 || LinePainter2D.isStraightLine(xPoints, yPoints, nPoints, nPoints);
        for (int p = 0; p < nPoints; ++p) {
            void valueAA;
            boolean thisStraight;
            double x1 = xPoints[p];
            double y1 = yPoints[p];
            double x2 = xPoints[(p + 1) % nPoints];
            double y2 = yPoints[(p + 1) % nPoints];
            boolean bl = thisStraight = x1 == x2 || y1 == y2;
            if (thickPixel && !thisStraight) {
                if (prevStraight) {
                    x1 += 0.5;
                    y1 += 0.5;
                }
                if (LinePainter2D.isStraightLine(xPoints, yPoints, p + 1, nPoints)) {
                    x2 += 0.5;
                    y2 += 0.5;
                }
            }
            prevStraight = thisStraight;
            LinePainter2D.paint(g, x1, y1, x2, y2, strokeType, strokeWidth, valueAA);
        }
    }

    private static boolean isStraightLine(double @NotNull [] xPoints, double @NotNull [] yPoints, int nLine, int nPoints) {
        if (xPoints == null) {
            LinePainter2D.$$$reportNull$$$0(20);
        }
        if (yPoints == null) {
            LinePainter2D.$$$reportNull$$$0(21);
        }
        double x1 = xPoints[nLine % nPoints];
        double y1 = yPoints[nLine % nPoints];
        double x2 = xPoints[(nLine + 1) % nPoints];
        double y2 = yPoints[(nLine + 1) % nPoints];
        return x1 == x2 || y1 == y2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Line2D align(@NotNull Graphics2D g, @NotNull EnumSet<Align> align, double x, double y, double prefLength, boolean bl, @NotNull StrokeType strokeType, double d) {
        double[] p;
        void strokeWidth;
        void strokeType2;
        void vertical;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(22);
        }
        if (align == null) {
            LinePainter2D.$$$reportNull$$$0(23);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(24);
        }
        if (align.contains((Object)Align.CENTER_X)) {
            if (vertical != false) {
                x = LinePainter2D.alignStrokeXY(g, x, (StrokeType)strokeType2, (double)strokeWidth);
            } else {
                p = LinePainter2D.alignSizeXY(g, x, prefLength, (StrokeType)strokeType2, (double)strokeWidth, false);
                x = p[0];
                prefLength = p[1];
            }
        }
        if (align.contains((Object)Align.CENTER_Y)) {
            if (vertical == false) {
                y = LinePainter2D.alignStrokeXY(g, y, (StrokeType)strokeType2, (double)strokeWidth);
            } else {
                p = LinePainter2D.alignSizeXY(g, y, prefLength, (StrokeType)strokeType2, (double)strokeWidth, false);
                y = p[0];
                prefLength = p[1];
            }
        }
        double x2 = vertical == false ? x + prefLength - 1.0 : x;
        double y2 = vertical != false ? y + prefLength - 1.0 : y;
        return new Line2D.Double(x, y, x2, y2);
    }

    /*
     * WARNING - void declaration
     */
    private static double alignStrokeXY(@NotNull Graphics2D g, double xy, @NotNull StrokeType strokeType, double d) {
        void strokeWidth;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(25);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(26);
        }
        double[] strokeSplit = LinePainter2D.getStrokeSplit(ScaleContext.create(g), strokeType, (double)strokeWidth, false);
        return xy - strokeWidth / 2.0 + strokeSplit[0];
    }

    /*
     * WARNING - void declaration
     */
    static double @NotNull [] alignSizeXY(@NotNull Graphics2D g, double xy, double prefSize, @NotNull StrokeType strokeType, double d, boolean bl) {
        double sizeWithStroke;
        void rectangle;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(27);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(28);
        }
        prefSize = PaintUtil.alignToInt(prefSize, g);
        double _xy = PaintUtil.alignToInt(xy + 1.0E-6, g, PaintUtil.RoundingMode.FLOOR);
        PaintUtil.ParityMode pm = Double.compare(_xy, xy) == 0 ? PaintUtil.ParityMode.EVEN : PaintUtil.ParityMode.ODD;
        double sw_1 = 0.0;
        double sw_2 = 0.0;
        if (rectangle != false || strokeType == StrokeType.CENTERED_CAPS_SQUARE) {
            void strokeWidth;
            double[] strokeSplit = LinePainter2D.getStrokeSplit(ScaleContext.create(g), strokeType, (double)strokeWidth, false);
            sw_1 = strokeSplit[0];
            sw_2 = strokeSplit[0];
        }
        if (PaintUtil.getParityMode(sizeWithStroke = sw_1 + prefSize + sw_2, g) != pm) {
            prefSize = PaintUtil.alignToInt(prefSize, g, PaintUtil.ParityMode.invert(PaintUtil.getParityMode(prefSize, g)));
            sizeWithStroke = sw_1 + prefSize + sw_2;
        }
        double[] dArray = new double[]{_xy -= (pm == PaintUtil.ParityMode.ODD ? sizeWithStroke - PaintUtil.devPixel(g) : sizeWithStroke) / 2.0 - sw_1, prefSize};
        if (dArray == null) {
            LinePainter2D.$$$reportNull$$$0(29);
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    private static double getStrokeCenter(@NotNull ScaleContext ctx, double xy, @NotNull StrokeType strokeType, double d) {
        void strokeWidth;
        if (ctx == null) {
            LinePainter2D.$$$reportNull$$$0(30);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(31);
        }
        if (strokeType == StrokeType.INSIDE) {
            return xy + strokeWidth / 2.0;
        }
        if (strokeType == StrokeType.OUTSIDE) {
            return xy - strokeWidth / 2.0;
        }
        double[] strokeSplit = LinePainter2D.getStrokeSplit(ctx, strokeType, (double)strokeWidth);
        return xy - strokeSplit[0] / 2.0 + strokeSplit[1] / 2.0;
    }

    /*
     * WARNING - void declaration
     */
    public static double getStrokeCenter(@NotNull Graphics2D g, double xy, @NotNull StrokeType strokeType, double d) {
        void strokeWidth;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(32);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(33);
        }
        return LinePainter2D.getStrokeCenter(ScaleContext.create(g), xy, strokeType, (double)strokeWidth);
    }

    private static double @NotNull [] getStrokeSplit(@NotNull ScaleContext ctx, @NotNull StrokeType strokeType, double strokeWidth) {
        if (ctx == null) {
            LinePainter2D.$$$reportNull$$$0(34);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(35);
        }
        return LinePainter2D.getStrokeSplit(ctx, strokeType, strokeWidth, true);
    }

    /*
     * WARNING - void declaration
     */
    static double @NotNull [] getStrokeSplit(@NotNull ScaleContext ctx, @NotNull StrokeType strokeType, double strokeWidth, boolean bl) {
        void includeLinePixel;
        if (ctx == null) {
            LinePainter2D.$$$reportNull$$$0(36);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(37);
        }
        if (strokeType == StrokeType.OUTSIDE) {
            double[] dArray = new double[]{strokeWidth, strokeWidth};
            if (dArray == null) {
                LinePainter2D.$$$reportNull$$$0(38);
            }
            return dArray;
        }
        if (strokeType == StrokeType.INSIDE) {
            double[] dArray = new double[]{0.0, 0.0};
            if (dArray == null) {
                LinePainter2D.$$$reportNull$$$0(39);
            }
            return dArray;
        }
        boolean linePixel = includeLinePixel != false;
        double _sw = strokeWidth - 1.0;
        double sw_1 = PaintUtil.alignToInt(Math.max(_sw / 2.0, 0.0), ctx, PaintUtil.RoundingMode.ROUND, null);
        double sw_2 = Math.max((double)linePixel + (_sw - sw_1), 0.0);
        double[] dArray = new double[]{sw_1, sw_2};
        if (dArray == null) {
            LinePainter2D.$$$reportNull$$$0(40);
        }
        return dArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: 
            case 38: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 29: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 16: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strokeType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueAA";
                break;
            }
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xPoints";
                break;
            }
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yPoints";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "align";
                break;
            }
            case 29: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/paint/LinePainter2D";
                break;
            }
            case 30: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/paint/LinePainter2D";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "alignSizeXY";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrokeSplit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillPolygon";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "paintPolygon";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isStraightLine";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "align";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "alignStrokeXY";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "alignSizeXY";
                break;
            }
            case 29: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStrokeCenter";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getStrokeSplit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 29: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Align {
        CENTER_X,
        CENTER_Y;

    }

    public static enum StrokeType {
        CENTERED,
        CENTERED_CAPS_SQUARE,
        INSIDE,
        OUTSIDE;

    }
}

