/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.popup.ActionStepBuilder;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.StatusText;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionPopupStep
implements ListPopupStepEx<PopupFactoryImpl.ActionItem>,
MnemonicNavigationFilter<PopupFactoryImpl.ActionItem>,
SpeedSearchFilter<PopupFactoryImpl.ActionItem> {
    private final List<PopupFactoryImpl.ActionItem> myItems;
    private final String myTitle;
    private final Supplier<? extends DataContext> myContext;
    private final String myActionPlace;
    private final boolean myEnableMnemonics;
    private final PresentationFactory myPresentationFactory;
    private final int myDefaultOptionIndex;
    private final boolean myAutoSelectionEnabled;
    private final boolean myShowDisabledActions;
    private Runnable myFinalRunnable;
    private final Condition<? super AnAction> myPreselectActionCondition;

    public ActionPopupStep(@NotNull List<PopupFactoryImpl.ActionItem> items, String title, @NotNull Supplier<? extends DataContext> context, @Nullable String actionPlace, boolean enableMnemonics, @Nullable Condition<? super AnAction> preselectActionCondition, boolean autoSelection, boolean showDisabledActions, @Nullable PresentationFactory presentationFactory) {
        if (items == null) {
            ActionPopupStep.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ActionPopupStep.$$$reportNull$$$0(1);
        }
        this.myItems = items;
        this.myTitle = title;
        this.myContext = context;
        this.myActionPlace = ObjectUtils.notNull(actionPlace, "popup");
        this.myEnableMnemonics = enableMnemonics;
        this.myPresentationFactory = presentationFactory;
        this.myDefaultOptionIndex = ActionPopupStep.getDefaultOptionIndexFromSelectCondition(preselectActionCondition, items);
        this.myPreselectActionCondition = preselectActionCondition;
        this.myAutoSelectionEnabled = autoSelection;
        this.myShowDisabledActions = showDisabledActions;
    }

    private static int getDefaultOptionIndexFromSelectCondition(@Nullable Condition<? super AnAction> preselectActionCondition, @NotNull List<? extends PopupFactoryImpl.ActionItem> items) {
        if (items == null) {
            ActionPopupStep.$$$reportNull$$$0(2);
        }
        int defaultOptionIndex = 0;
        if (preselectActionCondition != null) {
            for (int i = 0; i < items.size(); ++i) {
                AnAction action2 = items.get(i).getAction();
                if (!preselectActionCondition.value(action2)) continue;
                defaultOptionIndex = i;
                break;
            }
        }
        return defaultOptionIndex;
    }

    @NotNull
    public static ListPopupStep<PopupFactoryImpl.ActionItem> createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, String title, boolean honorActionMnemonics, boolean autoSelectionEnabled, Supplier<? extends DataContext> contextSupplier, @Nullable String actionPlace, Condition<? super AnAction> preselectCondition, int defaultOptionIndex, @Nullable PresentationFactory presentationFactory) {
        if (actionGroup == null) {
            ActionPopupStep.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ActionPopupStep.$$$reportNull$$$0(4);
        }
        List<PopupFactoryImpl.ActionItem> items = ActionPopupStep.createActionItems(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace, presentationFactory);
        boolean enableMnemonics = showNumbers || honorActionMnemonics && items.stream().anyMatch(actionItem -> actionItem.getAction().getTemplatePresentation().getMnemonic() != 0);
        return new ActionPopupStep(items, title, contextSupplier, actionPlace, enableMnemonics, preselectCondition != null ? preselectCondition : action2 -> defaultOptionIndex >= 0 && defaultOptionIndex < items.size() && ((PopupFactoryImpl.ActionItem)items.get(defaultOptionIndex)).getAction().equals(action2), autoSelectionEnabled, showDisabledActions, presentationFactory);
    }

    @NotNull
    public static List<PopupFactoryImpl.ActionItem> createActionItems(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory) {
        if (actionGroup == null) {
            ActionPopupStep.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            ActionPopupStep.$$$reportNull$$$0(6);
        }
        ActionStepBuilder builder2 = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace, presentationFactory);
        builder2.buildGroup(actionGroup);
        List<PopupFactoryImpl.ActionItem> list2 = builder2.getItems();
        if (list2 == null) {
            ActionPopupStep.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PopupFactoryImpl.ActionItem> getValues() {
        List<PopupFactoryImpl.ActionItem> list2 = this.myItems;
        if (list2 == null) {
            ActionPopupStep.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    public boolean isSelectable(PopupFactoryImpl.ActionItem value2) {
        return value2.isEnabled();
    }

    public int getMnemonicPos(PopupFactoryImpl.ActionItem value2) {
        String text2 = this.getTextFor(value2);
        int i = text2.indexOf(27);
        if (i < 0) {
            i = text2.indexOf(38);
        }
        if (i < 0) {
            i = text2.indexOf(95);
        }
        return i;
    }

    @Override
    public Icon getIconFor(PopupFactoryImpl.ActionItem aValue) {
        return aValue.getIcon(false);
    }

    @Override
    public Icon getSelectedIconFor(PopupFactoryImpl.ActionItem value2) {
        return value2.getIcon(true);
    }

    @Override
    @NotNull
    public String getTextFor(PopupFactoryImpl.ActionItem value2) {
        String string = value2.getText();
        if (string == null) {
            ActionPopupStep.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nullable
    public String getTooltipTextFor(PopupFactoryImpl.ActionItem value2) {
        return value2.getDescription();
    }

    @Override
    public void setEmptyText(@NotNull StatusText emptyText) {
        if (emptyText == null) {
            ActionPopupStep.$$$reportNull$$$0(10);
        }
    }

    @Override
    public ListSeparator getSeparatorAbove(PopupFactoryImpl.ActionItem value2) {
        return value2.isPrependWithSeparator() ? new ListSeparator(value2.getSeparatorText()) : null;
    }

    @Override
    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public PopupStep onChosen(PopupFactoryImpl.ActionItem actionChoice, boolean finalChoice) {
        return this.onChosen(actionChoice, finalChoice, 0);
    }

    @Override
    public PopupStep<PopupFactoryImpl.ActionItem> onChosen(PopupFactoryImpl.ActionItem actionChoice, boolean finalChoice, int eventModifiers) {
        if (!actionChoice.isEnabled()) {
            return FINAL_CHOICE;
        }
        AnAction action2 = actionChoice.getAction();
        DataContext dataContext = this.myContext.get();
        if (!(!(action2 instanceof ActionGroup) || finalChoice && ((ActionGroup)action2).canBePerformed(dataContext))) {
            return ActionPopupStep.createActionsStep((ActionGroup)action2, dataContext, this.myEnableMnemonics, true, this.myShowDisabledActions, null, false, false, this.myContext, this.myActionPlace, this.myPreselectActionCondition, -1, this.myPresentationFactory);
        }
        this.myFinalRunnable = () -> this.performAction(action2, eventModifiers);
        return FINAL_CHOICE;
    }

    public void performAction(@NotNull AnAction action2, int modifiers) {
        if (action2 == null) {
            ActionPopupStep.$$$reportNull$$$0(11);
        }
        this.performAction(action2, modifiers, null);
    }

    public void performAction(@NotNull AnAction action2, int modifiers, InputEvent inputEvent) {
        if (action2 == null) {
            ActionPopupStep.$$$reportNull$$$0(12);
        }
        DataContext dataContext = this.myContext.get();
        AnActionEvent event = new AnActionEvent(inputEvent, dataContext, this.myActionPlace, action2.getTemplatePresentation().clone(), ActionManager.getInstance(), modifiers);
        event.setInjectedContext(action2.isInInjectedContext());
        if (ActionUtil.lastUpdateAndCheckDumb(action2, event, false)) {
            ActionUtil.performActionDumbAwareWithCallbacks(action2, event, dataContext);
        }
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    public boolean hasSubstep(PopupFactoryImpl.ActionItem selectedValue) {
        return selectedValue != null && selectedValue.isEnabled() && selectedValue.getAction() instanceof ActionGroup;
    }

    public void canceled() {
    }

    public boolean isMnemonicsNavigationEnabled() {
        return this.myEnableMnemonics;
    }

    public MnemonicNavigationFilter<PopupFactoryImpl.ActionItem> getMnemonicNavigationFilter() {
        return this;
    }

    public String getIndexedString(PopupFactoryImpl.ActionItem value2) {
        return this.getTextFor(value2);
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return this.myAutoSelectionEnabled;
    }

    public SpeedSearchFilter<PopupFactoryImpl.ActionItem> getSpeedSearchFilter() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/ActionPopupStep";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/ActionPopupStep";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOptionIndexFromSelectCondition";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createActionsStep";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createActionItems";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

