/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.LafIconLookup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ActionStepBuilder {
    private final List<PopupFactoryImpl.ActionItem> myListModel;
    private final DataContext myDataContext;
    private final boolean myShowNumbers;
    private final boolean myUseAlphaAsNumbers;
    private final PresentationFactory myPresentationFactory;
    private final boolean myShowDisabled;
    private int myCurrentNumber;
    private boolean myPrependWithSeparator;
    private String mySeparatorText;
    private final boolean myHonorActionMnemonics;
    private final String myActionPlace;
    private Icon myEmptyIcon;
    private int myMaxIconWidth;
    private int myMaxIconHeight;

    ActionStepBuilder(@NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabled, boolean honorActionMnemonics, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory) {
        if (dataContext == null) {
            ActionStepBuilder.$$$reportNull$$$0(0);
        }
        this.myMaxIconWidth = -1;
        this.myMaxIconHeight = -1;
        this.myUseAlphaAsNumbers = useAlphaAsNumbers;
        this.myPresentationFactory = presentationFactory == null ? new PresentationFactory() : Objects.requireNonNull(presentationFactory);
        this.myListModel = new ArrayList<PopupFactoryImpl.ActionItem>();
        this.myDataContext = dataContext;
        this.myShowNumbers = showNumbers;
        this.myShowDisabled = showDisabled;
        this.myCurrentNumber = 0;
        this.myPrependWithSeparator = false;
        this.mySeparatorText = null;
        this.myHonorActionMnemonics = honorActionMnemonics;
        this.myActionPlace = ObjectUtils.notNull(actionPlace, "popup");
    }

    @NotNull
    public List<PopupFactoryImpl.ActionItem> getItems() {
        List<PopupFactoryImpl.ActionItem> list2 = this.myListModel;
        if (list2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void buildGroup(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            ActionStepBuilder.$$$reportNull$$$0(2);
        }
        this.calcMaxIconSize(actionGroup);
        this.myEmptyIcon = this.myMaxIconHeight != -1 && this.myMaxIconWidth != -1 ? EmptyIcon.create(this.myMaxIconWidth, this.myMaxIconHeight) : null;
        this.appendActionsFromGroup(actionGroup);
        if (this.myListModel.isEmpty()) {
            this.myListModel.add(new PopupFactoryImpl.ActionItem(Utils.EMPTY_MENU_FILLER, Utils.NOTHING_HERE, null, false, null, null, false, null));
        }
    }

    private void calcMaxIconSize(ActionGroup actionGroup) {
        AnAction[] actions;
        if (this.myPresentationFactory instanceof MenuItemPresentationFactory && ((MenuItemPresentationFactory)this.myPresentationFactory).shallHideIcons()) {
            return;
        }
        for (AnAction action2 : actions = actionGroup.getChildren(this.createActionEvent(actionGroup))) {
            ActionGroup group;
            if (action2 == null) continue;
            if (action2 instanceof ActionGroup && !(group = (ActionGroup)action2).isPopup()) {
                this.calcMaxIconSize(group);
                continue;
            }
            Icon icon2 = action2.getTemplatePresentation().getIcon();
            if (icon2 == null && action2 instanceof Toggleable) {
                icon2 = EmptyIcon.ICON_16;
            }
            if (icon2 == null) continue;
            int width = icon2.getIconWidth();
            int height = icon2.getIconHeight();
            if (this.myMaxIconWidth < width) {
                this.myMaxIconWidth = width;
            }
            if (this.myMaxIconHeight >= height) continue;
            this.myMaxIconHeight = height;
        }
    }

    @NotNull
    private AnActionEvent createActionEvent(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(3);
        }
        AnActionEvent actionEvent = AnActionEvent.createFromDataContext(this.myActionPlace, this.myPresentationFactory.getPresentation(action2), this.myDataContext);
        actionEvent.setInjectedContext(action2.isInInjectedContext());
        AnActionEvent anActionEvent = actionEvent;
        if (anActionEvent == null) {
            ActionStepBuilder.$$$reportNull$$$0(4);
        }
        return anActionEvent;
    }

    private void appendActionsFromGroup(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            ActionStepBuilder.$$$reportNull$$$0(5);
        }
        List<AnAction> newVisibleActions = Utils.expandActionGroup(false, actionGroup, this.myPresentationFactory, this.myDataContext, this.myActionPlace);
        for (AnAction action2 : newVisibleActions) {
            if (action2 instanceof Separator) {
                this.myPrependWithSeparator = true;
                this.mySeparatorText = ((Separator)action2).getText();
                continue;
            }
            this.appendAction(action2);
        }
    }

    private void appendAction(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionStepBuilder.$$$reportNull$$$0(6);
        }
        Presentation presentation = this.myPresentationFactory.getPresentation(action2);
        boolean enabled = presentation.isEnabled();
        if ((this.myShowDisabled || enabled) && presentation.isVisible()) {
            boolean prependSeparator;
            String actionId;
            Icon disabledIcon;
            String text2 = presentation.getText();
            if (this.myShowNumbers) {
                if (this.myCurrentNumber < 9) {
                    text2 = "&" + (this.myCurrentNumber + 1) + ". " + text2;
                } else if (this.myCurrentNumber == 9) {
                    text2 = "&0. " + text2;
                } else if (this.myUseAlphaAsNumbers) {
                    text2 = "&" + (char)(65 + this.myCurrentNumber - 10) + ". " + text2;
                }
                ++this.myCurrentNumber;
            } else if (this.myHonorActionMnemonics) {
                text2 = Presentation.restoreTextWithMnemonic(text2, action2.getTemplatePresentation().getMnemonic());
            }
            boolean hideIcon = Boolean.TRUE.equals(presentation.getClientProperty("HIDE_ICON"));
            Icon icon2 = hideIcon ? null : presentation.getIcon();
            Icon selectedIcon = hideIcon ? null : presentation.getSelectedIcon();
            Icon icon3 = disabledIcon = hideIcon ? null : presentation.getDisabledIcon();
            if (icon2 == null && selectedIcon == null && ((actionId = ActionManager.getInstance().getId(action2)) == null || !actionId.startsWith("QuickList.")) && action2 instanceof Toggleable && Toggleable.isSelected(presentation)) {
                icon2 = LafIconLookup.getIcon("checkmark");
                selectedIcon = LafIconLookup.getSelectedIcon("checkmark");
                disabledIcon = LafIconLookup.getDisabledIcon("checkmark");
            }
            if (!enabled) {
                icon2 = disabledIcon != null || icon2 == null ? disabledIcon : IconLoader.getDisabledIcon(icon2);
                Icon icon4 = selectedIcon = disabledIcon != null || selectedIcon == null ? disabledIcon : IconLoader.getDisabledIcon(selectedIcon);
            }
            if (this.myMaxIconWidth != -1 && this.myMaxIconHeight != -1) {
                if (icon2 != null) {
                    icon2 = new SizedIcon(icon2, this.myMaxIconWidth, this.myMaxIconHeight);
                }
                if (selectedIcon != null) {
                    selectedIcon = new SizedIcon(selectedIcon, this.myMaxIconWidth, this.myMaxIconHeight);
                }
            }
            if (icon2 == null) {
                icon2 = selectedIcon != null ? selectedIcon : this.myEmptyIcon;
            }
            boolean bl = prependSeparator = (!this.myListModel.isEmpty() || this.mySeparatorText != null) && this.myPrependWithSeparator;
            assert (text2 != null) : action2 + " has no presentation";
            this.myListModel.add(new PopupFactoryImpl.ActionItem(action2, text2, (String)presentation.getClientProperty("ToolTipText"), enabled, icon2, selectedIcon, prependSeparator, this.mySeparatorText));
            this.myPrependWithSeparator = false;
            this.mySeparatorText = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/ActionStepBuilder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/ActionStepBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildGroup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createActionEvent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendActionsFromGroup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

