/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.BalloonPopupBuilderImpl;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.PopupListAdapter;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupTableAdapter;
import com.intellij.ui.popup.PopupTreeAdapter;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.mock.MockConfirmation;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupFactoryImpl
extends JBPopupFactory {
    public static final Key<VisualPosition> ANCHOR_POPUP_POSITION = Key.create("popup.anchor.position");
    public static final Key<Point> ANCHOR_POPUP_POINT = Key.create("popup.anchor.point");
    private static final Logger LOG = Logger.getInstance(PopupFactoryImpl.class);
    private final Map<Disposable, List<Balloon>> myStorage = ContainerUtil.createWeakMap();

    @Override
    @NotNull
    public <T> IPopupChooserBuilder<T> createPopupChooserBuilder(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(0);
        }
        return new PopupChooserBuilder(new JBList<T>(new CollectionListModel<T>(list2)));
    }

    @Override
    @NotNull
    public ListPopup createConfirmation(String title, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), onYes, defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(1);
        }
        return listPopup;
    }

    @Override
    @NotNull
    public ListPopup createConfirmation(String title, String yesText, String noText, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, yesText, noText, onYes, EmptyRunnable.getInstance(), defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    @Override
    @NotNull
    public JBPopup createMessage(String text2) {
        ListPopup listPopup = this.createListPopup(new BaseListPopupStep<String>(null, text2));
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @Override
    public Balloon getParentBalloonFor(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            Object balloon;
            if (!(eachParent instanceof JComponent) || !((balloon = ((JComponent)eachParent).getClientProperty("Balloon.property")) instanceof Balloon)) continue;
            return (Balloon)balloon;
        }
        return null;
    }

    @Override
    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JList list2) {
        return new PopupListAdapter(builder2, list2);
    }

    @Override
    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JTree tree) {
        return new PopupTreeAdapter(builder2, tree);
    }

    @Override
    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JTable table) {
        return new PopupTableAdapter(builder2, table);
    }

    @Override
    @NotNull
    public ListPopup createConfirmation(String title, final String yesText, String noText, final Runnable onYes, final Runnable onNo, int defaultOptionIndex) {
        BaseListPopupStep<String> step = new BaseListPopupStep<String>(title, new String[]{yesText, noText}){

            @Override
            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(selectedValue.equals(yesText) ? onYes : onNo);
            }

            @Override
            public void canceled() {
                onNo.run();
            }

            @Override
            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step.setDefaultOptionIndex(defaultOptionIndex);
        Application app = ApplicationManager.getApplication();
        return app == null || !app.isUnitTestMode() ? new ListPopupImpl(step) : new MockConfirmation((ListPopupStep)step, yesText);
    }

    @NotNull
    private static Supplier<DataContext> getComponentContextSupplier(Component component2) {
        Supplier<DataContext> supplier = () -> DataManager.getInstance().getDataContext(component2);
        if (supplier == null) {
            PopupFactoryImpl.$$$reportNull$$$0(4);
        }
        return supplier;
    }

    @Override
    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid aid, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(6);
        }
        return new ActionGroupPopup(title, actionGroup, dataContext, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING || aid == JBPopupFactory.ActionSelectionAid.NUMBERING, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, aid == JBPopupFactory.ActionSelectionAid.MNEMONICS, disposeCallback, maxRowCount, preselectActionCondition, actionPlace);
    }

    @Override
    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(8);
        }
        return new ActionGroupPopup(title, actionGroup, dataContext, showNumbers, true, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, null);
    }

    @Override
    @NotNull
    public ListPopupStep<ActionItem> createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, @Nullable String actionPlace, boolean showNumbers, boolean showDisabledActions, String title, Component component2, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(10);
        }
        ListPopupStep<ActionItem> listPopupStep = ActionPopupStep.createActionsStep(actionGroup, dataContext, showNumbers, true, showDisabledActions, title, honorActionMnemonics, autoSelectionEnabled, PopupFactoryImpl.getComponentContextSupplier(component2), actionPlace, null, defaultOptionIndex, null);
        if (listPopupStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(11);
        }
        return listPopupStep;
    }

    private static boolean itemsHaveMnemonics(List<? extends ActionItem> items) {
        for (ActionItem actionItem : items) {
            if (actionItem.getAction().getTemplatePresentation().getMnemonic() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(12);
        }
        return new ListPopupImpl(step);
    }

    @Override
    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step, int maxRowCount) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(13);
        }
        ListPopupImpl popup2 = new ListPopupImpl(step);
        popup2.setMaxRowCount(maxRowCount);
        ListPopupImpl listPopupImpl = popup2;
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(14);
        }
        return listPopupImpl;
    }

    @Override
    @NotNull
    public TreePopup createTree(JBPopup parent, @NotNull TreePopupStep aStep, Object parentValue) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(15);
        }
        return new TreePopupImpl(aStep.getProject(), parent, aStep, parentValue);
    }

    @Override
    @NotNull
    public TreePopup createTree(@NotNull TreePopupStep aStep) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(16);
        }
        return new TreePopupImpl(aStep.getProject(), null, aStep, null);
    }

    @Override
    @NotNull
    public ComponentPopupBuilder createComponentPopupBuilder(@NotNull JComponent content2, JComponent preferableFocusComponent) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(17);
        }
        return new ComponentPopupBuilderImpl(content2, preferableFocusComponent);
    }

    @Override
    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull DataContext dataContext) {
        Point point;
        Component component2;
        JComponent focusOwner;
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(18);
        }
        JComponent jComponent = focusOwner = (component2 = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext)) instanceof JComponent ? (JComponent)component2 : null;
        if (focusOwner == null) {
            Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
            JFrame frame = project2 == null ? null : WindowManager.getInstance().getFrame(project2);
            JComponent jComponent2 = focusOwner = frame == null ? null : frame.getRootPane();
            if (focusOwner == null) {
                throw new IllegalArgumentException("focusOwner cannot be null");
            }
        }
        if ((point = PlatformDataKeys.CONTEXT_MENU_POINT.getData(dataContext)) != null) {
            return new RelativePoint(focusOwner, point);
        }
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && focusOwner == editor.getContentComponent()) {
            RelativePoint relativePoint = this.guessBestPopupLocation(editor);
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(19);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = this.guessBestPopupLocation(focusOwner);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(20);
        }
        return relativePoint;
    }

    @Override
    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull JComponent component2) {
        if (component2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(21);
        }
        Point popupMenuPoint = null;
        Rectangle visibleRect = component2.getVisibleRect();
        if (component2 instanceof JList) {
            int[] selectedIndices;
            JList list2 = (JList)component2;
            int firstVisibleIndex = list2.getFirstVisibleIndex();
            int lastVisibleIndex = list2.getLastVisibleIndex();
            for (int index : selectedIndices = list2.getSelectedIndices()) {
                if (firstVisibleIndex > index || index > lastVisibleIndex) continue;
                Rectangle cellBounds = list2.getCellBounds(index, index);
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height - 1);
                break;
            }
        } else if (component2 instanceof JTree) {
            JTree tree = (JTree)component2;
            int[] selectionRows = tree.getSelectionRows();
            if (selectionRows != null) {
                Object rowBounds;
                Arrays.sort(selectionRows);
                for (int row : selectionRows) {
                    rowBounds = tree.getRowBounds(row);
                    if (!visibleRect.contains((Rectangle)rowBounds)) continue;
                    popupMenuPoint = new Point(((Rectangle)rowBounds).x + 2, ((Rectangle)rowBounds).y + ((Rectangle)rowBounds).height - 1);
                    break;
                }
                if (popupMenuPoint == null) {
                    Point visibleCenter = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
                    double minDistance = Double.POSITIVE_INFINITY;
                    Object bestRow = -1;
                    for (Object row : (Object)selectionRows) {
                        Rectangle rowBounds2 = tree.getRowBounds((int)row);
                        Point rowCenter = new Point(rowBounds2.x + rowBounds2.width / 2, rowBounds2.y + rowBounds2.height / 2);
                        double distance2 = visibleCenter.distance(rowCenter);
                        if (!(minDistance > distance2)) continue;
                        minDistance = distance2;
                        bestRow = row;
                    }
                    if (bestRow != -1) {
                        rowBounds = tree.getRowBounds((int)bestRow);
                        tree.scrollRectToVisible(new Rectangle(((Rectangle)rowBounds).x, ((Rectangle)rowBounds).y, Math.min(visibleRect.width, ((Rectangle)rowBounds).width), ((Rectangle)rowBounds).height));
                        popupMenuPoint = new Point(((Rectangle)rowBounds).x + 2, ((Rectangle)rowBounds).y + ((Rectangle)rowBounds).height - 1);
                    }
                }
            }
        } else if (component2 instanceof JTable) {
            JTable table = (JTable)component2;
            int column = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int row = Math.max(table.getSelectionModel().getLeadSelectionIndex(), table.getSelectionModel().getAnchorSelectionIndex());
            Rectangle rect = table.getCellRect(row, column, false);
            if (!visibleRect.intersects(rect)) {
                table.scrollRectToVisible(rect);
            }
            popupMenuPoint = new Point(rect.x, rect.y + rect.height - 1);
        } else if (component2 instanceof PopupOwner) {
            popupMenuPoint = ((PopupOwner)((Object)component2)).getBestPopupPosition();
        }
        if (popupMenuPoint == null) {
            popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        }
        return new RelativePoint(component2, popupMenuPoint);
    }

    @Override
    public boolean isBestPopupLocationVisible(@NotNull Editor editor) {
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(22);
        }
        return PopupFactoryImpl.getVisibleBestPopupLocation(editor) != null;
    }

    @Override
    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull Editor editor) {
        Point p;
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(23);
        }
        if ((p = PopupFactoryImpl.getVisibleBestPopupLocation(editor)) == null) {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            p = new Point(visibleArea.x + visibleArea.width / 3, visibleArea.y + visibleArea.height / 2);
        }
        return new RelativePoint(editor.getContentComponent(), p);
    }

    @Nullable
    private static Point getVisibleBestPopupLocation(@NotNull Editor editor) {
        Rectangle visibleArea;
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(24);
        }
        int lineHeight = editor.getLineHeight();
        Point p = editor.getUserData(ANCHOR_POPUP_POINT);
        if (p == null) {
            VisualPosition visualPosition = editor.getUserData(ANCHOR_POPUP_POSITION);
            if (visualPosition == null) {
                CaretModel caretModel = editor.getCaretModel();
                visualPosition = caretModel.isUpToDate() ? caretModel.getVisualPosition() : editor.offsetToVisualPosition(caretModel.getOffset());
            }
            p = editor.visualPositionToXY(visualPosition);
            p.y += lineHeight;
        }
        return !(visibleArea = editor.getScrollingModel().getVisibleArea()).contains(p) && !visibleArea.contains(p.x, p.y - lineHeight) ? null : p;
    }

    @Override
    public Point getCenterOf(JComponent container2, JComponent content2) {
        return AbstractPopup.getCenterOf((Component)container2, content2);
    }

    @Override
    @NotNull
    public List<JBPopup> getChildPopups(@NotNull Component component2) {
        if (component2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(25);
        }
        List<JBPopup> list2 = AbstractPopup.getChildPopups(component2);
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @Override
    public boolean isPopupActive() {
        return IdeEventQueue.getInstance().isPopupActive();
    }

    @Override
    @NotNull
    public BalloonBuilder createBalloonBuilder(@NotNull JComponent content2) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(27);
        }
        return new BalloonPopupBuilderImpl(this.myStorage, content2);
    }

    @Override
    @NotNull
    public BalloonBuilder createDialogBalloonBuilder(@NotNull JComponent content2, String title) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(28);
        }
        BalloonPopupBuilderImpl builder2 = new BalloonPopupBuilderImpl(this.myStorage, content2);
        Color bg = UIManager.getColor("Panel.background");
        Color borderOriginal = Color.darkGray;
        Color border = ColorUtil.toAlpha(borderOriginal, 75);
        builder2.setDialogMode(true).setTitle(title).setAnimationCycle(200).setFillColor(bg).setBorderColor(border).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnAction(false).setCloseButtonEnabled(true).setShadow(true);
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = builder2;
        if (balloonPopupBuilderImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(29);
        }
        return balloonPopupBuilderImpl;
    }

    @Override
    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @Nullable Icon icon2, Color textColor, Color fillColor, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(30);
        }
        JEditorPane text2 = IdeTooltipManager.initPane(htmlContent, new HintHint().setTextFg(textColor).setAwtTooltip(true), null);
        if (listener2 != null) {
            text2.addHyperlinkListener(listener2);
        }
        text2.setEditable(false);
        NonOpaquePanel.setTransparent(text2);
        text2.setBorder(null);
        JLabel label2 = new JLabel();
        NonOpaquePanel content2 = new NonOpaquePanel(new BorderLayout((int)((double)label2.getIconTextGap() * 1.5), (int)((double)label2.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel(new GridBagLayout());
        JScrollPane scrolledText = ScrollPaneFactory.createScrollPane((Component)text2, true);
        scrolledText.setBackground(fillColor);
        scrolledText.getViewport().setBackground(fillColor);
        textWrapper.add(scrolledText);
        content2.add((Component)textWrapper, "Center");
        if (icon2 != null) {
            NonOpaquePanel north = new NonOpaquePanel(new BorderLayout());
            north.add((Component)new JLabel(icon2), "North");
            content2.add((Component)north, "West");
        }
        content2.setBorder(JBUI.Borders.empty(2, 4));
        BalloonBuilder builder2 = this.createBalloonBuilder(content2);
        builder2.setFillColor(fillColor);
        BalloonBuilder balloonBuilder = builder2;
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(31);
        }
        return balloonBuilder;
    }

    @Override
    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, MessageType messageType, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(32);
        }
        BalloonBuilder balloonBuilder = this.createHtmlTextBalloonBuilder(htmlContent, messageType.getDefaultIcon(), messageType.getPopupBackground(), listener2);
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(33);
        }
        return balloonBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 17: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfirmation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentContextSupplier";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsStep";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createListPopup";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBestPopupLocation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPopups";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialogBalloonBuilder";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlTextBalloonBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopupChooserBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroupPopup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createActionsStep";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createListPopup";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createComponentPopupBuilder";
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "guessBestPopupLocation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isBestPopupLocationVisible";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleBestPopupLocation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChildPopups";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonBuilder";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createDialogBalloonBuilder";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlTextBalloonBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 26: 
            case 29: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ActionItem
    implements ShortcutProvider,
    AnActionHolder {
        private final AnAction myAction;
        private String myText;
        private final boolean myIsEnabled;
        private final Icon myIcon;
        private final Icon mySelectedIcon;
        private final boolean myPrependWithSeparator;
        private final String mySeparatorText;
        private final String myDescription;

        ActionItem(@NotNull AnAction action2, @NotNull String text2, @Nullable String description, boolean enabled, @Nullable Icon icon2, @Nullable Icon selectedIcon, boolean prependWithSeparator, String separatorText) {
            if (action2 == null) {
                ActionItem.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                ActionItem.$$$reportNull$$$0(1);
            }
            this.myAction = action2;
            this.myText = text2;
            this.myIsEnabled = enabled;
            this.myIcon = icon2;
            this.mySelectedIcon = selectedIcon;
            this.myPrependWithSeparator = prependWithSeparator;
            this.mySeparatorText = separatorText;
            this.myDescription = description;
            this.myAction.getTemplatePresentation().addPropertyChangeListener(evt -> {
                if (evt.getPropertyName() == "text") {
                    this.myText = this.myAction.getTemplatePresentation().getText();
                }
            });
        }

        @Override
        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                ActionItem.$$$reportNull$$$0(2);
            }
            return anAction;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ActionItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public Icon getIcon(boolean selected2) {
            return selected2 && this.mySelectedIcon != null ? this.mySelectedIcon : this.myIcon;
        }

        public boolean isPrependWithSeparator() {
            return this.myPrependWithSeparator;
        }

        public String getSeparatorText() {
            return this.mySeparatorText;
        }

        public boolean isEnabled() {
            return this.myIsEnabled;
        }

        public String getDescription() {
            return this.myDescription;
        }

        @Override
        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction.getShortcutSet();
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionGroupPopup
    extends ListPopupImpl {
        private final Runnable myDisposeCallback;
        private final Component myComponent;
        private final String myActionPlace;

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(1);
            }
            this(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace, null, false);
        }

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(2);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(3);
            }
            this(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace, null, autoSelection);
        }

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(4);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(5);
            }
            this(null, ActionGroupPopup.createStep(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, preselectActionCondition, actionPlace, presentationFactory, autoSelection), disposeCallback, dataContext, actionPlace, maxRowCount);
            UiInspectorUtil.registerProvider(this.getList(), () -> UiInspectorUtil.collectActionGroupInfo("Menu", actionGroup, actionPlace));
        }

        protected ActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep step, @Nullable Runnable disposeCallback, @NotNull DataContext dataContext, @Nullable String actionPlace, int maxRowCount) {
            if (step == null) {
                ActionGroupPopup.$$$reportNull$$$0(6);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(7);
            }
            super(CommonDataKeys.PROJECT.getData(dataContext), aParent, step, null);
            this.setMaxRowCount(maxRowCount);
            this.myDisposeCallback = disposeCallback;
            this.myComponent = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            this.myActionPlace = ObjectUtils.notNull(actionPlace, "popup");
            this.registerAction("handleActionToggle1", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleToggleAction();
                }
            });
            this.addListSelectionListener(e -> {
                JList list2 = (JList)e.getSource();
                ActionItem actionItem = (ActionItem)list2.getSelectedValue();
                if (actionItem == null) {
                    return;
                }
                Presentation presentation = this.updateActionItem(actionItem);
                ActionMenu.showDescriptionInStatusBar(true, this.myComponent, presentation.getDescription());
            });
        }

        @NotNull
        private Presentation updateActionItem(@NotNull ActionItem actionItem) {
            if (actionItem == null) {
                ActionGroupPopup.$$$reportNull$$$0(8);
            }
            AnAction action2 = actionItem.getAction();
            Presentation presentation = new Presentation();
            presentation.setDescription(action2.getTemplatePresentation().getDescription());
            AnActionEvent actionEvent = new AnActionEvent(null, DataManager.getInstance().getDataContext(this.myComponent), this.myActionPlace, presentation, ActionManager.getInstance(), 0);
            actionEvent.setInjectedContext(action2.isInInjectedContext());
            ActionUtil.performDumbAwareUpdate(LaterInvocator.isInModalContext(), action2, actionEvent, false);
            Presentation presentation2 = presentation;
            if (presentation2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(9);
            }
            return presentation2;
        }

        private static ListPopupStep<ActionItem> createStep(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(10);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(11);
            }
            Component component2 = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            LOG.assertTrue(component2 != null, "dataContext has no component for new ListPopupStep");
            List<ActionItem> items = ActionPopupStep.createActionItems(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace, presentationFactory);
            return new ActionPopupStep(items, title, PopupFactoryImpl.getComponentContextSupplier(component2), actionPlace, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), preselectActionCondition, autoSelection, showDisabledActions, presentationFactory);
        }

        @Deprecated
        @NotNull
        public static List<ActionItem> getActionItems(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(12);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(13);
            }
            List<ActionItem> list2 = ActionPopupStep.createActionItems(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace, null);
            if (list2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(14);
            }
            return list2;
        }

        @Override
        public void dispose() {
            if (this.myDisposeCallback != null) {
                this.myDisposeCallback.run();
            }
            ActionMenu.showDescriptionInStatusBar(true, this.myComponent, null);
            super.dispose();
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            KeepingPopupOpenAction dontClosePopupAction;
            Object selectedValue = this.getList().getSelectedValue();
            ActionPopupStep actionPopupStep = ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class);
            if (actionPopupStep != null && (dontClosePopupAction = ActionGroupPopup.getActionByClass(selectedValue, actionPopupStep, KeepingPopupOpenAction.class)) != null) {
                actionPopupStep.performAction((AnAction)((Object)dontClosePopupAction), e != null ? e.getModifiers() : 0, e);
                for (ActionItem item : actionPopupStep.getValues()) {
                    this.updateActionItem(item);
                }
                this.getList().repaint();
                return;
            }
            super.handleSelect(handleFinalChoices, e);
        }

        protected void handleToggleAction() {
            Object[] selectedValues = this.getList().getSelectedValues();
            ListPopupStep<Object> listStep = this.getListStep();
            ActionPopupStep actionPopupStep = ObjectUtils.tryCast(listStep, ActionPopupStep.class);
            if (actionPopupStep == null) {
                return;
            }
            List<ToggleAction> filtered2 = ContainerUtil.mapNotNull(selectedValues, o -> ActionGroupPopup.getActionByClass(o, actionPopupStep, ToggleAction.class));
            for (ToggleAction action2 : filtered2) {
                actionPopupStep.performAction(action2, 0);
            }
            for (ActionItem item : actionPopupStep.getValues()) {
                this.updateActionItem(item);
            }
            this.getList().repaint();
        }

        @Nullable
        private static <T> T getActionByClass(@Nullable Object value2, @NotNull ActionPopupStep actionPopupStep, @NotNull Class<T> actionClass) {
            ActionItem item;
            if (actionPopupStep == null) {
                ActionGroupPopup.$$$reportNull$$$0(15);
            }
            if (actionClass == null) {
                ActionGroupPopup.$$$reportNull$$$0(16);
            }
            ActionItem actionItem = item = value2 instanceof ActionItem ? (ActionItem)value2 : null;
            if (item == null) {
                return null;
            }
            if (!actionPopupStep.isSelectable(item)) {
                return null;
            }
            return actionClass.isInstance(item.getAction()) ? (T)actionClass.cast(item.getAction()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionItem";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPopupStep";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateActionItem";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateActionItem";
                    break;
                }
                case 9: 
                case 14: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionItems";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionByClass";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

