/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PopupListAdapter<T>
implements PopupChooserBuilder.PopupComponentAdapter<T> {
    private final JList myList;
    private final PopupChooserBuilder myBuilder;
    private ListWithFilter myListWithFilter;

    PopupListAdapter(PopupChooserBuilder builder2, JList list2) {
        this.myBuilder = builder2;
        this.myList = list2;
    }

    @Override
    public JComponent getComponent() {
        return this.myList;
    }

    @Override
    public void setRenderer(ListCellRenderer renderer) {
        this.myList.setCellRenderer(renderer);
    }

    @Override
    public void setItemChosenCallback(Consumer<? super T> callback2) {
        this.myBuilder.setItemChoosenCallback(() -> {
            Object selectedValue = this.myList.getSelectedValue();
            if (selectedValue != null) {
                callback2.consume((T)selectedValue);
            }
        });
    }

    @Override
    public void setItemsChosenCallback(Consumer<? super Set<T>> callback2) {
        this.myBuilder.setItemChoosenCallback(() -> {
            List list2 = this.myList.getSelectedValuesList();
            callback2.consume(list2 != null ? new HashSet(list2) : Collections.emptySet());
        });
    }

    @Override
    public JScrollPane createScrollPane() {
        return this.myListWithFilter.getScrollPane();
    }

    @Override
    public boolean hasOwnScrollPane() {
        return true;
    }

    @Override
    @Nullable
    public BooleanFunction<KeyEvent> getKeyEventHandler() {
        return InputEvent::isConsumed;
    }

    @Override
    public JComponent buildFinalComponent() {
        this.myListWithFilter = (ListWithFilter)ListWithFilter.wrap(this.myList, new MyListWrapper(this.myList), this.myBuilder.getItemsNamer());
        this.myListWithFilter.setAutoPackHeight(this.myBuilder.isAutoPackHeightOnFiltering());
        return this.myListWithFilter;
    }

    @Override
    public void addMouseListener(MouseListener listener2) {
        this.myList.addMouseListener(listener2);
    }

    @Override
    public void autoSelect() {
        JList list2 = this.myList;
        if (list2.getSelectedIndex() == -1) {
            list2.setSelectedIndex(0);
        }
    }

    @Override
    public ListComponentUpdater getBackgroundUpdater() {
        return new JBListUpdater((JBList)this.myList);
    }

    @Override
    public void setSelectedValue(T preselection, boolean shouldScroll) {
        this.myList.setSelectedValue(preselection, shouldScroll);
    }

    @Override
    public void setItemSelectedCallback(Consumer<? super T> c) {
        this.myList.addListSelectionListener(e -> {
            Object selectedValue = this.myList.getSelectedValue();
            c.consume((T)selectedValue);
        });
    }

    @Override
    public void setSelectionMode(int selection) {
        this.myList.setSelectionMode(selection);
    }

    @Override
    public boolean checkResetFilter() {
        return this.myListWithFilter.resetFilter();
    }

    private class MyListWrapper
    extends JBScrollPane
    implements DataProvider {
        private final JList myList;

        private MyListWrapper(JList list2) {
            super(-1);
            list2.setVisibleRowCount(PopupListAdapter.this.myBuilder.getVisibleRowCount());
            this.setViewportView(list2);
            if (PopupListAdapter.this.myBuilder.isAutoselectOnMouseMove()) {
                ListUtil.installAutoSelectOnMouseMove(list2);
            }
            ScrollingUtil.installActions(list2);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myList = list2;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyListWrapper.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return this.myList.getSelectedValue();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return this.myList.getSelectedValues();
            }
            return null;
        }

        @Override
        public void setBorder(Border border) {
            if (this.myList != null) {
                this.myList.setBorder(border);
            }
        }

        @Override
        public void requestFocus() {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            this.myList.addMouseListener(l);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ui/popup/PopupListAdapter$MyListWrapper", "getData"));
        }
    }
}

