/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;

public class PopupListElementRenderer<E>
extends GroupedItemsListRenderer<E> {
    protected final ListPopupImpl myPopup;
    private JLabel myShortcutLabel;

    public PopupListElementRenderer(final ListPopupImpl aPopup) {
        super(new ListItemDescriptorAdapter<E>(){

            public String getTextFor(E value2) {
                return aPopup.getListStep().getTextFor(value2);
            }

            public Icon getIconFor(E value2) {
                return aPopup.getListStep().getIconFor(value2);
            }

            public Icon getSelectedIconFor(E value2) {
                return aPopup.getListStep().getSelectedIconFor(value2);
            }

            public boolean hasSeparatorAboveOf(E value2) {
                return aPopup.getListModel().isSeparatorAboveOf(value2);
            }

            public String getCaptionAboveOf(E value2) {
                return aPopup.getListModel().getCaptionAboveOf(value2);
            }

            @Nullable
            public String getTooltipFor(E value2) {
                ListPopupStep<Object> listStep = aPopup.getListStep();
                if (!(listStep instanceof ListPopupStepEx)) {
                    return null;
                }
                return ((ListPopupStepEx)listStep).getTooltipTextFor(value2);
            }
        });
        this.myPopup = aPopup;
    }

    @Override
    protected JComponent createItemComponent() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.createLabel();
        panel2.add((Component)this.myTextLabel, "Center");
        this.myShortcutLabel = new JLabel();
        this.myShortcutLabel.setBorder(JBUI.Borders.emptyRight(3));
        this.myShortcutLabel.setForeground(UIManager.getColor("MenuItem.acceleratorForeground"));
        panel2.add((Component)this.myShortcutLabel, "East");
        return this.layoutComponent(panel2);
    }

    @Override
    protected void customizeComponent(JList<? extends E> list2, E value2, boolean isSelected) {
        ListPopupStep<Object> step = this.myPopup.getListStep();
        boolean isSelectable = step.isSelectable(value2);
        this.myTextLabel.setEnabled(isSelectable);
        if (step instanceof BaseListPopupStep) {
            E prevValue;
            Color bg = ((BaseListPopupStep)step).getBackgroundFor(value2);
            Color fg = ((BaseListPopupStep)step).getForegroundFor(value2);
            if (!isSelected && fg != null) {
                this.myTextLabel.setForeground(fg);
            }
            if (!isSelected && bg != null) {
                UIUtil.setBackgroundRecursively(this.myComponent, bg);
            }
            if (bg != null && this.mySeparatorComponent.isVisible() && this.myCurrentIndex > 0 && Comparing.equal(bg, ((BaseListPopupStep)step).getBackgroundFor(prevValue = list2.getModel().getElementAt(this.myCurrentIndex - 1)))) {
                this.myRendererComponent.setBackground(bg);
            }
        }
        if (step.isMnemonicsNavigationEnabled()) {
            int pos;
            MnemonicNavigationFilter filter2 = step.getMnemonicNavigationFilter();
            int n = pos = filter2 == null ? -1 : filter2.getMnemonicPos(value2);
            if (pos != -1) {
                String text2 = this.myTextLabel.getText();
                text2 = text2.substring(0, pos) + text2.substring(pos + 1);
                this.myTextLabel.setText(text2);
                this.myTextLabel.setDisplayedMnemonicIndex(pos);
            }
        } else {
            this.myTextLabel.setDisplayedMnemonicIndex(-1);
        }
        if (step.hasSubstep(value2) && isSelectable) {
            this.myNextStepLabel.setVisible(true);
            boolean isDark = ColorUtil.isDark(UIUtil.getListSelectionBackground(true));
            this.myNextStepLabel.setIcon(isDark ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep);
        } else {
            this.myNextStepLabel.setVisible(false);
        }
        this.setSelected(this.myComponent, isSelected && isSelectable);
        this.setSelected(this.myTextLabel, isSelected && isSelectable);
        this.setSelected(this.myNextStepLabel, isSelected && isSelectable);
        if (this.myShortcutLabel != null) {
            Shortcut shortcut;
            ShortcutSet set;
            this.myShortcutLabel.setEnabled(isSelectable);
            this.myShortcutLabel.setText("");
            if (value2 instanceof ShortcutProvider && (set = ((ShortcutProvider)value2).getShortcut()) != null && (shortcut = ArrayUtil.getFirstElement(set.getShortcuts())) != null) {
                this.myShortcutLabel.setText("     " + KeymapUtil.getShortcutText(shortcut));
            }
            this.setSelected(this.myShortcutLabel, isSelected && isSelectable);
            this.myShortcutLabel.setForeground(isSelected && isSelectable ? UIManager.getColor("MenuItem.acceleratorSelectionForeground") : UIManager.getColor("MenuItem.acceleratorForeground"));
        }
    }
}

