/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailViewImpl
extends JPanel
implements DetailView,
UserDataHolder {
    private final Project myProject;
    private final UserDataHolderBase myDataHolderBase = new UserDataHolderBase();
    private final JLabel myLabel = new JLabel("", 0);
    private Editor myEditor;
    private ItemWrapper myWrapper;
    private JPanel myDetailPanel;
    private JPanel myDetailPanelWrapper;
    private RangeHighlighter myHighlighter;
    private DetailView.PreviewEditorState myEditorState = DetailView.PreviewEditorState.EMPTY;
    private String myEmptyLabel = UIBundle.message("message.nothingToShow", new Object[0]);

    public DetailViewImpl(Project project2) {
        super(new BorderLayout());
        this.myProject = project2;
        this.setPreferredSize(JBUI.size(600, 300));
        this.myLabel.setVerticalAlignment(0);
    }

    @Override
    public void clearEditor() {
        if (this.getEditor() != null) {
            this.clearHighlighting();
            this.remove(this.getEditor().getComponent());
            EditorFactory.getInstance().releaseEditor(this.getEditor());
            this.myEditorState = DetailView.PreviewEditorState.EMPTY;
            this.setEditor(null);
            this.repaint();
        }
    }

    @Override
    public void setCurrentItem(@Nullable ItemWrapper wrapper2) {
        this.myWrapper = wrapper2;
    }

    @Override
    public DetailView.PreviewEditorState getEditorState() {
        return this.myEditorState;
    }

    @Override
    public ItemWrapper getCurrentItem() {
        return this.myWrapper;
    }

    @Override
    public boolean hasEditorOnly() {
        return false;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify(this)) {
            this.clearEditor();
        }
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    public void setEditor(Editor editor) {
        this.myEditor = editor;
    }

    @Override
    public void navigateInPreviewEditor(DetailView.PreviewEditorState editorState) {
        VirtualFile file2 = editorState.getFile();
        LogicalPosition positionToNavigate = editorState.getNavigate();
        TextAttributes lineAttributes = editorState.getAttributes();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        this.clearEditor();
        this.myEditorState = editorState;
        this.remove(this.myLabel);
        if (document != null) {
            if (this.getEditor() == null || this.getEditor().getDocument() != document) {
                this.setEditor(this.createEditor(this.myProject, document, file2));
                this.add((Component)this.getEditor().getComponent(), "Center");
            }
            if (positionToNavigate != null) {
                this.getEditor().getCaretModel().moveToLogicalPosition(positionToNavigate);
                this.validate();
                this.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
            } else {
                this.revalidate();
                this.repaint();
            }
            this.clearHighlighting();
            if (lineAttributes != null && positionToNavigate != null && positionToNavigate.line < this.getEditor().getDocument().getLineCount()) {
                this.myHighlighter = this.getEditor().getMarkupModel().addLineHighlighter(positionToNavigate.line, 5999, lineAttributes);
            }
        } else {
            this.myLabel.setText("Navigate to selected " + (file2.isDirectory() ? "directory " : "file ") + "in Project View");
            this.add((Component)this.myLabel, "Center");
            this.validate();
        }
    }

    @NotNull
    protected Editor createEditor(@Nullable Project project2, Document document, VirtualFile file2) {
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createViewer(document, project2, EditorKind.PREVIEW);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file2, scheme, project2);
        editor.setFile(file2);
        editor.setHighlighter(highlighter);
        EditorSettings settings = editor.getSettings();
        settings.setAnimatedScrolling(false);
        settings.setRefrainFromScrolling(false);
        settings.setLineNumbersShown(true);
        settings.setFoldingOutlineShown(false);
        editor.getFoldingModel().setFoldingEnabled(false);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            DetailViewImpl.$$$reportNull$$$0(0);
        }
        return editorEx;
    }

    private void clearHighlighting() {
        if (this.myHighlighter != null) {
            this.getEditor().getMarkupModel().removeHighlighter(this.myHighlighter);
            this.myHighlighter = null;
        }
    }

    @Override
    public JPanel getPropertiesPanel() {
        return this.myDetailPanel;
    }

    @Override
    public void setPropertiesPanel(@Nullable JPanel panel2) {
        if (panel2 == null) {
            if (this.myDetailPanelWrapper != null) {
                this.myDetailPanelWrapper.removeAll();
            }
            this.myLabel.setText(this.myEmptyLabel);
            this.add((Component)this.myLabel, "Center");
        } else if (panel2 != this.myDetailPanel) {
            this.remove(this.myLabel);
            if (this.myDetailPanelWrapper == null) {
                this.myDetailPanelWrapper = new JPanel(new GridLayout(1, 1));
                this.myDetailPanelWrapper.setBorder(JBUI.Borders.empty(5));
                this.myDetailPanelWrapper.add(panel2);
                this.add((Component)this.myDetailPanelWrapper, "North");
            } else {
                this.myDetailPanelWrapper.removeAll();
                this.myDetailPanelWrapper.add(panel2);
            }
        }
        this.myDetailPanel = panel2;
        this.revalidate();
        this.repaint();
    }

    public void setEmptyLabel(String text2) {
        this.myEmptyLabel = text2;
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            DetailViewImpl.$$$reportNull$$$0(1);
        }
        return this.myDataHolderBase.getUserData(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            DetailViewImpl.$$$reportNull$$$0(2);
        }
        this.myDataHolderBase.putUserData(key, value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/util/DetailViewImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/util/DetailViewImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

