/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.render;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class RenderingHelper {
    public static final Key<Boolean> SHRINK_LONG_RENDERER = Key.create("SHRINK_LONG_RENDERER");
    private final Rectangle myViewBounds;
    private final int myHintIndex;
    private int myRightMargin;
    private boolean myShrinkingDisabled;

    @ApiStatus.Internal
    public RenderingHelper(@NotNull JComponent component2) {
        if (component2 == null) {
            RenderingHelper.$$$reportNull$$$0(0);
        }
        this.myViewBounds = new Rectangle(component2.getWidth(), component2.getHeight());
        this.myHintIndex = RenderingHelper.getExpandableHintIndex(component2);
        Container parent = component2.getParent();
        if (parent instanceof JViewport) {
            this.myViewBounds.setBounds(-component2.getX(), -component2.getY(), parent.getWidth(), parent.getHeight());
            parent = parent.getParent();
            if (parent instanceof JScrollPane) {
                JScrollBar vsb;
                JScrollPane pane2 = (JScrollPane)parent;
                JScrollBar hsb = pane2.getHorizontalScrollBar();
                if (hsb != null && hsb.isVisible()) {
                    this.myShrinkingDisabled = RenderingHelper.isClientPropertyFalse(component2, SHRINK_LONG_RENDERER, false);
                }
                if ((vsb = pane2.getVerticalScrollBar()) != null && vsb.isVisible() && !vsb.isOpaque() && RenderingHelper.isClientPropertyFalse(vsb, JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS, SystemInfo.isMac)) {
                    this.myRightMargin = vsb.getWidth();
                }
            }
        }
    }

    public int getX() {
        return this.myViewBounds.x;
    }

    public int getY() {
        return this.myViewBounds.y;
    }

    public int getWidth() {
        return this.myViewBounds.width;
    }

    public int getHeight() {
        return this.myViewBounds.height;
    }

    public int getRightMargin() {
        return this.myRightMargin;
    }

    public boolean isRendererShrinkingDisabled(int index) {
        return this.myShrinkingDisabled || this.isExpandableHintShown(index);
    }

    public boolean isExpandableHintShown(int index) {
        return this.myHintIndex == index;
    }

    private static int getExpandableHintIndex(@NotNull JComponent component2) {
        if (component2 == null) {
            RenderingHelper.$$$reportNull$$$0(1);
        }
        if (component2 instanceof ComponentWithExpandableItems) {
            Object item;
            ComponentWithExpandableItems c = (ComponentWithExpandableItems)((Object)component2);
            Collection items = c.getExpandableItemsHandler().getExpandedItems();
            Object v0 = item = items.isEmpty() ? null : items.iterator().next();
            if (item instanceof Integer) {
                return item;
            }
        }
        return -1;
    }

    private static boolean isClientPropertyFalse(@NotNull JComponent component2, @NotNull Object key, boolean strict) {
        if (component2 == null) {
            RenderingHelper.$$$reportNull$$$0(2);
        }
        if (key == null) {
            RenderingHelper.$$$reportNull$$$0(3);
        }
        Object property = component2.getClientProperty(key);
        return strict ? Boolean.FALSE.equals(property) : !Boolean.TRUE.equals(property);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/render/RenderingHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpandableHintIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isClientPropertyFalse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

