/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.roots;

import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class FilePathClipper
implements ComponentListener {
    private final File myFile;
    private final JLabel myLabelToClip;
    private final JComponent myComponentToWatch;

    private FilePathClipper(JLabel labelToClip, JComponent componentToWatch) {
        this.myLabelToClip = labelToClip;
        this.myComponentToWatch = componentToWatch;
        String text2 = labelToClip.getText();
        this.myFile = new File(text2 != null ? text2 : "");
    }

    public static void install(JLabel labelToClip, JComponent componentToWatch) {
        componentToWatch.addComponentListener(new FilePathClipper(labelToClip, componentToWatch));
    }

    @Override
    public void componentResized(ComponentEvent e) {
        String optimalTextForComponent = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR.getOptimalTextForComponent(this.myFile, this.myLabelToClip, this.myComponentToWatch.getWidth());
        this.myLabelToClip.setText(optimalTextForComponent);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

