/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Function;
import javax.swing.JList;
import javax.swing.ListModel;

public class NameFilteringListModel<T>
extends FilteringListModel<T> {
    private final Function<? super T, String> myNamer;
    private int myFullMatchIndex = -1;
    private int myStartsWithIndex = -1;
    private final Computable<String> myPattern;

    @Deprecated
    public NameFilteringListModel(JList<T> list2, Function<? super T, String> namer, Condition<? super String> filter2, SpeedSearchSupply speedSearch) {
        this(list2.getModel(), namer, filter2, () -> StringUtil.notNullize(speedSearch.getEnteredPrefix()));
        list2.setModel(this);
    }

    public NameFilteringListModel(ListModel<T> model, Function<? super T, String> namer, Condition<? super String> filter2, Computable<String> pattern) {
        super(model);
        this.myPattern = pattern;
        this.myNamer = namer;
        this.setFilter(namer != null ? t -> filter2.value((String)namer.fun(t)) : null);
    }

    @Override
    protected void addToFiltered(T elt) {
        String name;
        super.addToFiltered(elt);
        if (this.myNamer != null && (name = this.myNamer.fun(elt)) != null) {
            String filterString = StringUtil.toUpperCase(this.myPattern.compute());
            String candidateString = StringUtil.toUpperCase(name);
            int index = this.getSize() - 1;
            if (this.myFullMatchIndex == -1 && filterString.equals(candidateString)) {
                this.myFullMatchIndex = index;
            }
            if (this.myStartsWithIndex == -1 && candidateString.startsWith(filterString)) {
                this.myStartsWithIndex = index;
            }
        }
    }

    @Override
    public void refilter() {
        this.myFullMatchIndex = -1;
        this.myStartsWithIndex = -1;
        super.refilter();
    }

    public int getClosestMatchIndex() {
        return this.myFullMatchIndex != -1 ? this.myFullMatchIndex : this.myStartsWithIndex;
    }
}

