/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.FList;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpeedSearchUtil {
    private SpeedSearchUtil() {
    }

    public static void applySpeedSearchHighlighting(@NotNull JComponent speedSearchEnabledComponent, @NotNull SimpleColoredComponent coloredComponent, boolean mainTextOnly, boolean selected2) {
        Iterator<TextRange> rangesIterator;
        SpeedSearchSupply speedSearch;
        if (speedSearchEnabledComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(0);
        }
        if (coloredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(1);
        }
        Iterable<TextRange> ranges2 = (speedSearch = SpeedSearchSupply.getSupply(speedSearchEnabledComponent)) == null ? null : speedSearch.matchingFragments(coloredComponent.getCharSequence(mainTextOnly).toString());
        Iterator<TextRange> iterator2 = rangesIterator = ranges2 != null ? ranges2.iterator() : null;
        if (rangesIterator == null || !rangesIterator.hasNext()) {
            return;
        }
        Color bg = UIUtil.getTreeBackground(selected2, true);
        SimpleColoredComponent.ColoredIterator coloredIterator = coloredComponent.iterator();
        TextRange range2 = rangesIterator.next();
        block0: while (coloredIterator.hasNext()) {
            coloredIterator.next();
            int offset = coloredIterator.getOffset();
            int endOffset = coloredIterator.getEndOffset();
            if (!range2.intersectsStrict(offset, endOffset)) continue;
            SimpleTextAttributes attributes = coloredIterator.getTextAttributes();
            SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, attributes.getFgColor(), null, attributes.getStyle() | 0x40);
            do {
                if (range2.getStartOffset() > offset) {
                    offset = coloredIterator.split(range2.getStartOffset() - offset, attributes);
                }
                if (range2.getEndOffset() <= endOffset) {
                    offset = coloredIterator.split(range2.getEndOffset() - offset, highlighted);
                    if (!rangesIterator.hasNext()) break block0;
                } else {
                    coloredIterator.split(endOffset - offset, highlighted);
                    continue block0;
                }
                range2 = rangesIterator.next();
            } while (range2.intersectsStrict(offset, endOffset));
        }
    }

    public static void appendFragmentsForSpeedSearch(@NotNull JComponent speedSearchEnabledComponent, @NotNull String text2, @NotNull SimpleTextAttributes attributes, boolean selected2, @NotNull SimpleColoredComponent simpleColoredComponent) {
        Iterable<TextRange> fragments;
        SpeedSearchSupply speedSearch;
        if (speedSearchEnabledComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            SpeedSearchUtil.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            SpeedSearchUtil.$$$reportNull$$$0(4);
        }
        if (simpleColoredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(5);
        }
        if ((speedSearch = SpeedSearchSupply.getSupply(speedSearchEnabledComponent)) != null && (fragments = speedSearch.matchingFragments(text2)) != null) {
            Color fg = attributes.getFgColor();
            Color bg = UIUtil.getTreeBackground(selected2, true);
            int style = attributes.getStyle();
            SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, fg, null, style | 0x40);
            SpeedSearchUtil.appendColoredFragments(simpleColoredComponent, text2, fragments, plain, highlighted);
            return;
        }
        simpleColoredComponent.append(text2, attributes);
    }

    public static void appendColoredFragmentForMatcher(@NotNull String text2, SimpleColoredComponent component2, @NotNull SimpleTextAttributes attributes, @Nullable Matcher matcher, Color selectedBg, boolean selected2) {
        if (text2 == null) {
            SpeedSearchUtil.$$$reportNull$$$0(6);
        }
        if (attributes == null) {
            SpeedSearchUtil.$$$reportNull$$$0(7);
        }
        if (!(matcher instanceof MinusculeMatcher) || Registry.is("ide.highlight.match.in.selected.only") && !selected2) {
            component2.append(text2, attributes);
            return;
        }
        FList<TextRange> iterable = ((MinusculeMatcher)matcher).matchingFragments(text2);
        if (iterable != null) {
            Color fg = attributes.getFgColor();
            int style = attributes.getStyle();
            SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(selectedBg, fg, null, style | 0x40);
            SpeedSearchUtil.appendColoredFragments(component2, text2, iterable, plain, highlighted);
        } else {
            component2.append(text2, attributes);
        }
    }

    public static void appendColoredFragments(SimpleColoredComponent simpleColoredComponent, String text2, Iterable<? extends TextRange> colored, SimpleTextAttributes plain, SimpleTextAttributes highlighted) {
        ArrayList<Pair<String, Integer>> searchTerms = new ArrayList<Pair<String, Integer>>();
        for (TextRange textRange : colored) {
            searchTerms.add(Pair.create(textRange.substring(text2), textRange.getStartOffset()));
        }
        int lastOffset = 0;
        for (Pair pair : searchTerms) {
            if ((Integer)pair.second > lastOffset) {
                simpleColoredComponent.append(text2.substring(lastOffset, (Integer)pair.second), plain);
            }
            simpleColoredComponent.append(text2.substring((Integer)pair.second, (Integer)pair.second + ((String)pair.first).length()), highlighted);
            lastOffset = (Integer)pair.second + ((String)pair.first).length();
        }
        if (lastOffset < text2.length()) {
            simpleColoredComponent.append(text2.substring(lastOffset), plain);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "speedSearchEnabledComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleColoredComponent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/speedSearch/SpeedSearchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applySpeedSearchHighlighting";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendFragmentsForSpeedSearch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "appendColoredFragmentForMatcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

