/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tabs.ColorSelectionComponent;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileColorConfigurationEditDialog
extends DialogWrapper {
    private FileColorConfiguration myConfiguration;
    private JComboBox myScopeComboBox;
    private final FileColorManager myManager;
    private final ColorSelectionComponent myColorSelectionComponent;
    private final Map<String, NamedScope> myScopeNames;

    public FileColorConfigurationEditDialog(@NotNull FileColorManager manager, @Nullable FileColorConfiguration configuration) {
        if (manager == null) {
            FileColorConfigurationEditDialog.$$$reportNull$$$0(0);
        }
        super(true);
        this.myScopeNames = new HashMap<String, NamedScope>();
        this.setTitle(configuration == null ? UIBundle.message("dialog.title.add.color.label", new Object[0]) : UIBundle.message("dialog.title.edit.color.label", new Object[0]));
        this.setResizable(false);
        this.myManager = manager;
        this.myConfiguration = configuration;
        this.myColorSelectionComponent = new ColorSelectionComponent();
        this.myColorSelectionComponent.initDefault(manager, configuration == null ? null : configuration.getColorName());
        this.myColorSelectionComponent.setChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FileColorConfigurationEditDialog.this.updateOKButton();
            }
        });
        this.init();
        this.updateCustomButton();
        if (this.myConfiguration != null && !StringUtil.isEmpty(this.myConfiguration.getScopeName())) {
            this.myScopeComboBox.setSelectedItem(this.myConfiguration.getScopeName());
        }
        this.updateOKButton();
    }

    public JComboBox getScopeComboBox() {
        return this.myScopeComboBox;
    }

    @Override
    protected JComponent createNorthPanel() {
        ArrayList<NamedScope> scopeList = new ArrayList<NamedScope>();
        Project project2 = this.myManager.getProject();
        NamedScopesHolder[] scopeHolders = NamedScopesHolder.getAllNamedScopeHolders(project2);
        for (NamedScopesHolder scopeHolder : scopeHolders) {
            NamedScope[] scopes = scopeHolder.getScopes();
            Collections.addAll(scopeList, scopes);
        }
        CustomScopesProviderEx.filterNoSettingsScopes(project2, scopeList);
        for (NamedScope scope : scopeList) {
            this.myScopeNames.put(scope.getName(), scope);
        }
        this.myScopeComboBox = new ComboBox<String>(ArrayUtilRt.toStringArray(this.myScopeNames.keySet()));
        this.myScopeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileColorConfigurationEditDialog.this.updateCustomButton();
                FileColorConfigurationEditDialog.this.updateOKButton();
            }
        });
        new ComboboxSpeedSearch(this.myScopeComboBox);
        JLabel pathLabel = new JLabel(UIBundle.message("label.scope", new Object[0]));
        pathLabel.setDisplayedMnemonic('S');
        pathLabel.setLabelFor(this.myScopeComboBox);
        JLabel colorLabel = new JLabel(UIBundle.message("label.color", new Object[0]));
        JPanel result2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = JBUI.insets(5);
        gbc.gridx = 0;
        result2.add((Component)pathLabel, gbc);
        result2.add((Component)colorLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        result2.add((Component)this.myScopeComboBox, gbc);
        result2.add((Component)this.myColorSelectionComponent, gbc);
        return result2;
    }

    private void updateCustomButton() {
        Object item = this.myScopeComboBox.getSelectedItem();
        if (item instanceof String) {
            Color color = this.myConfiguration == null ? null : ColorUtil.fromHex(this.myConfiguration.getColorName(), null);
            NamedScope scope = this.myScopeNames.get(item);
            String colorName = scope.getDefaultColorName();
            if (color == null && StringUtil.isNotEmpty(colorName)) {
                color = this.myManager.getColor(colorName);
            }
            if (color != null) {
                if (StringUtil.isNotEmpty(colorName) && color.equals(this.myManager.getColor(colorName))) {
                    this.myColorSelectionComponent.setSelectedColor(colorName);
                } else {
                    this.myColorSelectionComponent.setCustomButtonColor(color);
                }
            }
        }
    }

    @Override
    protected void doOKAction() {
        this.close(0);
        if (this.myConfiguration != null) {
            this.myConfiguration.setScopeName((String)this.myScopeComboBox.getSelectedItem());
            this.myConfiguration.setColorName(this.getColorName());
        } else {
            this.myConfiguration = new FileColorConfiguration((String)this.myScopeComboBox.getSelectedItem(), this.getColorName());
        }
    }

    public FileColorConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Nullable
    private String getColorName() {
        return this.myColorSelectionComponent.getSelectedColorName();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myScopeComboBox.isEnabled() ? this.myScopeComboBox : this.myColorSelectionComponent;
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    @Override
    public boolean isOKActionEnabled() {
        String scopeName = (String)this.myScopeComboBox.getSelectedItem();
        return scopeName != null && scopeName.length() > 0 && this.getColorName() != null;
    }

    @Override
    protected JComponent createCenterPanel() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ui/tabs/FileColorConfigurationEditDialog", "<init>"));
    }
}

