/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorsModel;
import com.intellij.ui.tabs.PerTeamFileColorModelStorageManager;
import com.intellij.ui.tabs.PerUserFileColorModelStorageManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileColorManagerImpl
extends FileColorManager {
    public static final String FC_ENABLED = "FileColorsEnabled";
    public static final String FC_TABS_ENABLED = "FileColorsForTabsEnabled";
    public static final String FC_PROJECT_VIEW_ENABLED = "FileColorsForProjectViewEnabled";
    private final Project myProject;
    private final FileColorsModel myModel;
    private final NotNullLazyValue<FileColorsModel> myInitializedModel;
    private static final Map<String, Color> ourDefaultColors = ContainerUtil.immutableMapBuilder().put("Blue", JBColor.namedColor("FileColor.Blue", new JBColor(15398655, 5199211))).put("Green", JBColor.namedColor("FileColor.Green", new JBColor(15727335, 4805706))).put("Orange", JBColor.namedColor("FileColor.Orange", new JBColor(16181724, 8413266))).put("Rose", JBColor.namedColor("FileColor.Rose", new JBColor(15916250, 7230299))).put("Violet", JBColor.namedColor("FileColor.Violet", new JBColor(15130865, 5458519))).put("Yellow", JBColor.namedColor("FileColor.Yellow", new JBColor(0xFFFFE4, 5196609))).build();

    public FileColorManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myModel = new FileColorsModel(project2);
        this.myInitializedModel = NotNullLazyValue.createValue(() -> {
            project2.getService(PerTeamFileColorModelStorageManager.class);
            project2.getService(PerUserFileColorModelStorageManager.class);
            return this.myModel;
        });
    }

    @Override
    public boolean isEnabled() {
        return FileColorManagerImpl._isEnabled();
    }

    public static boolean _isEnabled() {
        return PropertiesComponent.getInstance().getBoolean(FC_ENABLED, true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_ENABLED, enabled, true);
    }

    public void setEnabledForTabs(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_TABS_ENABLED, Boolean.toString(enabled));
    }

    @Override
    public boolean isEnabledForTabs() {
        return FileColorManagerImpl._isEnabledForTabs();
    }

    public static boolean _isEnabledForTabs() {
        return PropertiesComponent.getInstance().getBoolean(FC_TABS_ENABLED, true);
    }

    @Override
    public boolean isEnabledForProjectView() {
        return FileColorManagerImpl._isEnabledForProjectView();
    }

    public static boolean _isEnabledForProjectView() {
        return PropertiesComponent.getInstance().getBoolean(FC_PROJECT_VIEW_ENABLED, true);
    }

    public static void setEnabledForProjectView(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_PROJECT_VIEW_ENABLED, Boolean.toString(enabled));
    }

    @Override
    @Nullable
    public Color getColor(@NotNull String name) {
        Color color;
        if (name == null) {
            FileColorManagerImpl.$$$reportNull$$$0(1);
        }
        return (color = ourDefaultColors.get(name)) == null ? ColorUtil.fromHex(name, null) : color;
    }

    @Override
    public Collection<String> getColorNames() {
        ArrayList<String> sorted = new ArrayList<String>(ourDefaultColors.keySet());
        Collections.sort(sorted);
        return sorted;
    }

    @Override
    @Nullable
    public Color getRendererBackground(VirtualFile vFile) {
        Color fileColor;
        if (vFile == null) {
            return null;
        }
        if (this.isEnabled() && (fileColor = this.getFileColor(vFile)) != null) {
            return fileColor;
        }
        return null;
    }

    @Override
    @Nullable
    public Color getRendererBackground(PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return this.getRendererBackground(vFile);
    }

    @Override
    public void addScopeColor(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(2);
        }
        if (colorName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(3);
        }
        this.myInitializedModel.getValue().add(scopeName, colorName, isProjectLevel);
    }

    @Override
    @Nullable
    public Color getFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(4);
        }
        if (!this.isEnabled()) {
            return null;
        }
        String colorName = this.myInitializedModel.getValue().getColor(file2, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    @Override
    @Nullable
    public Color getScopeColor(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(5);
        }
        if (!this.isEnabled()) {
            return null;
        }
        String colorName = this.myInitializedModel.getValue().getScopeColor(scopeName, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    @Override
    public boolean isShared(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(6);
        }
        return this.myInitializedModel.getValue().isProjectLevel(scopeName);
    }

    @NotNull
    FileColorsModel getModel() {
        FileColorsModel fileColorsModel = this.myInitializedModel.getValue();
        if (fileColorsModel == null) {
            FileColorManagerImpl.$$$reportNull$$$0(7);
        }
        return fileColorsModel;
    }

    @NotNull
    FileColorsModel getUninitializedModel() {
        FileColorsModel fileColorsModel = this.myModel;
        if (fileColorsModel == null) {
            FileColorManagerImpl.$$$reportNull$$$0(8);
        }
        return fileColorsModel;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<FileColorConfiguration> getApplicationLevelConfigurations() {
        List<FileColorConfiguration> list2 = this.myInitializedModel.getValue().getLocalConfigurations();
        if (list2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return this.myInitializedModel.getValue().getProjectLevelConfigurations();
    }

    @Nullable
    public static String getColorName(@NotNull Color color) {
        if (color == null) {
            FileColorManagerImpl.$$$reportNull$$$0(10);
        }
        for (String name : ourDefaultColors.keySet()) {
            if (!color.equals(ourDefaultColors.get(name))) continue;
            return name;
        }
        return null;
    }

    static String getAlias(String text2) {
        return StartupUiUtil.isUnderDarcula() && text2.equals("Yellow") ? "Brown" : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/FileColorManagerImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/FileColorManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationLevelConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addScopeColor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileColor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getScopeColor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isShared";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColorName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

