/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.TimedDeadzone;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;

class ActionButton
extends IconButton
implements ActionListener {
    private final InplaceButton myButton;
    private Presentation myPrevPresentation;
    private final AnAction myAction;
    private final String myPlace;
    private final TabInfo myTabInfo;
    private boolean myAutoHide;
    private boolean myToShow;

    ActionButton(TabInfo tabInfo, AnAction action2, String place, Consumer<MouseEvent> pass, final Consumer<Boolean> hover, TimedDeadzone.Length deadzone) {
        super((String)null, action2.getTemplatePresentation().getIcon());
        this.myTabInfo = tabInfo;
        this.myAction = action2;
        this.myPlace = place;
        final MouseAdapter myListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                hover.accept(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                hover.accept(false);
            }
        };
        this.myButton = new InplaceButton(this, this, pass, deadzone){

            @Override
            protected void doRepaintComponent(Component c) {
                ActionButton.this.repaintComponent(c);
            }

            @Override
            public void addNotify() {
                super.addNotify();
                ActionButton.this.myButton.addMouseListener(myListener);
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                ActionButton.this.myButton.removeMouseListener(myListener);
            }
        };
        this.myButton.setVisible(false);
        this.myButton.setFillBg(false);
    }

    public InplaceButton getComponent() {
        return this.myButton;
    }

    protected void repaintComponent(Component c) {
        c.repaint();
    }

    public void setMouseDeadZone(TimedDeadzone.Length deadZone) {
        this.myButton.setMouseDeadzone(deadZone);
    }

    public boolean update() {
        AnActionEvent event = this.createAnEvent(0);
        this.myAction.update(event);
        Presentation p = event.getPresentation();
        boolean changed2 = !ActionButton.areEqual(p, this.myPrevPresentation);
        this.setIcons(p.getIcon(), p.getDisabledIcon(), p.getHoveredIcon());
        if (changed2) {
            this.myButton.setIcons(this);
            String tooltipText = KeymapUtil.createTooltipText(p.getText(), this.myAction);
            this.myButton.setToolTipText(tooltipText.length() > 0 ? tooltipText : null);
            this.myButton.setVisible(p.isEnabled() && p.isVisible());
        }
        this.myPrevPresentation = p;
        return changed2;
    }

    private static boolean areEqual(Presentation p1, Presentation p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        return Comparing.equal(p1.getText(), p2.getText()) && Comparing.equal(p1.getIcon(), p2.getIcon()) && Comparing.equal(p1.getHoveredIcon(), p2.getHoveredIcon()) && p1.isEnabled() == p2.isEnabled() && p1.isVisible() == p2.isVisible();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AnActionEvent event = this.createAnEvent(e.getModifiers());
        if (ActionUtil.lastUpdateAndCheckDumb(this.myAction, event, true)) {
            ActionUtil.performActionDumbAware(this.myAction, event);
        }
    }

    private AnActionEvent createAnEvent(int modifiers) {
        Presentation presentation = this.myAction.getTemplatePresentation().clone();
        DataContext context = DataManager.getInstance().getDataContext(this.myTabInfo.getComponent());
        return new AnActionEvent(null, context, this.myPlace != null ? this.myPlace : "unknown", presentation, ActionManager.getInstance(), modifiers);
    }

    public void setAutoHide(boolean autoHide) {
        this.myAutoHide = autoHide;
        if (!this.myToShow) {
            this.toggleShowActions(false);
        }
    }

    public void toggleShowActions(boolean show2) {
        if (this.myAutoHide) {
            this.myButton.setPainting(show2);
        } else {
            this.myButton.setPainting(true);
        }
        this.myToShow = show2;
    }
}

