/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/tabs/impl/DefaultTabPainterAdapter;", "Lcom/intellij/ui/tabs/impl/TabPainterAdapter;", "painter", "Lcom/intellij/ui/tabs/JBTabPainter;", "(Lcom/intellij/ui/tabs/JBTabPainter;)V", "getPainter", "()Lcom/intellij/ui/tabs/JBTabPainter;", "tabPainter", "getTabPainter", "paintBackground", "", "label", "Lcom/intellij/ui/tabs/impl/TabLabel;", "g", "Ljava/awt/Graphics;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "intellij.platform.ide"})
public final class DefaultTabPainterAdapter
implements TabPainterAdapter {
    @NotNull
    private final JBTabPainter painter;

    @Override
    @NotNull
    public JBTabPainter getTabPainter() {
        return this.painter;
    }

    @Override
    public void paintBackground(@NotNull TabLabel label2, @NotNull Graphics g, @NotNull JBTabsImpl tabs) {
        Intrinsics.checkParameterIsNotNull((Object)label2, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)tabs, (String)"tabs");
        TabInfo info = label2.getInfo();
        boolean isSelected = Intrinsics.areEqual((Object)info, (Object)tabs.getSelectedInfo());
        Rectangle rect = new Rectangle(0, 0, label2.getWidth(), label2.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        if (isSelected && tabs.getVisibleInfos().size() > 1) {
            JBTabsPosition jBTabsPosition = tabs.getPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jBTabsPosition), (String)"tabs.position");
            int n = tabs.getBorderThickness();
            TabInfo tabInfo = info;
            Intrinsics.checkExpressionValueIsNotNull((Object)tabInfo, (String)"info");
            this.painter.paintSelectedTab(jBTabsPosition, g2d, rect, n, tabInfo.getTabColor(), tabs.isActiveTabs(info), tabs.isHoveredTab(label2));
        } else {
            JBTabsPosition jBTabsPosition = tabs.getPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jBTabsPosition), (String)"tabs.position");
            int n = tabs.getBorderThickness();
            TabInfo tabInfo = info;
            Intrinsics.checkExpressionValueIsNotNull((Object)tabInfo, (String)"info");
            this.painter.paintTab(jBTabsPosition, g2d, rect, n, tabInfo.getTabColor(), tabs.isActiveTabs(info), tabs.isHoveredTab(label2) && tabs.getVisibleInfos().size() > 1);
        }
    }

    @NotNull
    public final JBTabPainter getPainter() {
        return this.painter;
    }

    public DefaultTabPainterAdapter(@NotNull JBTabPainter painter) {
        Intrinsics.checkParameterIsNotNull((Object)painter, (String)"painter");
        this.painter = painter;
    }

    @Override
    @NotNull
    public TabTheme getTabTheme() {
        return TabPainterAdapter.DefaultImpls.getTabTheme(this);
    }
}

