/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CompressibleSingleRowLayout
extends SingleRowLayout {
    public CompressibleSingleRowLayout(JBTabsImpl tabs) {
        super(tabs);
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data2) {
        this.calculateRequiredLength(data2);
    }

    @Override
    protected void layoutLabels(SingleRowPassInfo data2) {
        if (this.myTabs.getPresentation().getTabsPosition() != JBTabsPosition.top && this.myTabs.getPresentation().getTabsPosition() != JBTabsPosition.bottom) {
            super.layoutLabels(data2);
            return;
        }
        int maxGridSize = 0;
        int spentLength = 0;
        int lengthEstimation = 0;
        int[] lengths = new int[data2.toLayout.size()];
        List<TabInfo> layout = data2.toLayout;
        for (int i = 0; i < layout.size(); ++i) {
            int lengthIncrement;
            TabLabel label2 = this.myTabs.myInfo2Label.get(layout.get(i));
            if (maxGridSize == 0) {
                Font font = label2.getLabelComponent().getFont();
                maxGridSize = GraphicsUtil.stringWidth("m", font == null ? JBFont.label() : font) * this.myTabs.tabMSize();
            }
            lengths[i] = lengthIncrement = label2.getPreferredSize().width;
            lengthEstimation += lengthIncrement;
        }
        int extraWidth = data2.toFitLength - lengthEstimation;
        Arrays.sort(lengths);
        double acc = 0.0;
        int actualGridSize = 0;
        for (int i = 0; i < lengths.length; ++i) {
            int length = lengths[i];
            actualGridSize = (int)Math.min((double)maxGridSize, ((acc += (double)length) + (double)extraWidth) / (double)(i + 1));
            if (i < lengths.length - 1 && actualGridSize < lengths[i + 1]) break;
        }
        Iterator<TabInfo> iterator2 = data2.toLayout.iterator();
        while (iterator2.hasNext()) {
            TabLabel label3 = this.myTabs.myInfo2Label.get(iterator2.next());
            int lengthIncrement = label3.getPreferredSize().width;
            int length = !iterator2.hasNext() ? Math.min(data2.toFitLength - spentLength, Math.max(actualGridSize, lengthIncrement)) : (extraWidth <= 0 ? (int)((float)lengthIncrement * (float)data2.toFitLength / (float)lengthEstimation) : Math.max(lengthIncrement, actualGridSize));
            spentLength += length + this.myTabs.getTabHGap();
            this.applyTabLayout(data2, label3, length);
            data2.position = (int)label3.getBounds().getMaxX() + this.myTabs.getTabHGap();
        }
        for (TabInfo eachInfo : data2.toDrop) {
            JBTabsImpl.resetLayout(this.myTabs.myInfo2Label.get(eachInfo));
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data2, TabLabel label2, int length) {
        boolean result2 = super.applyTabLayout(data2, label2, length);
        label2.setAlignmentToCenter(false);
        return result2;
    }
}

