/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ScrollableSingleRowLayout
extends SingleRowLayout {
    public static final int DEADZONE_FOR_DECLARE_TAB_HIDDEN = 10;
    private int myScrollOffset = 0;
    private boolean myScrollSelectionInViewPending = false;

    public ScrollableSingleRowLayout(JBTabsImpl tabs) {
        super(tabs);
    }

    @Override
    int getScrollOffset() {
        return this.myScrollOffset;
    }

    @Override
    public void scroll(int units) {
        this.myScrollOffset += units;
        this.clampScrollOffsetToBounds(this.myLastSingRowLayout);
    }

    @Override
    protected boolean checkLayoutLabels(SingleRowPassInfo data2) {
        if (this.myScrollSelectionInViewPending) {
            return true;
        }
        return super.checkLayoutLabels(data2);
    }

    private void clampScrollOffsetToBounds(@Nullable SingleRowPassInfo data2) {
        if (data2 == null) {
            return;
        }
        this.myScrollOffset = data2.requiredLength < data2.toFitLength ? 0 : Math.max(0, Math.min(this.myScrollOffset, data2.requiredLength - data2.toFitLength + this.getStrategy().getMoreRectAxisSize()));
    }

    @Override
    public void scrollSelectionInView() {
        this.myScrollSelectionInViewPending = true;
    }

    @Override
    public int getScrollUnitIncrement() {
        List visibleInfos;
        if (this.myLastSingRowLayout != null && (visibleInfos = this.myLastSingRowLayout.myVisibleInfos).size() > 0) {
            TabInfo info = (TabInfo)visibleInfos.get(0);
            return this.getStrategy().getScrollUnitIncrement(this.myTabs.myInfo2Label.get(info));
        }
        return 0;
    }

    private void doScrollSelectionInView(SingleRowPassInfo passInfo) {
        if (this.myTabs.isMouseInsideTabsArea()) {
            return;
        }
        int offset = -this.myScrollOffset;
        for (TabInfo info : passInfo.myVisibleInfos) {
            int length = this.getRequiredLength(info);
            if (info == this.myTabs.getSelectedInfo()) {
                if (offset < 0) {
                    this.scroll(offset);
                    break;
                }
                int maxLength = passInfo.toFitLength - this.getStrategy().getMoreRectAxisSize();
                if (offset + length <= maxLength) break;
                if (length < maxLength) {
                    this.scroll(offset + length - maxLength);
                    break;
                }
                this.scroll(offset);
                break;
            }
            offset += length;
        }
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data2) {
        this.calculateRequiredLength(data2);
        this.clampScrollOffsetToBounds(data2);
        if (this.myScrollSelectionInViewPending || this.myLastSingRowLayout == null || !data2.layoutSize.equals(this.myLastSingRowLayout.layoutSize)) {
            this.myScrollSelectionInViewPending = false;
            this.doScrollSelectionInView(data2);
            this.clampScrollOffsetToBounds(data2);
        }
    }

    @Override
    protected void layoutMoreButton(SingleRowPassInfo data2) {
        if (data2.requiredLength > data2.toFitLength) {
            data2.moreRect = this.getStrategy().getMoreRect(data2);
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data2, TabLabel label2, int length) {
        int moreRectSize;
        if (data2.requiredLength > data2.toFitLength && data2.position + (length = this.getStrategy().getLengthIncrement(label2.getPreferredSize())) > data2.toFitLength - (moreRectSize = this.getStrategy().getMoreRectAxisSize())) {
            int clippedLength = this.getStrategy().drawPartialOverflowTabs() ? data2.toFitLength - data2.position - moreRectSize : 0;
            super.applyTabLayout(data2, label2, clippedLength);
            label2.setAlignmentToCenter(false);
            return false;
        }
        return super.applyTabLayout(data2, label2, length);
    }

    @Override
    public boolean isTabHidden(TabInfo tabInfo) {
        TabLabel label2 = this.myTabs.myInfo2Label.get(tabInfo);
        Rectangle bounds2 = label2.getBounds();
        return this.getStrategy().getMinPosition(bounds2) < -10 || bounds2.width < label2.getPreferredSize().width - 10 || bounds2.height < label2.getPreferredSize().height - 10;
    }

    @Override
    @Nullable
    protected TabLabel findLastVisibleLabel(SingleRowPassInfo data2) {
        for (int i = data2.toLayout.size() - 1; i >= 0; --i) {
            TabInfo info = data2.toLayout.get(i);
            TabLabel label2 = this.myTabs.myInfo2Label.get(info);
            if (label2.getBounds().isEmpty()) continue;
            return label2;
        }
        return null;
    }
}

