/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayoutStrategy;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleRowLayout
extends TabLayout {
    final JBTabsImpl myTabs;
    public SingleRowPassInfo myLastSingRowLayout;
    private final SingleRowLayoutStrategy myTop;
    private final SingleRowLayoutStrategy myLeft;
    private final SingleRowLayoutStrategy myBottom;
    private final SingleRowLayoutStrategy myRight;

    @Override
    public boolean isSideComponentOnTabs() {
        return this.getStrategy().isSideComponentOnTabs();
    }

    @Override
    public ShapeTransform createShapeTransform(Rectangle labelRec) {
        return this.getStrategy().createShapeTransform(labelRec);
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            SingleRowLayout.$$$reportNull$$$0(0);
        }
        return this.getStrategy().isDragOut(tabLabel, deltaX, deltaY);
    }

    public SingleRowLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
        this.myTop = new SingleRowLayoutStrategy.Top(this);
        this.myLeft = new SingleRowLayoutStrategy.Left(this);
        this.myBottom = new SingleRowLayoutStrategy.Bottom(this);
        this.myRight = new SingleRowLayoutStrategy.Right(this);
    }

    SingleRowLayoutStrategy getStrategy() {
        switch (this.myTabs.getPresentation().getTabsPosition()) {
            case top: {
                return this.myTop;
            }
            case left: {
                return this.myLeft;
            }
            case bottom: {
                return this.myBottom;
            }
            case right: {
                return this.myRight;
            }
        }
        return null;
    }

    protected boolean checkLayoutLabels(SingleRowPassInfo data2) {
        boolean layoutLabels = true;
        if (!this.myTabs.myForcedRelayout && this.myLastSingRowLayout != null && this.myLastSingRowLayout.contentCount == this.myTabs.getTabCount() && this.myLastSingRowLayout.layoutSize.equals(this.myTabs.getSize()) && this.myLastSingRowLayout.scrollOffset == this.getScrollOffset()) {
            for (TabInfo each : data2.myVisibleInfos) {
                TabLabel eachLabel = this.myTabs.myInfo2Label.get(each);
                if (!eachLabel.isValid()) {
                    layoutLabels = true;
                    break;
                }
                if (this.myTabs.getSelectedInfo() != each || eachLabel.getBounds().width == 0) continue;
                layoutLabels = false;
            }
        }
        return layoutLabels;
    }

    int getScrollOffset() {
        return 0;
    }

    public void scroll(int units) {
    }

    public int getScrollUnitIncrement() {
        return 0;
    }

    public void scrollSelectionInView() {
    }

    public LayoutPassInfo layoutSingleRow(List<TabInfo> visibleInfos) {
        SingleRowPassInfo data2 = new SingleRowPassInfo(this, visibleInfos);
        boolean shouldLayoutLabels = this.checkLayoutLabels(data2);
        if (!shouldLayoutLabels) {
            data2 = this.myLastSingRowLayout;
        }
        TabInfo selected2 = this.myTabs.getSelectedInfo();
        this.prepareLayoutPassInfo(data2, selected2);
        this.myTabs.resetLayout(shouldLayoutLabels || this.myTabs.isHideTabs());
        if (shouldLayoutLabels && !this.myTabs.isHideTabs()) {
            this.recomputeToLayout(data2);
            data2.position = this.getStrategy().getStartPosition(data2) - this.getScrollOffset();
            this.layoutLabels(data2);
            this.layoutMoreButton(data2);
        }
        if (selected2 != null) {
            data2.comp = new WeakReference<JComponent>(selected2.getComponent());
            this.getStrategy().layoutComp(data2);
        }
        data2.tabRectangle = new Rectangle();
        if (data2.toLayout.size() > 0) {
            TabLabel firstLabel = this.myTabs.myInfo2Label.get(data2.toLayout.get(0));
            TabLabel lastLabel = this.findLastVisibleLabel(data2);
            if (firstLabel != null && lastLabel != null) {
                data2.tabRectangle.x = firstLabel.getBounds().x;
                data2.tabRectangle.y = firstLabel.getBounds().y;
                data2.tabRectangle.width = (int)lastLabel.getBounds().getMaxX() - data2.tabRectangle.x;
                data2.tabRectangle.height = (int)lastLabel.getBounds().getMaxY() - data2.tabRectangle.y;
            }
        }
        this.myLastSingRowLayout = data2;
        return data2;
    }

    @Nullable
    protected TabLabel findLastVisibleLabel(SingleRowPassInfo data2) {
        return this.myTabs.myInfo2Label.get(data2.toLayout.get(data2.toLayout.size() - 1));
    }

    protected void prepareLayoutPassInfo(SingleRowPassInfo data2, TabInfo selected2) {
        JBTabsImpl.Toolbar selectedToolbar;
        data2.insets = this.myTabs.getLayoutInsets();
        if (this.myTabs.isHorizontalTabs()) {
            data2.insets.left += this.myTabs.getFirstTabOffset();
        }
        data2.hToolbar = new WeakReference<Object>(((selectedToolbar = this.myTabs.myInfo2Toolbar.get(selected2)) != null && this.myTabs.myHorizontalSide && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data2.vToolbar = new WeakReference<Object>((selectedToolbar != null && !this.myTabs.myHorizontalSide && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data2.toFitLength = this.getStrategy().getToFitLength(data2);
    }

    protected void layoutMoreButton(SingleRowPassInfo data2) {
        if (data2.toDrop.size() > 0) {
            data2.moreRect = this.getStrategy().getMoreRect(data2);
        }
    }

    protected void layoutLabels(SingleRowPassInfo data2) {
        boolean layoutStopped = false;
        for (TabInfo eachInfo : data2.toLayout) {
            TabLabel label2 = this.myTabs.myInfo2Label.get(eachInfo);
            if (layoutStopped) {
                Rectangle rec = this.getStrategy().getLayoutRect(data2, 0, 0);
                this.myTabs.layout(label2, rec);
                continue;
            }
            Dimension eachSize = label2.getPreferredSize();
            int length = this.getStrategy().getLengthIncrement(eachSize);
            boolean continueLayout = this.applyTabLayout(data2, label2, length);
            data2.position = this.getStrategy().getMaxPosition(label2.getBounds());
            data2.position += this.myTabs.getTabHGap();
            if (continueLayout) continue;
            layoutStopped = true;
        }
        for (TabInfo eachInfo : data2.toDrop) {
            JBTabsImpl.resetLayout(this.myTabs.myInfo2Label.get(eachInfo));
        }
    }

    protected boolean applyTabLayout(SingleRowPassInfo data2, TabLabel label2, int length) {
        Rectangle rec = this.getStrategy().getLayoutRect(data2, data2.position, length);
        this.myTabs.layout(label2, rec);
        label2.setAlignmentToCenter(this.myTabs.isEditorTabs() && this.getStrategy().isToCenterTextWhenStretched());
        return true;
    }

    protected abstract void recomputeToLayout(SingleRowPassInfo var1);

    protected void calculateRequiredLength(SingleRowPassInfo data2) {
        for (TabInfo eachInfo : data2.myVisibleInfos) {
            data2.requiredLength += this.getRequiredLength(eachInfo);
            if (this.myTabs.getTabsPosition().isSide()) {
                --data2.requiredLength;
            }
            data2.toLayout.add(eachInfo);
        }
    }

    protected int getRequiredLength(TabInfo eachInfo) {
        TabLabel label2 = this.myTabs.myInfo2Label.get(eachInfo);
        return this.getStrategy().getLengthIncrement(label2 != null ? label2.getPreferredSize() : new Dimension()) + (this.myTabs.isEditorTabs() ? this.myTabs.getTabHGap() : 0);
    }

    public boolean isTabHidden(TabInfo tabInfo) {
        return this.myLastSingRowLayout != null && this.myLastSingRowLayout.toDrop.contains(tabInfo);
    }

    @Override
    public int getDropIndexFor(Point point) {
        if (this.myLastSingRowLayout == null) {
            return -1;
        }
        int result2 = -1;
        Component c = this.myTabs.getComponentAt(point);
        if (c instanceof JBTabsImpl) {
            for (int i = 0; i < this.myLastSingRowLayout.myVisibleInfos.size() - 1; ++i) {
                boolean between;
                TabLabel first = this.myTabs.myInfo2Label.get(this.myLastSingRowLayout.myVisibleInfos.get(i));
                TabLabel second = this.myTabs.myInfo2Label.get(this.myLastSingRowLayout.myVisibleInfos.get(i + 1));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean horizontal = this.getStrategy() instanceof SingleRowLayoutStrategy.Horizontal;
                if (horizontal) {
                    between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                } else {
                    boolean bl = between = firstBounds.getMaxY() < (double)point.y && secondBounds.getY() > (double)point.y && firstBounds.x < point.x && secondBounds.getMaxX() > (double)point.x;
                }
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.myLastSingRowLayout.myVisibleInfos.indexOf(info);
            boolean isDropTarget = this.myTabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i = 0; i <= index; ++i) {
                    if (!this.myTabs.isDropTarget((TabInfo)this.myLastSingRowLayout.myVisibleInfos.get(i))) continue;
                    --index;
                    break;
                }
                result2 = index;
            } else if (index < this.myLastSingRowLayout.myVisibleInfos.size()) {
                result2 = index;
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabLabel", "com/intellij/ui/tabs/impl/singleRow/SingleRowLayout", "isDragOut"));
    }
}

