/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.table;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.ui.tabs.impl.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableLayout
extends TabLayout {
    private final JBTabsImpl myTabs;
    public TablePassInfo myLastTableLayout;

    public TableLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
    }

    private TablePassInfo computeLayoutTable(List<TabInfo> visibleInfos) {
        TablePassInfo data2 = new TablePassInfo(this.myTabs, visibleInfos);
        Insets insets = this.myTabs.getLayoutInsets();
        data2.toFitRec = new Rectangle(insets.left, insets.top, this.myTabs.getWidth() - insets.left - insets.right, this.myTabs.getHeight() - insets.top - insets.bottom);
        int eachRow = 0;
        int eachX = data2.toFitRec.x;
        TableRow eachTableRow = new TableRow(data2);
        data2.table.add(eachTableRow);
        data2.requiredRows = 1;
        for (TabInfo eachInfo : data2.myVisibleInfos) {
            TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getPreferredSize();
            if ((double)(eachX + size.width) >= data2.toFitRec.getMaxX()) {
                ++data2.requiredRows;
                eachX = data2.toFitRec.x;
            }
            this.myTabs.layout(eachLabel, eachX, 0, size.width, 1);
            eachX += size.width + this.myTabs.getTabHGap();
            data2.requiredWidth += size.width + this.myTabs.getTabHGap();
        }
        int selectedRow = -1;
        eachX = data2.toFitRec.x;
        data2.rowToFitMaxX = (int)data2.toFitRec.getMaxX();
        if (data2.requiredRows > 1) {
            int rowFit = insets.left + data2.requiredWidth / data2.requiredRows;
            for (TabInfo eachInfo : data2.myVisibleInfos) {
                TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
                Rectangle eachBounds = eachLabel.getBounds();
                if (!eachBounds.contains(rowFit, 0)) continue;
                data2.rowToFitMaxX = (int)eachLabel.getBounds().getMaxX();
                break;
            }
        }
        for (TabInfo eachInfo : data2.myVisibleInfos) {
            TabLabel eachLabel = this.myTabs.myInfo2Label.get(eachInfo);
            Dimension size = eachLabel.getPreferredSize();
            if (eachX + size.width <= data2.rowToFitMaxX) {
                eachTableRow.add(eachInfo);
                if (this.myTabs.getSelectedInfo() == eachInfo) {
                    selectedRow = eachRow;
                }
                eachX += size.width + this.myTabs.getTabHGap();
                continue;
            }
            eachTableRow = new TableRow(data2);
            data2.table.add(eachTableRow);
            ++eachRow;
            eachX = insets.left + size.width;
            eachTableRow.add(eachInfo);
            if (this.myTabs.getSelectedInfo() != eachInfo) continue;
            selectedRow = eachRow;
        }
        ArrayList<TableRow> toMove = new ArrayList<TableRow>();
        for (int i = selectedRow + 1; i < data2.table.size(); ++i) {
            toMove.add(data2.table.get(i));
        }
        return data2;
    }

    public boolean isLastRow(TabInfo info) {
        if (info == null) {
            return false;
        }
        List<TableRow> rows = this.myLastTableLayout.table;
        if (rows.size() > 0) {
            for (TabInfo tabInfo : rows.get((int)(rows.size() - 1)).myColumns) {
                if (tabInfo != info) continue;
                return true;
            }
        }
        return false;
    }

    public LayoutPassInfo layoutTable(List<TabInfo> visibleInfos) {
        this.myTabs.resetLayout(true);
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        TablePassInfo data2 = new TablePassInfo(this.myTabs, visibleInfos);
        if (!this.myTabs.isHideTabs()) {
            data2 = this.computeLayoutTable(visibleInfos);
            insets = this.myTabs.getLayoutInsets();
            eachY = insets.top;
            for (TableRow eachRow : data2.table) {
                int eachX = insets.left;
                int deltaToFit = 0;
                boolean toAjust = false;
                if (eachRow.width < data2.toFitRec.width && data2.table.size() > 1) {
                    deltaToFit = (int)Math.floor((double)(data2.toFitRec.width - eachRow.width) / (double)eachRow.myColumns.size());
                    toAjust = true;
                }
                for (int i = 0; i < eachRow.myColumns.size(); ++i) {
                    TabInfo tabInfo = eachRow.myColumns.get(i);
                    TabLabel label2 = this.myTabs.myInfo2Label.get(tabInfo);
                    label2.putClientProperty("Layout.stretchedByWidth", toAjust);
                    int width = i < eachRow.myColumns.size() - 1 || !toAjust ? label2.getPreferredSize().width + deltaToFit : data2.toFitRec.width + insets.left - eachX;
                    this.myTabs.layout(label2, eachX, eachY, width, this.myTabs.myHeaderFitSize.height);
                    label2.setAlignmentToCenter(deltaToFit > 0);
                    boolean lastCell = i == eachRow.myColumns.size() - 1;
                    eachX += width + (lastCell ? 0 : this.myTabs.getTabHGap());
                }
                eachY += this.myTabs.myHeaderFitSize.height;
            }
        }
        if (this.myTabs.getSelectedInfo() != null) {
            JBTabsImpl.Toolbar selectedToolbar = this.myTabs.myInfo2Toolbar.get(this.myTabs.getSelectedInfo());
            int componentY = eachY + (this.myTabs.isEditorTabs() ? 0 : 2) - this.myTabs.getLayoutInsets().top;
            if (!this.myTabs.myHorizontalSide && selectedToolbar != null && !selectedToolbar.isEmpty()) {
                int vSeparatorWidth;
                int toolbarWidth = selectedToolbar.getPreferredSize().width;
                int n = vSeparatorWidth = toolbarWidth > 0 ? this.myTabs.getSeparatorWidth() : 0;
                if (this.myTabs.isSideComponentBefore()) {
                    Rectangle compRect = this.myTabs.layoutComp(toolbarWidth + vSeparatorWidth, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                } else {
                    int width = this.myTabs.getWidth() - toolbarWidth - vSeparatorWidth;
                    Rectangle compRect = this.myTabs.layoutComp(new Rectangle(0, componentY, width, this.myTabs.getHeight()), this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                }
            } else {
                this.myTabs.layoutComp(0, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
            }
        }
        this.myLastTableLayout = data2;
        return data2;
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            TableLayout.$$$reportNull$$$0(0);
        }
        if (this.myLastTableLayout == null) {
            return super.isDragOut(tabLabel, deltaX, deltaY);
        }
        Rectangle area = new Rectangle(this.myLastTableLayout.toFitRec.width, tabLabel.getBounds().height);
        for (int i = 0; i < this.myLastTableLayout.myVisibleInfos.size(); ++i) {
            area = area.union(this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i)).getBounds());
        }
        return (double)Math.abs(deltaY) > (double)area.height * TableLayout.getDragOutMultiplier();
    }

    @Override
    public int getDropIndexFor(Point point) {
        if (this.myLastTableLayout == null) {
            return -1;
        }
        int result2 = -1;
        Component c = this.myTabs.getComponentAt(point);
        if (c instanceof JBTabsImpl) {
            for (int i = 0; i < this.myLastTableLayout.myVisibleInfos.size() - 1; ++i) {
                boolean between;
                TabLabel first = this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i));
                TabLabel second = this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i + 1));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean bl = between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.myLastTableLayout.myVisibleInfos.indexOf(info);
            boolean isDropTarget = this.myTabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i = 0; i <= index; ++i) {
                    if (!this.myTabs.isDropTarget((TabInfo)this.myLastTableLayout.myVisibleInfos.get(i))) continue;
                    --index;
                    break;
                }
                result2 = index;
            } else if (index < this.myLastTableLayout.myVisibleInfos.size()) {
                result2 = index;
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabLabel", "com/intellij/ui/tabs/impl/table/TableLayout", "isDragOut"));
    }
}

