/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.layout;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayout;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutCallback;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;

public abstract class LayoutPassInfoBase
extends LayoutPassInfo {
    public final Rectangle layoutRectWithoutInsets;
    public final int tabsRowHeight;

    protected LayoutPassInfoBase(List<TabInfo> visibleInfos, TabsLayout tabsLayout, TabsLayoutCallback tabsLayoutCallback) {
        super(visibleInfos);
        Insets insets = tabsLayoutCallback.getLayoutInsets();
        this.layoutRectWithoutInsets = new Rectangle(insets.left, insets.top, tabsLayoutCallback.getComponent().getWidth() - insets.left - insets.right, tabsLayoutCallback.getComponent().getHeight() - insets.top - insets.bottom);
        MaxDimensions maxDimensions = this.computeMaxSize(tabsLayout, tabsLayoutCallback);
        this.tabsRowHeight = Math.max(maxDimensions.myLabel.height, maxDimensions.myToolbar.height);
    }

    private MaxDimensions computeMaxSize(TabsLayout tabsLayout, TabsLayoutCallback tabsLayoutCallback) {
        MaxDimensions max = new MaxDimensions();
        boolean isToolbarOnTabs = tabsLayout.isToolbarOnTabs();
        for (TabInfo eachInfo : this.myVisibleInfos) {
            JBTabsImpl.Toolbar toolbar;
            TabLabel label2 = tabsLayoutCallback.getTabLabel(eachInfo);
            max.myLabel.height = Math.max(max.myLabel.height, label2.getPreferredSize().height);
            max.myLabel.width = Math.max(max.myLabel.width, label2.getPreferredSize().width);
            if (!isToolbarOnTabs || (toolbar = tabsLayoutCallback.getToolbar(eachInfo)) == null || toolbar.isEmpty()) continue;
            max.myToolbar.height = Math.max(max.myToolbar.height, toolbar.getPreferredSize().height);
            max.myToolbar.width = Math.max(max.myToolbar.width, toolbar.getPreferredSize().width);
        }
        return max;
    }

    @Override
    @Deprecated
    public int getRowCount() {
        return 0;
    }

    @Override
    @Deprecated
    public int getColumnCount(int row) {
        return 0;
    }

    @Override
    @Deprecated
    public TabInfo getTabAt(int row, int column) {
        return null;
    }

    private static class MaxDimensions {
        final Dimension myLabel = new Dimension();
        final Dimension myToolbar = new Dimension();

        private MaxDimensions() {
        }
    }
}

