/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.layout.singleRowLayout;

import com.intellij.application.options.editor.EditorTabPlacementKt;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayout;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.ui.tabs.layout.singleRowLayout.SingleRowLayout;
import com.intellij.ui.tabs.layout.singleRowLayout.SingleRowPassInfo;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompressibleSingleRowLayout
extends SingleRowLayout {
    @Override
    protected void recomputeToLayout(SingleRowPassInfo data2) {
        this.calculateRequiredLength(data2);
    }

    @Override
    protected void layoutLabels(SingleRowPassInfo data2) {
        if (this.myCallback.getTabsPosition() != JBTabsPosition.top && this.myCallback.getTabsPosition() != JBTabsPosition.bottom) {
            super.layoutLabels(data2);
            return;
        }
        int maxGridSize = 0;
        int spentLength = 0;
        int lengthEstimation = 0;
        int[] lengths = new int[data2.toLayout.size()];
        List<TabInfo> layout = data2.toLayout;
        for (int i = 0; i < layout.size(); ++i) {
            int lengthIncrement;
            TabLabel label2 = this.myCallback.getTabLabel(layout.get(i));
            if (maxGridSize == 0) {
                Font font = label2.getLabelComponent().getFont();
                maxGridSize = GraphicsUtil.stringWidth("m", font == null ? JBFont.label() : font) * this.myCallback.tabMSize();
            }
            lengths[i] = lengthIncrement = label2.getPreferredSize().width;
            lengthEstimation += lengthIncrement;
        }
        int extraWidth = data2.toFitLength - lengthEstimation;
        Arrays.sort(lengths);
        double acc = 0.0;
        int actualGridSize = 0;
        for (int i = 0; i < lengths.length; ++i) {
            int length = lengths[i];
            actualGridSize = (int)Math.min((double)maxGridSize, ((acc += (double)length) + (double)extraWidth) / (double)(i + 1));
            if (i < lengths.length - 1 && actualGridSize < lengths[i + 1]) break;
        }
        Iterator<TabInfo> iterator2 = data2.toLayout.iterator();
        while (iterator2.hasNext()) {
            TabLabel label3 = this.myCallback.getTabLabel(iterator2.next());
            int lengthIncrement = label3.getPreferredSize().width;
            int length = !iterator2.hasNext() ? Math.min(data2.toFitLength - spentLength, Math.max(actualGridSize, lengthIncrement)) : (extraWidth <= 0 ? (int)((float)lengthIncrement * (float)data2.toFitLength / (float)lengthEstimation) : Math.max(lengthIncrement, actualGridSize));
            spentLength += length - this.myCallback.getBorderThickness();
            this.applyTabLayout(data2, label3, length);
            data2.position = (int)label3.getBounds().getMaxX() - this.myCallback.getBorderThickness();
        }
        for (TabInfo eachInfo : data2.toDrop) {
            this.resetLayout(this.myCallback.getTabLabel(eachInfo));
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data2, TabLabel label2, int length) {
        boolean result2 = super.applyTabLayout(data2, label2, length);
        label2.setAlignmentToCenter(false);
        return result2;
    }

    public static class CompressibleSingleRowTabsLayoutInfo
    extends TabsLayoutInfo {
        private static final String ID = "CompressibleSingleRowLayoutInfo";
        private static final String NAME = "Compressible Single Row";

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getName() {
            return NAME;
        }

        @Override
        @NotNull
        protected TabsLayout createTabsLayoutInstance() {
            return new CompressibleSingleRowLayout();
        }

        @Override
        @Nullable
        public Integer[] getAvailableTabsPositions() {
            return EditorTabPlacementKt.getTAB_PLACEMENTS();
        }
    }
}

