/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProjectFileNode {
    @NotNull
    public Object getRootID();

    @NotNull
    public VirtualFile getVirtualFile();

    default public boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area, boolean strict) {
        Object id2;
        if (file2 == null) {
            ProjectFileNode.$$$reportNull$$$0(0);
        }
        if (area == null) {
            ProjectFileNode.$$$reportNull$$$0(1);
        }
        if ((id2 = this.getRootID()) instanceof AreaInstance && !id2.equals(area)) {
            return false;
        }
        return VfsUtilCore.isAncestor(this.getVirtualFile(), file2, strict);
    }

    @Nullable
    public static AreaInstance findArea(@NotNull VirtualFile file2, @Nullable Project project2) {
        if (file2 == null) {
            ProjectFileNode.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        if (project2 == null || project2.isDisposed() || !file2.isValid()) {
            return null;
        }
        Module module2 = ProjectFileIndex.getInstance(project2).getModuleForFile(file2, false);
        if (module2 != null) {
            return module2.isDisposed() ? null : module2;
        }
        if (!Registry.is("projectView.show.base.dir")) {
            return null;
        }
        VirtualFile ancestor = ProjectFileNode.findBaseDir(project2);
        return ancestor == null || FileTypeRegistry.getInstance().isFileIgnored(file2) || !VfsUtilCore.isAncestor(ancestor, file2, false) ? null : project2;
    }

    @Nullable
    public static VirtualFile findBaseDir(@Nullable Project project2) {
        if (project2 == null || project2.isDisposed()) {
            return null;
        }
        String path2 = project2.getBasePath();
        return path2 == null ? null : LocalFileSystem.getInstance().findFileByPath(path2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/project/ProjectFileNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findArea";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

