/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;

final class DispatchThreadValidator {
    private static final Logger LOG = Logger.getInstance(DispatchThreadValidator.class);
    private volatile Thread background = DispatchThreadValidator.getBackgroundThread();

    DispatchThreadValidator() {
    }

    private static Thread getBackgroundThread() {
        return EventQueue.isDispatchThread() ? null : Thread.currentThread();
    }

    public boolean isValidThread() {
        Thread thread = DispatchThreadValidator.getBackgroundThread();
        if (thread == null) {
            this.background = null;
            return true;
        }
        if (thread == this.background) {
            return true;
        }
        LOG.debug(new IllegalStateException("unexpected thread: " + thread));
        return false;
    }
}

