/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleNode
extends PresentableNodeDescriptor
implements ComparableObject,
LeafState.Supplier {
    protected static final SimpleNode[] NO_CHILDREN = new SimpleNode[0];

    protected SimpleNode(Project project2) {
        this(project2, (NodeDescriptor)null);
    }

    protected SimpleNode(Project project2, @Nullable NodeDescriptor parentDescriptor) {
        super(project2, parentDescriptor);
        this.myName = "";
    }

    protected SimpleNode(SimpleNode parent) {
        this(parent == null ? null : parent.myProject, (NodeDescriptor)parent);
    }

    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return this.getChildAt(index);
    }

    protected SimpleNode() {
        super((Project)null, (NodeDescriptor)null);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int getWeight() {
        return 10;
    }

    protected SimpleTextAttributes getErrorAttributes() {
        return new SimpleTextAttributes(8, this.getColor(), (Color)JBColor.RED);
    }

    protected SimpleTextAttributes getPlainAttributes() {
        return new SimpleTextAttributes(0, this.getColor());
    }

    private FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Nullable
    protected Object updateElement() {
        return this.getElement();
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            SimpleNode.$$$reportNull$$$0(0);
        }
        Object newElement = this.updateElement();
        if (this.getElement() != newElement) {
            presentation.setChanged(true);
        }
        if (newElement == null) {
            return;
        }
        Color oldColor = this.myColor;
        String oldName = this.myName;
        Icon oldIcon = this.getIcon();
        ArrayList<PresentableNodeDescriptor.ColoredFragment> oldFragments = new ArrayList<PresentableNodeDescriptor.ColoredFragment>(presentation.getColoredText());
        this.myColor = UIUtil.getTreeForeground();
        this.updateFileStatus();
        this.doUpdate();
        this.myName = this.getName();
        presentation.setPresentableText(this.myName);
        presentation.setChanged(!Arrays.equals(new Object[]{this.getIcon(), this.myName, oldFragments, this.myColor}, new Object[]{oldIcon, oldName, oldFragments, oldColor}));
        presentation.setForcedTextForeground(this.myColor);
        presentation.setIcon(this.getIcon());
    }

    protected void updateFileStatus() {
        assert (this.getFileStatus() != null) : this.getClass().getName() + ' ' + this.toString();
        Color fileStatusColor = this.getFileStatus().getColor();
        if (fileStatusColor != null) {
            this.myColor = fileStatusColor;
        }
    }

    @Deprecated
    public final void setNodeText(String text2, String tooltip, boolean hasError) {
        this.clearColoredText();
        SimpleTextAttributes attributes = hasError ? this.getErrorAttributes() : this.getPlainAttributes();
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(text2, tooltip, attributes));
    }

    @Deprecated
    public final void setPlainText(String aText) {
        this.clearColoredText();
        this.addPlainText(aText);
    }

    @Deprecated
    public final void addPlainText(String aText) {
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(aText, this.getPlainAttributes()));
    }

    @Deprecated
    public final void addErrorText(String aText, String errorTooltipText) {
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(aText, errorTooltipText, this.getErrorAttributes()));
    }

    @Deprecated
    public final void clearColoredText() {
        this.getTemplatePresentation().clearText();
    }

    @Deprecated
    public final void addColoredFragment(String aText, SimpleTextAttributes aAttributes) {
        this.addColoredFragment(aText, null, aAttributes);
    }

    @Deprecated
    public final void addColoredFragment(String aText, String toolTip, SimpleTextAttributes aAttributes) {
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(aText, toolTip, aAttributes));
    }

    @Deprecated
    public final void addColoredFragment(PresentableNodeDescriptor.ColoredFragment fragment) {
        this.getTemplatePresentation().addText(new PresentableNodeDescriptor.ColoredFragment(fragment.getText(), fragment.getAttributes()));
    }

    protected void doUpdate() {
    }

    @Override
    public Object getElement() {
        return this;
    }

    public final SimpleNode getParent() {
        return (SimpleNode)this.getParentDescriptor();
    }

    public int getIndex(SimpleNode child2) {
        SimpleNode[] kids = this.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            SimpleNode each = kids[i];
            if (!each.equals(child2)) continue;
            return i;
        }
        return -1;
    }

    public abstract SimpleNode @NotNull [] getChildren();

    public void accept(@NotNull SimpleNodeVisitor visitor) {
        if (visitor == null) {
            SimpleNode.$$$reportNull$$$0(1);
        }
        visitor.accept(this);
    }

    public void handleSelection(SimpleTree tree) {
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
    }

    @Override
    @NotNull
    public LeafState getLeafState() {
        if (this.isAlwaysShowPlus()) {
            LeafState leafState = LeafState.NEVER;
            if (leafState == null) {
                SimpleNode.$$$reportNull$$$0(2);
            }
            return leafState;
        }
        if (this.isAlwaysLeaf()) {
            LeafState leafState = LeafState.ALWAYS;
            if (leafState == null) {
                SimpleNode.$$$reportNull$$$0(3);
            }
            return leafState;
        }
        LeafState leafState = LeafState.DEFAULT;
        if (leafState == null) {
            SimpleNode.$$$reportNull$$$0(4);
        }
        return leafState;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAutoExpandNode() {
        return false;
    }

    public boolean isAlwaysLeaf() {
        return false;
    }

    public boolean shouldHaveSeparator() {
        return false;
    }

    @Deprecated
    public void setUniformIcon(Icon aIcon) {
        this.setIcon(aIcon);
    }

    @Deprecated
    public final PresentableNodeDescriptor.ColoredFragment[] getColoredText() {
        List<PresentableNodeDescriptor.ColoredFragment> list2 = this.getTemplatePresentation().getColoredText();
        return list2.toArray(new PresentableNodeDescriptor.ColoredFragment[0]);
    }

    @Override
    public Object @NotNull [] getEqualityObjects() {
        if (NONE == null) {
            SimpleNode.$$$reportNull$$$0(5);
        }
        return NONE;
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public SimpleNode getChildAt(int i) {
        return this.getChildren()[i];
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals(this, o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode(this, super.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/treeStructure/SimpleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/treeStructure/SimpleNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

