/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends Node
implements Navigatable,
Comparable<GroupNode> {
    private static final NodeComparator COMPARATOR = new NodeComparator();
    private final int myRuleIndex;
    private int myRecursiveUsageCount;
    private final List<Node> myChildren;

    private GroupNode(@NotNull Node parent, @NotNull UsageGroup group, int ruleIndex) {
        if (parent == null) {
            GroupNode.$$$reportNull$$$0(0);
        }
        if (group == null) {
            GroupNode.$$$reportNull$$$0(1);
        }
        this.myChildren = new SmartList<Node>();
        this.setUserObject(group);
        this.setParent(parent);
        this.myRuleIndex = ruleIndex;
    }

    private GroupNode() {
        this.myChildren = new SmartList<Node>();
        this.myRuleIndex = 0;
    }

    @Override
    protected void updateNotify() {
        if (this.getGroup() != null) {
            this.getGroup().update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String result2 = this.getGroup() == null ? "" : this.getGroup().getText(null);
        GroupNode groupNode = this;
        synchronized (groupNode) {
            return result2 + ContainerUtil.getFirstItems(this.myChildren, 10);
        }
    }

    @NotNull
    List<Node> getChildren() {
        List<Node> list2 = this.myChildren;
        if (list2 == null) {
            GroupNode.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    List<Node> getSwingChildren() {
        List<Node> list2 = ObjectUtils.notNull(this.children, Collections.emptyList());
        if (list2 == null) {
            GroupNode.$$$reportNull$$$0(3);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    GroupNode addOrGetGroup(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<? super Node> edtInsertedUnderQueue) {
        GroupNode newNode;
        if (group == null) {
            GroupNode.$$$reportNull$$$0(4);
        }
        if (edtInsertedUnderQueue == null) {
            GroupNode.$$$reportNull$$$0(5);
        }
        GroupNode groupNode = this;
        synchronized (groupNode) {
            newNode = new GroupNode(this, group, ruleIndex);
            int i = GroupNode.getNodeIndex(newNode, this.myChildren);
            if (i >= 0) {
                GroupNode groupNode2 = (GroupNode)this.myChildren.get(i);
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var5_4
                if (groupNode2 == null) {
                    GroupNode.$$$reportNull$$$0(6);
                }
                return groupNode2;
            }
            int insertionIndex = -i - 1;
            this.myChildren.add(insertionIndex, newNode);
        }
        edtInsertedUnderQueue.consume(this);
        GroupNode groupNode3 = newNode;
        if (groupNode3 == null) {
            GroupNode.$$$reportNull$$$0(7);
        }
        return groupNode3;
    }

    private static int getNodeIndex(@NotNull Node newNode, @NotNull List<? extends Node> children2) {
        if (newNode == null) {
            GroupNode.$$$reportNull$$$0(8);
        }
        if (children2 == null) {
            GroupNode.$$$reportNull$$$0(9);
        }
        return Collections.binarySearch(children2, newNode, COMPARATOR);
    }

    private static int getNodeInsertionIndex(@NotNull Node node, @NotNull List<? extends Node> children2) {
        int i;
        if (node == null) {
            GroupNode.$$$reportNull$$$0(10);
        }
        if (children2 == null) {
            GroupNode.$$$reportNull$$$0(11);
        }
        return (i = GroupNode.getNodeIndex(node, children2)) >= 0 ? i : -i - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTargetsNode(@NotNull Node node, @NotNull DefaultTreeModel treeModel) {
        int index;
        if (node == null) {
            GroupNode.$$$reportNull$$$0(12);
        }
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            index = GroupNode.getNodeInsertionIndex(node, this.getSwingChildren());
            this.myChildren.add(index, node);
        }
        treeModel.insertNodeInto(node, this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.removeAllChildren();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            this.myChildren.clear();
        }
        this.myRecursiveUsageCount = 0;
    }

    @Nullable
    private UsageNode tryMerge(@NotNull Usage usage) {
        if (usage == null) {
            GroupNode.$$$reportNull$$$0(14);
        }
        if (!(usage instanceof MergeableUsage)) {
            return null;
        }
        MergeableUsage mergeableUsage = (MergeableUsage)((Object)usage);
        for (UsageNode node : this.getUsageNodes()) {
            Usage original = node.getUsage();
            if (original == mergeableUsage) {
                return node;
            }
            if (!(original instanceof MergeableUsage) || !((MergeableUsage)((Object)original)).merge(mergeableUsage)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeUsagesBulk(@NotNull Set<UsageNode> usages, @NotNull DefaultTreeModel treeModel) {
        if (usages == null) {
            GroupNode.$$$reportNull$$$0(15);
        }
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int removed = 0;
        GroupNode groupNode = this;
        synchronized (groupNode) {
            SmartList<Node> removedNodes = new SmartList<Node>();
            for (UsageNode usage : usages) {
                if (!this.myChildren.remove(usage)) continue;
                removedNodes.add(usage);
                ++removed;
            }
            if (removed == 0) {
                for (GroupNode groupNode2 : this.getSubGroups()) {
                    int delta = groupNode2.removeUsagesBulk(usages, treeModel);
                    if (delta <= 0) continue;
                    if (groupNode2.getRecursiveUsageCount() == 0) {
                        this.myChildren.remove(groupNode2);
                        removedNodes.add(groupNode2);
                    }
                    if ((removed += delta) != usages.size()) continue;
                    break;
                }
            }
            if (!this.myChildren.isEmpty()) {
                GroupNode.removeNodesFromParent(treeModel, this, removedNodes);
            }
        }
        if (removed > 0) {
            this.myRecursiveUsageCount -= removed;
            if (this.myRecursiveUsageCount != 0) {
                treeModel.nodeChanged(this);
            }
        }
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    private static void removeNodesFromParent(@NotNull DefaultTreeModel treeModel, @NotNull GroupNode parent, @NotNull List<? extends MutableTreeNode> nodes) {
        void var6_8;
        int count;
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            GroupNode.$$$reportNull$$$0(18);
        }
        if (nodes == null) {
            GroupNode.$$$reportNull$$$0(19);
        }
        if ((count = nodes.size()) == 0) {
            return;
        }
        ObjectIntHashMap<MutableTreeNode> ordering = new ObjectIntHashMap<MutableTreeNode>(count);
        for (MutableTreeNode mutableTreeNode : nodes) {
            ordering.put(mutableTreeNode, parent.getIndex(mutableTreeNode));
        }
        Collections.sort(nodes, Comparator.comparingInt(ordering::get));
        int[] indices = ordering.getValues();
        Arrays.sort(indices);
        int n = count - 1;
        while (var6_8 >= 0) {
            parent.remove(indices[var6_8]);
            --var6_8;
        }
        treeModel.nodesWereRemoved(parent, indices, nodes.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    UsageNode addOrGetUsage(@NotNull Usage usage, boolean filterDuplicateLines, @NotNull Consumer<? super Node> edtInsertedUnderQueue) {
        UsageNode newNode;
        if (usage == null) {
            GroupNode.$$$reportNull$$$0(20);
        }
        if (edtInsertedUnderQueue == null) {
            GroupNode.$$$reportNull$$$0(21);
        }
        GroupNode groupNode = this;
        synchronized (groupNode) {
            UsageNode mergedWith;
            if (filterDuplicateLines && (mergedWith = this.tryMerge(usage)) != null) {
                UsageNode usageNode = mergedWith;
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl9 : MonitorExitStatement: MONITOREXIT : var5_4
                if (usageNode == null) {
                    GroupNode.$$$reportNull$$$0(22);
                }
                return usageNode;
            }
            newNode = new UsageNode(this, usage);
            int i = GroupNode.getNodeIndex(newNode, this.myChildren);
            if (i >= 0) {
                newNode = (UsageNode)this.myChildren.get(i);
            } else {
                int insertionIndex = -i - 1;
                this.myChildren.add(insertionIndex, newNode);
            }
        }
        edtInsertedUnderQueue.consume(this);
        UsageNode usageNode = newNode;
        if (usageNode == null) {
            GroupNode.$$$reportNull$$$0(23);
        }
        return usageNode;
    }

    void incrementUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        while (true) {
            ++groupNode.myRecursiveUsageCount;
            TreeNode parent = groupNode.getParent();
            if (!(parent instanceof GroupNode)) {
                return;
            }
            groupNode = (GroupNode)parent;
        }
    }

    @Override
    public String tree2string(int indent, String lineSeparator) {
        StringBuffer result2 = new StringBuffer();
        StringUtil.repeatSymbol(result2, ' ', indent);
        if (this.getGroup() != null) {
            result2.append(this.getGroup());
        }
        result2.append("[");
        result2.append(lineSeparator);
        for (Node node : this.myChildren) {
            result2.append(node.tree2string(indent + 4, lineSeparator));
            result2.append(lineSeparator);
        }
        StringUtil.repeatSymbol(result2, ' ', indent);
        result2.append("]");
        result2.append(lineSeparator);
        return result2.toString();
    }

    @Override
    protected boolean isDataValid() {
        UsageGroup group = this.getGroup();
        return group == null || group.isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode element2 = enumeration.nextElement();
            if (!(element2 instanceof Node) || !((Node)element2).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull GroupNode groupNode) {
        if (groupNode == null) {
            GroupNode.$$$reportNull$$$0(24);
        }
        if (this.myRuleIndex == groupNode.myRuleIndex) {
            return this.getGroup().compareTo(groupNode.getGroup());
        }
        return Integer.compare(this.myRuleIndex, groupNode.myRuleIndex);
    }

    public synchronized UsageGroup getGroup() {
        return (UsageGroup)this.getUserObject();
    }

    int getRecursiveUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myRecursiveUsageCount;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.getGroup() != null) {
            this.getGroup().navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.getGroup() != null && this.getGroup().canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.getGroup() != null && this.getGroup().canNavigateToSource();
    }

    @Override
    protected boolean isDataExcluded() {
        for (Node node : this.myChildren) {
            if (node.isExcluded()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected String getText(@NotNull UsageView view) {
        if (view == null) {
            GroupNode.$$$reportNull$$$0(25);
        }
        String string = this.getGroup().getText(view);
        if (string == null) {
            GroupNode.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public synchronized Collection<GroupNode> getSubGroups() {
        ArrayList<GroupNode> list2 = new ArrayList<GroupNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof GroupNode)) continue;
            list2.add((GroupNode)n);
        }
        ArrayList<GroupNode> arrayList = list2;
        if (arrayList == null) {
            GroupNode.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    public synchronized Collection<UsageNode> getUsageNodes() {
        ArrayList<UsageNode> list2 = new ArrayList<UsageNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof UsageNode)) continue;
            list2.add((UsageNode)n);
        }
        ArrayList<UsageNode> arrayList = list2;
        if (arrayList == null) {
            GroupNode.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    static Root createRoot() {
        return new Root();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/GroupNode";
                break;
            }
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtInsertedUnderQueue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/GroupNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwingChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addOrGetGroup";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "addOrGetUsage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubGroups";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addOrGetGroup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNodeInsertionIndex";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTargetsNode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryMerge";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeUsagesBulk";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeNodesFromParent";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addOrGetUsage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Root
    extends GroupNode {
        Root() {
        }

        @Override
        @NonNls
        public String toString() {
            return "Root " + super.toString();
        }

        @Override
        @NotNull
        protected String getText(@NotNull UsageView view) {
            if (view == null) {
                Root.$$$reportNull$$$0(0);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/usages/impl/GroupNode$Root", "getText"));
        }
    }

    private static class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NodeComparator() {
        }

        private static ClassIndex getClassIndex(DefaultMutableTreeNode node) {
            if (node instanceof UsageNode) {
                return ClassIndex.USAGE;
            }
            if (node instanceof GroupNode) {
                return ClassIndex.GROUP;
            }
            if (node instanceof UsageTargetNode) {
                return ClassIndex.USAGE_TARGET;
            }
            return ClassIndex.UNKNOWN;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            Object u2;
            int c;
            ClassIndex classIdx2;
            ClassIndex classIdx1 = NodeComparator.getClassIndex(n1);
            if (classIdx1 != (classIdx2 = NodeComparator.getClassIndex(n2))) {
                return classIdx1.compareTo(classIdx2);
            }
            if (classIdx1 == ClassIndex.GROUP ? (c = ((GroupNode)n1).compareTo((GroupNode)n2)) != 0 : classIdx1 == ClassIndex.USAGE && (c = ((UsageNode)n1).compareTo((UsageNode)n2)) != 0) {
                return c;
            }
            Object u1 = n1.getUserObject();
            if (Comparing.equal(u1, u2 = n2.getUserObject())) {
                return 0;
            }
            return System.identityHashCode(u1) - System.identityHashCode(u2);
        }

        static enum ClassIndex {
            UNKNOWN,
            USAGE_TARGET,
            GROUP,
            USAGE;

        }
    }
}

