/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewEx;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.RangeBlinker;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SearchForUsagesRunnable
implements Runnable {
    @NonNls
    private static final String FIND_OPTIONS_HREF_TARGET = "FindOptions";
    @NonNls
    private static final String SEARCH_IN_PROJECT_HREF_TARGET = "SearchInProject";
    @NonNls
    private static final String LARGE_FILES_HREF_TARGET = "LargeFiles";
    @NonNls
    private static final String SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET = "SHOW_PROJECT_FILE_OCCURRENCES";
    private final AtomicInteger myUsageCountWithoutDefinition;
    private final AtomicReference<Usage> myFirstUsage;
    @NotNull
    private final Project myProject;
    private final AtomicReference<UsageViewEx> myUsageViewRef;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] mySearchFor;
    private final Factory<UsageSearcher> mySearcherFactory;
    private final FindUsagesProcessPresentation myProcessPresentation;
    @NotNull
    private final SearchScope mySearchScopeToWarnOfFallingOutOf;
    private final UsageViewManager.UsageViewStateListener myListener;
    private final UsageViewManagerImpl myUsageViewManager;
    private final AtomicInteger myOutOfScopeUsages;

    SearchForUsagesRunnable(@NotNull UsageViewManagerImpl usageViewManager, @NotNull Project project2, @NotNull AtomicReference<UsageViewEx> usageViewRef, @NotNull UsageViewPresentation presentation, UsageTarget @NotNull [] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull SearchScope searchScopeToWarnOfFallingOutOf, @Nullable UsageViewManager.UsageViewStateListener listener2) {
        if (usageViewManager == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(1);
        }
        if (usageViewRef == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(3);
        }
        if (searcherFactory == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(4);
        }
        if (processPresentation == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(5);
        }
        if (searchScopeToWarnOfFallingOutOf == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(6);
        }
        if (searchFor == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(7);
        }
        this.myUsageCountWithoutDefinition = new AtomicInteger(0);
        this.myFirstUsage = new AtomicReference();
        this.myOutOfScopeUsages = new AtomicInteger();
        this.myProject = project2;
        this.myUsageViewRef = usageViewRef;
        this.myPresentation = presentation;
        this.mySearchFor = searchFor;
        this.mySearcherFactory = searcherFactory;
        this.myProcessPresentation = processPresentation;
        this.mySearchScopeToWarnOfFallingOutOf = searchScopeToWarnOfFallingOutOf;
        this.myListener = listener2;
        this.myUsageViewManager = usageViewManager;
    }

    @NotNull
    private static String createOptionsHtml(@NonNls UsageTarget @NotNull [] searchFor) {
        if (searchFor == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(8);
        }
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut(searchFor);
        String shortcutText = "";
        if (shortcut != null) {
            shortcutText = "&nbsp;(" + KeymapUtil.getShortcutText(shortcut) + ")";
        }
        String string = "<a href='FindOptions'>Find Options...</a>" + shortcutText;
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String createSearchInProjectHtml() {
        return "<a href='SearchInProject'>Search in Project</a>";
    }

    private void notifyByFindBalloon(@Nullable HyperlinkListener listener2, @NotNull MessageType messageType, @NotNull List<String> lines) {
        Runnable searchIncludingProjectFileUsages;
        if (messageType == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(10);
        }
        if (lines == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(11);
        }
        UsageViewContentManager.getInstance(this.myProject);
        Collection<VirtualFile> largeFiles = this.myProcessPresentation.getLargeFiles();
        ArrayList<String> resultLines = new ArrayList<String>(lines);
        HyperlinkListener resultListener = listener2;
        if (!largeFiles.isEmpty()) {
            String shortMessage = "(<a href='LargeFiles'>" + UsageViewBundle.message("large.files.were.ignored", largeFiles.size()) + "</a>)";
            resultLines.add(shortMessage);
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, LARGE_FILES_HREF_TARGET, () -> {
                String detailedMessage = SearchForUsagesRunnable.detailedLargeFilesMessage(largeFiles);
                ArrayList<String> strings = new ArrayList<String>(lines);
                strings.add(detailedMessage);
                ToolWindowManager.getInstance(this.myProject).notifyByBalloon("Find", messageType, SearchForUsagesRunnable.wrapInHtml(strings), AllIcons.Actions.Find, listener2);
            });
        }
        if ((searchIncludingProjectFileUsages = this.myProcessPresentation.searchIncludingProjectFileUsages()) != null) {
            resultLines.add("Occurrences in project configuration files are skipped. <a href='SHOW_PROJECT_FILE_OCCURRENCES'>Include them</a>");
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET, searchIncludingProjectFileUsages);
        }
        Collection<UnloadedModuleDescription> unloaded = this.getUnloadedModulesBelongingToScope();
        MessageType actualType = messageType;
        if (!unloaded.isEmpty()) {
            if (actualType == MessageType.INFO) {
                actualType = MessageType.WARNING;
            }
            resultLines.add(SearchForUsagesRunnable.mayHaveUsagesInUnloadedModulesMessage(unloaded));
        }
        ToolWindowManager.getInstance(this.myProject).notifyByBalloon("Find", actualType, SearchForUsagesRunnable.wrapInHtml(resultLines), AllIcons.Actions.Find, resultListener);
    }

    @NotNull
    private Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Collection collection = ReadAction.compute(() -> {
            if (!(this.mySearchScopeToWarnOfFallingOutOf instanceof GlobalSearchScope)) {
                return Collections.emptySet();
            }
            Collection<UnloadedModuleDescription> unloadedInSearchScope = ((GlobalSearchScope)this.mySearchScopeToWarnOfFallingOutOf).getUnloadedModulesBelongingToScope();
            Set<UnloadedModuleDescription> unloadedInUseScope = this.getUnloadedModulesBelongingToUseScopes();
            if (unloadedInUseScope != null) {
                return ContainerUtil.intersection(unloadedInSearchScope, unloadedInUseScope);
            }
            return unloadedInSearchScope;
        });
        if (collection == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private Set<UnloadedModuleDescription> getUnloadedModulesBelongingToUseScopes() {
        LinkedHashSet<UnloadedModuleDescription> resolveScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (UsageTarget target2 : this.mySearchFor) {
            if (!(target2 instanceof PsiElementUsageTarget)) {
                return null;
            }
            PsiElement element2 = ((PsiElementUsageTarget)target2).getElement();
            if (element2 == null) {
                return null;
            }
            SearchScope useScope = element2.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            resolveScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return resolveScope;
    }

    @NotNull
    private static HyperlinkListener addHrefHandling(final @Nullable HyperlinkListener listener2, final @NotNull String hrefTarget, final @NotNull Runnable handler2) {
        if (hrefTarget == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(13);
        }
        if (handler2 == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(14);
        }
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(hrefTarget)) {
                    handler2.run();
                } else if (listener2 != null) {
                    listener2.hyperlinkUpdate(e);
                }
            }
        };
    }

    @NotNull
    private static String wrapInHtml(@NotNull List<String> strings) {
        if (strings == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(15);
        }
        String string = XmlStringUtil.wrapInHtml(StringUtil.join(strings, "<br>"));
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String detailedLargeFilesMessage(@NotNull Collection<? extends VirtualFile> largeFiles) {
        String message;
        if (largeFiles == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(17);
        }
        if (largeFiles.size() == 1) {
            VirtualFile vFile2 = largeFiles.iterator().next();
            message = "File " + SearchForUsagesRunnable.presentableFileInfo(vFile2) + " is ";
        } else {
            message = "Files<br> " + StringUtil.join(ContainerUtil.getFirstItems(new ArrayList<VirtualFile>(largeFiles), 10), vFile -> SearchForUsagesRunnable.presentableFileInfo(vFile), "<br> ") + "<br> are ";
        }
        String string = message = message + "too large and cannot be scanned";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String presentableFileInfo(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(19);
        }
        String string = SearchForUsagesRunnable.getPresentablePath(vFile) + "&nbsp;(" + UsageViewManagerImpl.presentableSize(UsageViewManagerImpl.getFileLength(vFile)) + ")";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(21);
        }
        String string = "'" + ReadAction.compute(virtualFile2::getPresentableUrl) + "'";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private HyperlinkListener createGotToOptionsListener(final UsageTarget @NotNull [] targets2) {
        if (targets2 == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(23);
        }
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(SearchForUsagesRunnable.FIND_OPTIONS_HREF_TARGET)) {
                    FindManager.getInstance(SearchForUsagesRunnable.this.myProject).showSettingsAndFindUsages(targets2);
                }
            }
        };
    }

    @NotNull
    private HyperlinkListener createSearchInProjectListener() {
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                PsiElement psiElement;
                if (e.getDescription().equals(SearchForUsagesRunnable.SEARCH_IN_PROJECT_HREF_TARGET) && (psiElement = SearchForUsagesRunnable.getPsiElement(SearchForUsagesRunnable.this.mySearchFor)) != null) {
                    FindManager.getInstance(SearchForUsagesRunnable.this.myProject).findUsagesInScope(psiElement, GlobalSearchScope.projectScope(SearchForUsagesRunnable.this.myProject));
                }
            }
        };
    }

    private static PsiElement getPsiElement(UsageTarget @NotNull [] searchFor) {
        UsageTarget target2;
        if (searchFor == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(24);
        }
        if (!((target2 = searchFor[0]) instanceof PsiElementUsageTarget)) {
            return null;
        }
        return ReadAction.compute(((PsiElementUsageTarget)target2)::getElement);
    }

    private static void flashUsageScriptaculously(@NotNull Usage usage) {
        if (usage == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(25);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo2UsageAdapter usageInfo = (UsageInfo2UsageAdapter)usage;
        Editor editor = usageInfo.openTextEditor(true);
        if (editor == null) {
            return;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, attributes, 6);
        ArrayList segments2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(segments2);
        usageInfo.processRangeMarkers(processor2);
        rangeBlinker.resetMarkers(segments2);
        rangeBlinker.startBlinking();
    }

    private UsageViewEx getUsageView(@NotNull ProgressIndicator indicator) {
        UsageView usageView;
        if (indicator == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(26);
        }
        if ((usageView = this.myUsageViewRef.get()) != null) {
            return usageView;
        }
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (!(usageCount >= 2 || usageCount == 1 && this.myProcessPresentation.isShowPanelIfOnlyOneUsage())) {
            return null;
        }
        usageView = this.myUsageViewManager.createUsageView(this.mySearchFor, Usage.EMPTY_ARRAY, this.myPresentation, (Factory)this.mySearcherFactory);
        if (this.myUsageViewRef.compareAndSet(null, (UsageViewEx)usageView)) {
            usageView.associateProgress(indicator);
            if (this.myProcessPresentation.isShowFindOptionsPrompt()) {
                this.openView((UsageViewEx)usageView);
            } else if (this.myListener != null) {
                SwingUtilities.invokeLater(() -> {
                    UsageViewEx uv;
                    if (!this.myProject.isDisposed() && (uv = this.myUsageViewRef.get()) != null) {
                        this.myListener.usageViewCreated(uv);
                    }
                });
            }
            Usage firstUsage = this.myFirstUsage.get();
            if (firstUsage != null) {
                UsageView finalUsageView = usageView;
                ApplicationManager.getApplication().runReadAction(() -> SearchForUsagesRunnable.lambda$getUsageView$4((UsageViewEx)finalUsageView, firstUsage));
            }
        } else {
            UsageView finalUsageView = usageView;
            Disposer.register(this.myProject, usageView);
            ((AppUIExecutor)AppUIExecutor.onUiThread(ModalityState.any()).expireWith(this.myProject)).execute(() -> SearchForUsagesRunnable.lambda$getUsageView$5((UsageViewEx)finalUsageView));
        }
        return this.myUsageViewRef.get();
    }

    private void openView(@NotNull UsageViewEx usageView) {
        if (usageView == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(27);
        }
        SwingUtilities.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myUsageViewManager.showUsageView(usageView, this.myPresentation);
            if (this.myListener != null) {
                this.myListener.usageViewCreated(usageView);
            }
            this.myUsageViewManager.showToolWindow(false);
        });
    }

    @Override
    public void run() {
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        AtomicBoolean findUsagesStartedShown = new AtomicBoolean();
        this.searchUsages(findUsagesStartedShown);
        this.endSearchForUsages(findUsagesStartedShown);
        snapshot.logResponsivenessSinceCreation("Find Usages");
    }

    private void searchUsages(@NotNull AtomicBoolean findStartedBalloonShown) {
        ProgressIndicator current2;
        if (findStartedBalloonShown == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(28);
        }
        if ((current2 = ProgressManager.getInstance().getProgressIndicator()) == null) {
            throw new IllegalStateException("must run find usages under progress");
        }
        ProgressIndicator indicator = ProgressWrapper.unwrapAll(current2);
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(indicator);
        }
        TooManyUsagesStatus.createFor(indicator);
        Alarm findUsagesStartedBalloon = new Alarm();
        findUsagesStartedBalloon.addRequest(() -> {
            this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList(StringUtil.escapeXmlEntities(UsageViewManagerImpl.getProgressTitle(this.myPresentation))));
            findStartedBalloonShown.set(true);
        }, 300, ModalityState.NON_MODAL);
        UsageSearcher usageSearcher = this.mySearcherFactory.create();
        usageSearcher.generate((Processor<? super Usage>)((Processor<Usage>)usage -> {
            boolean incrementCounter;
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (currentIndicator == null) {
                throw new IllegalStateException("must run find usages under progress");
            }
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll(current2);
            ProgressManager.checkCanceled();
            if (!UsageViewManagerImpl.isInScope(usage, this.mySearchScopeToWarnOfFallingOutOf)) {
                this.myOutOfScopeUsages.incrementAndGet();
                return true;
            }
            boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, this.mySearchFor);
            if (incrementCounter) {
                int usageCount = this.myUsageCountWithoutDefinition.incrementAndGet();
                if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                    this.myFirstUsage.compareAndSet((Usage)null, (Usage)usage);
                }
                UsageViewEx usageView = this.getUsageView(originalIndicator);
                TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom(originalIndicator);
                if (usageCount > 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                    UsageViewManagerImpl.showTooManyUsagesWarningLater(this.myProject, tooManyUsagesStatus, originalIndicator, this.myPresentation, usageCount, usageView);
                }
                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                if (usageView != null) {
                    ApplicationManager.getApplication().runReadAction(() -> usageView.appendUsage((Usage)usage));
                }
            }
            return true;
        }));
        if (this.getUsageView(indicator) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.myUsageViewManager.showToolWindow(true), this.myProject.getDisposed());
        }
        Disposer.dispose(findUsagesStartedBalloon);
        ApplicationManager.getApplication().invokeLater(() -> {
            Balloon balloon;
            if (findStartedBalloonShown.get() && (balloon = ToolWindowManager.getInstance(this.myProject).getToolWindowBalloon("Find")) != null) {
                balloon.hide();
            }
        }, this.myProject.getDisposed());
    }

    private void endSearchForUsages(@NotNull AtomicBoolean findStartedBalloonShown) {
        UsageViewEx usageView;
        if (findStartedBalloonShown == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(29);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount == 0) {
            if (this.myProcessPresentation.isShowNotFoundMessage()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myProcessPresentation.isCanceled()) {
                        this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList("Usage search was canceled"));
                        findStartedBalloonShown.set(false);
                        return;
                    }
                    String message = UsageViewBundle.message("dialog.no.usages.found.in", StringUtil.decapitalize(StringUtil.notNullize(this.myPresentation.getUsagesString())), this.myPresentation.getScopeText(), this.myPresentation.getContextText());
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add(StringUtil.escapeXmlEntities(message));
                    if (this.myOutOfScopeUsages.get() != 0) {
                        lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                    }
                    if (this.myProcessPresentation.isShowFindOptionsPrompt()) {
                        lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                    }
                    MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines);
                    findStartedBalloonShown.set(false);
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        } else if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Usage usage = this.myFirstUsage.get();
                if (usage.canNavigate()) {
                    usage.navigate(true);
                    SearchForUsagesRunnable.flashUsageScriptaculously(usage);
                }
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("Only one usage found.");
                if (this.myOutOfScopeUsages.get() != 0) {
                    lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                }
                lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines);
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            HyperlinkListener hyperlinkListener;
            List<Object> lines;
            usageView = this.myUsageViewRef.get();
            usageView.searchFinished();
            if (this.myOutOfScopeUsages.get() == 0 || SearchForUsagesRunnable.getPsiElement(this.mySearchFor) == null) {
                lines = Collections.emptyList();
                hyperlinkListener = null;
            } else {
                lines = Arrays.asList(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf), SearchForUsagesRunnable.createSearchInProjectHtml());
                hyperlinkListener = this.createSearchInProjectListener();
            }
            if (!this.myProcessPresentation.getLargeFiles().isEmpty() || this.myOutOfScopeUsages.get() != 0 || this.myProcessPresentation.searchIncludingProjectFileUsages() != null || !this.getUnloadedModulesBelongingToScope().isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    this.notifyByFindBalloon(hyperlinkListener, type, lines);
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        }
        if ((usageView = this.myUsageViewRef.get()) != null) {
            usageView.waitForUpdateRequestsCompletion();
        }
        if (this.myListener != null) {
            this.myListener.findingUsagesFinished(usageView);
        }
    }

    @NotNull
    private static String mayHaveUsagesInUnloadedModulesMessage(@NotNull Collection<? extends UnloadedModuleDescription> unloadedModules) {
        if (unloadedModules == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(30);
        }
        String modulesText = unloadedModules.size() > 1 ? unloadedModules.size() + " unloaded modules" : "unloaded module '" + Objects.requireNonNull(ContainerUtil.getFirstItem(unloadedModules)).getName() + "'";
        String string = "Occurrences in " + modulesText + " may be skipped. Load all modules and repeat the search to get complete results.";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void lambda$getUsageView$5(UsageViewEx finalUsageView) {
        Disposer.dispose(finalUsageView);
    }

    private static /* synthetic */ void lambda$getUsageView$4(UsageViewEx finalUsageView, Usage firstUsage) {
        finalUsageView.appendUsage(firstUsage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcherFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScopeToWarnOfFallingOutOf";
                break;
            }
            case 7: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFor";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/SearchForUsagesRunnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hrefTarget";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "largeFiles";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findStartedBalloonShown";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/SearchForUsagesRunnable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsHtml";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtml";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "detailedLargeFilesMessage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "presentableFileInfo";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "mayHaveUsagesInUnloadedModulesMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsHtml";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 31: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyByFindBalloon";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addHrefHandling";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtml";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "detailedLargeFilesMessage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "presentableFileInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createGotToOptionsListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "flashUsageScriptaculously";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUsageView";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "openView";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "searchUsages";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endSearchForUsages";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveUsagesInUnloadedModulesMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

