/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Alarm
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(Alarm.class);
    private volatile boolean myDisposed;
    private final List<Request> myRequests;
    private final List<Request> myPendingRequests;
    private final ScheduledExecutorService myExecutorService;
    private final Object LOCK;
    private final ThreadToUse myThreadToUse;
    private JComponent myActivationComponent;

    @Override
    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.cancelAllRequests();
            if (this.myExecutorService != EdtExecutorService.getScheduledExecutorInstance()) {
                this.myExecutorService.shutdownNow();
            }
        }
    }

    private void checkDisposed() {
        LOG.assertTrue(!this.myDisposed, "Already disposed");
    }

    public Alarm() {
        this(ThreadToUse.SWING_THREAD);
    }

    public Alarm(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            Alarm.$$$reportNull$$$0(0);
        }
        this(ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public Alarm(@NotNull ThreadToUse threadToUse) {
        if (threadToUse == null) {
            Alarm.$$$reportNull$$$0(1);
        }
        this(threadToUse, null);
    }

    public Alarm(@NotNull ThreadToUse threadToUse, @Nullable Disposable parentDisposable) {
        if (threadToUse == null) {
            Alarm.$$$reportNull$$$0(2);
        }
        this.myRequests = new SmartList<Request>();
        this.myPendingRequests = new SmartList<Request>();
        this.LOCK = new Object();
        this.myThreadToUse = threadToUse;
        ScheduledExecutorService scheduledExecutorService = this.myExecutorService = threadToUse == ThreadToUse.SWING_THREAD ? EdtExecutorService.getScheduledExecutorInstance() : AppExecutorUtil.createBoundedScheduledExecutorService("Alarm Pool", 1);
        if (parentDisposable == null) {
            if (threadToUse != ThreadToUse.SWING_THREAD) {
                boolean crash = threadToUse == ThreadToUse.POOLED_THREAD || ApplicationManager.getApplication().isUnitTestMode();
                IllegalArgumentException t = new IllegalArgumentException("You must provide parent Disposable for non-swing thread Alarm");
                if (crash) {
                    throw t;
                }
                LOG.warn(t);
            }
        } else {
            Disposer.register(parentDisposable, this);
        }
    }

    public void addRequest(final @NotNull Runnable request2, final int delay, boolean runWithActiveFrameOnly) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(3);
        }
        if (runWithActiveFrameOnly && !ApplicationManager.getApplication().isActive()) {
            MessageBus bus = ApplicationManager.getApplication().getMessageBus();
            final MessageBusConnection connection = bus.connect(this);
            connection.subscribe(ApplicationActivationListener.TOPIC, new ApplicationActivationListener(){

                @Override
                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    connection.disconnect();
                    Alarm.this.addRequest(request2, delay);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/util/Alarm$1", "applicationActivated"));
                }
            });
        } else {
            this.addRequest(request2, delay);
        }
    }

    private ModalityState getModalityState() {
        if (this.myThreadToUse != ThreadToUse.SWING_THREAD) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return null;
        }
        return application.getDefaultModalityState();
    }

    public void addRequest(@NotNull Runnable request2, long delayMillis) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(4);
        }
        this._addRequest(request2, delayMillis, this.getModalityState());
    }

    public void addRequest(@NotNull Runnable request2, int delayMillis) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(5);
        }
        this._addRequest(request2, delayMillis, this.getModalityState());
    }

    public void addComponentRequest(@NotNull Runnable request2, int delayMillis) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(6);
        }
        assert (this.myActivationComponent != null);
        this._addRequest(request2, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addComponentRequest(@NotNull Runnable request2, long delayMillis) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(7);
        }
        assert (this.myActivationComponent != null);
        this._addRequest(request2, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addRequest(@NotNull Runnable request2, int delayMillis, @Nullable ModalityState modalityState) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request2, delayMillis, modalityState);
    }

    /*
     * WARNING - void declaration
     */
    public void addRequest(@NotNull Runnable request2, long delayMillis, @Nullable ModalityState modalityState) {
        void modalityState2;
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request2, delayMillis, (ModalityState)modalityState2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllAndAddRequest(@NotNull Runnable request2, int delayMillis, @Nullable ModalityState modalityState) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(10);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelAllRequests();
            this._addRequest(request2, delayMillis, modalityState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void _addRequest(@NotNull Runnable request2, long delayMillis, @Nullable ModalityState modalityState) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(11);
        }
        Object object = this.LOCK;
        synchronized (object) {
            void modalityState2;
            this.checkDisposed();
            Request requestToSchedule = new Request(request2, (ModalityState)modalityState2, delayMillis);
            if (this.myActivationComponent == null || this.myActivationComponent.isShowing()) {
                this._add(requestToSchedule);
            } else if (!this.myPendingRequests.contains(requestToSchedule)) {
                this.myPendingRequests.add(requestToSchedule);
            }
        }
    }

    private void _add(@NotNull Request requestToSchedule) {
        if (requestToSchedule == null) {
            Alarm.$$$reportNull$$$0(12);
        }
        requestToSchedule.schedule();
        this.myRequests.add(requestToSchedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPending() {
        Object object = this.LOCK;
        synchronized (object) {
            for (Request each : this.myPendingRequests) {
                this._add(each);
            }
            this.myPendingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(@NotNull Runnable request2) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(13);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelAndRemoveRequestFrom(request2, this.myRequests);
            this.cancelAndRemoveRequestFrom(request2, this.myPendingRequests);
            return true;
        }
    }

    private void cancelAndRemoveRequestFrom(@NotNull Runnable request2, @NotNull List<? extends Request> list2) {
        if (request2 == null) {
            Alarm.$$$reportNull$$$0(14);
        }
        if (list2 == null) {
            Alarm.$$$reportNull$$$0(15);
        }
        for (int i = list2.size() - 1; i >= 0; --i) {
            Request r = list2.get(i);
            if (r.myTask != request2) continue;
            r.cancel();
            list2.remove(i);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAllRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.cancelAllRequests(this.myRequests) + this.cancelAllRequests(this.myPendingRequests);
        }
    }

    private int cancelAllRequests(@NotNull List<? extends Request> list2) {
        if (list2 == null) {
            Alarm.$$$reportNull$$$0(16);
        }
        int count = list2.size();
        for (Request request2 : list2) {
            request2.cancel();
        }
        list2.clear();
        return count;
    }

    public void drainRequestsInTest() {
        for (Runnable task2 : this.getUnfinishedRequests()) {
            task2.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected List<Runnable> getUnfinishedRequests() {
        ArrayList<Runnable> unfinishedTasks;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myRequests.isEmpty()) {
                List<Runnable> list2 = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl5 : MonitorExitStatement: MONITOREXIT : var2_1
                if (list2 == null) {
                    Alarm.$$$reportNull$$$0(17);
                }
                return list2;
            }
            unfinishedTasks = new ArrayList<Runnable>(this.myRequests.size());
            for (Request request2 : this.myRequests) {
                Runnable existingTask = request2.cancel();
                if (existingTask == null) continue;
                unfinishedTasks.add(existingTask);
            }
            this.myRequests.clear();
        }
        ArrayList<Runnable> arrayList = unfinishedTasks;
        if (arrayList == null) {
            Alarm.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void waitForAllExecuted(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Request> requests;
        if (timeUnit == null) {
            Alarm.$$$reportNull$$$0(19);
        }
        Iterator iterator2 = this.LOCK;
        synchronized (iterator2) {
            requests = new ArrayList<Request>(this.myRequests);
        }
        for (Request request2 : requests) {
            void unit;
            Future future2;
            Object object = this.LOCK;
            synchronized (object) {
                future2 = request2.myFuture;
            }
            if (future2 == null) continue;
            future2.get(timeout, (TimeUnit)unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.isEmpty();
        }
    }

    @NotNull
    public Alarm setActivationComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            Alarm.$$$reportNull$$$0(20);
        }
        this.myActivationComponent = component2;
        new UiNotifyConnector(component2, new Activatable(){

            @Override
            public void showNotify() {
                Alarm.this.flushPending();
            }

            @Override
            public void hideNotify() {
            }
        });
        Alarm alarm2 = this;
        if (alarm2 == null) {
            Alarm.$$$reportNull$$$0(21);
        }
        return alarm2;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadToUse";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestToSchedule";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/Alarm";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/Alarm";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnfinishedRequests";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setActivationComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRequest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addComponentRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cancelAllAndAddRequest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "_addRequest";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "_add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cancelRequest";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveRequestFrom";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cancelAllRequests";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllExecuted";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setActivationComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Request
    implements Runnable {
        private Runnable myTask;
        private final ModalityState myModalityState;
        private Future<?> myFuture;
        private final long myDelayMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Async.Schedule
        private Request(@Nullable Runnable task2, ModalityState modalityState, long delayMillis) {
            if (task2 == null) {
                Request.$$$reportNull$$$0(0);
            }
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                this.myTask = task2;
                this.myModalityState = modalityState;
                this.myDelayMillis = delayMillis;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable task2;
                if (Alarm.this.myDisposed) {
                    return;
                }
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    task2 = this.myTask;
                    this.myTask = null;
                }
                if (task2 != null) {
                    this.runSafely(task2);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Async.Execute
        private void runSafely(@Nullable Runnable task2) {
            try {
                if (!Alarm.this.myDisposed && task2 != null) {
                    QueueProcessor.runSafely((Runnable)task2);
                }
            }
            finally {
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    Alarm.this.myRequests.remove(this);
                    this.myFuture = null;
                }
            }
        }

        private void schedule() {
            this.myFuture = this.myModalityState == null ? Alarm.this.myExecutorService.schedule(this, this.myDelayMillis, TimeUnit.MILLISECONDS) : EdtScheduledExecutorService.getInstance().schedule((Runnable)this, this.myModalityState, this.myDelayMillis, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Runnable cancel() {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                Future<?> future2 = this.myFuture;
                if (future2 != null) {
                    future2.cancel(false);
                    this.myFuture = null;
                }
                Runnable task2 = this.myTask;
                this.myTask = null;
                return task2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Runnable task2;
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                task2 = this.myTask;
            }
            return super.toString() + (task2 != null ? ": " + task2 : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/Alarm$Request", "<init>"));
        }
    }

    public static enum ThreadToUse {
        SWING_THREAD,
        SHARED_THREAD,
        POOLED_THREAD,
        OWN_THREAD;

    }
}

