/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BufferedListConsumer<T>
implements Consumer<List<T>> {
    private final int myInterval;
    private long myTs;
    private final int mySize;
    private List<T> myBuffer;
    private final Object myFlushLock;
    private final Consumer<? super List<T>> myConsumer;
    private int myCnt;
    private boolean myPendingFlush;

    public BufferedListConsumer(int size, Consumer<? super List<T>> consumer, int interval) {
        this.mySize = size;
        this.myFlushLock = new Object();
        this.myBuffer = new ArrayList<T>(size);
        this.myConsumer = consumer;
        this.myInterval = interval;
        this.myTs = System.currentTimeMillis();
        this.myCnt = 0;
        this.myPendingFlush = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeOne(T t) {
        Object object = this.myFlushLock;
        synchronized (object) {
            ++this.myCnt;
            this.myBuffer.add(t);
            this.flushCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(List<T> list2) {
        Object object = this.myFlushLock;
        synchronized (object) {
            this.myCnt += list2.size();
            this.myBuffer.addAll(list2);
            this.flushCheck();
        }
    }

    private void flushCheck() {
        long ts = System.currentTimeMillis();
        if (this.myBuffer.size() >= this.mySize || this.myInterval > 0 && ts - (long)this.myInterval > this.myTs) {
            this.flushImpl(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushImpl(long ts) {
        Object object = this.myFlushLock;
        synchronized (object) {
            if (this.myPendingFlush || this.myBuffer.isEmpty()) {
                return;
            }
            this.myPendingFlush = true;
            this.invokeConsumer(this.createConsumerRunnable(ts));
        }
    }

    protected void invokeConsumer(@NotNull Runnable consumerRunnable) {
        if (consumerRunnable == null) {
            BufferedListConsumer.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().executeOnPooledThread(consumerRunnable);
    }

    @NotNull
    private Runnable createConsumerRunnable(long ts) {
        Runnable runnable2 = () -> {
            List<T> list2;
            Object object = this.myFlushLock;
            synchronized (object) {
                this.myTs = ts;
                this.myPendingFlush = false;
                if (this.myBuffer.isEmpty()) {
                    return;
                }
                list2 = this.myBuffer;
                this.myBuffer = new ArrayList<T>(this.mySize);
            }
            this.myConsumer.consume(list2);
        };
        if (runnable2 == null) {
            BufferedListConsumer.$$$reportNull$$$0(1);
        }
        return runnable2;
    }

    public void flush() {
        this.flushImpl(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCnt() {
        Object object = this.myFlushLock;
        synchronized (object) {
            return this.myCnt;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumerRunnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/BufferedListConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/BufferedListConsumer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsumerRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeConsumer";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

