/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.CachedValueBase;
import com.intellij.util.CachedValueLeakChecker;
import com.intellij.util.CachedValueStabilityChecker;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.DefaultCachedValuesFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CachedValuesManagerImpl
extends CachedValuesManager {
    private static final Object NULL = new Object();
    private ConcurrentMap<UserDataHolder, Object> myCacheHolders = ContainerUtil.createConcurrentWeakMap(ContainerUtil.identityStrategy());
    private Set<Key<?>> myKeys = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project2) {
        this.myProject = project2;
        CachedValuesFactory factory = project2.getService(CachedValuesFactory.class);
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project2) : factory;
    }

    @NonInjectable
    public CachedValuesManagerImpl(Project project2, CachedValuesFactory factory) {
        this.myProject = project2;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project2) : factory;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(0);
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(1);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(2);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(3);
        }
        return parameterizedCachedValue;
    }

    @Override
    @Nullable
    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value2;
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(4);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(6);
        }
        if ((value2 = dataHolder.getUserData(key)) instanceof CachedValueBase && ((CachedValueBase)((Object)value2)).isFromMyProject(this.myProject)) {
            Getter<T> data2 = value2.getUpToDateOrNull();
            if (data2 != null) {
                return data2.get();
            }
            CachedValueStabilityChecker.checkProvidersEquivalent(provider, value2.getValueProvider(), key);
        }
        if (value2 == null) {
            value2 = this.saveInUserData(dataHolder, key, this.freshCachedValue(dataHolder, key, provider, trackValue));
        }
        return value2.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CachedValue<T> saveInUserData(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, CachedValue<T> value2) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(7);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(8);
        }
        this.trackKeyHolder(dataHolder, key);
        if (dataHolder instanceof UserDataHolderEx) {
            return ((UserDataHolderEx)dataHolder).putUserDataIfAbsent(key, value2);
        }
        UserDataHolder userDataHolder = dataHolder;
        synchronized (userDataHolder) {
            CachedValue<T> existing = dataHolder.getUserData(key);
            if (existing != null) {
                return existing;
            }
            dataHolder.putUserData(key, value2);
            return value2;
        }
    }

    @Override
    protected void trackKeyHolder(@NotNull UserDataHolder dataHolder, @NotNull Key<?> key) {
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(9);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(10);
        }
        this.myCacheHolders.put(dataHolder, NULL);
        this.myKeys.add(key);
    }

    private <T> CachedValue<T> freshCachedValue(UserDataHolder dh, Key<CachedValue<T>> key, CachedValueProvider<T> provider, boolean trackValue) {
        CachedValueLeakChecker.checkProvider(provider, key, dh);
        CachedValue<T> value2 = this.createCachedValue(provider, trackValue);
        assert (((CachedValueBase)((Object)value2)).isFromMyProject(this.myProject));
        return value2;
    }

    @ApiStatus.Internal
    public void clearCachedValues() {
        for (UserDataHolder holder : this.myCacheHolders.keySet()) {
            for (Key<?> key : this.myKeys) {
                holder.putUserData(key, null);
            }
        }
        CachedValueStabilityChecker.cleanupFieldCache();
        this.myCacheHolders = ContainerUtil.createConcurrentWeakMap(ContainerUtil.identityStrategy());
        this.myKeys = ContainerUtil.newConcurrentSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterizedCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createParameterizedCachedValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveInUserData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "trackKeyHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

