/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentsUtil {
    protected static final String DISPOSABLE_KEY = "TabContentDisposable";

    public static void addOrReplaceContent(ContentManager manager, Content content2, boolean select) {
        String contentName = content2.getDisplayName();
        Content[] contents = manager.getContents();
        Content oldContentFound = null;
        for (Content oldContent : contents) {
            if (oldContent.isPinned() || !oldContent.getDisplayName().equals(contentName)) continue;
            oldContentFound = oldContent;
            break;
        }
        manager.addContent(content2);
        if (oldContentFound != null) {
            manager.removeContent(oldContentFound, true);
        }
        if (select) {
            manager.setSelectedContent(content2);
        }
    }

    public static void addContent(ContentManager manager, Content content2, boolean select) {
        manager.addContent(content2);
        if (select) {
            manager.setSelectedContent(content2);
        }
    }

    public static void closeContentTab(@NotNull ContentManager contentManager2, @NotNull Content content2) {
        TabbedContent tabbedContent;
        if (contentManager2 == null) {
            ContentsUtil.$$$reportNull$$$0(0);
        }
        if (content2 == null) {
            ContentsUtil.$$$reportNull$$$0(1);
        }
        if (content2 instanceof TabbedContent && (tabbedContent = (TabbedContent)content2).hasMultipleTabs()) {
            JComponent component2 = tabbedContent.getComponent();
            tabbedContent.removeContent(component2);
            contentManager2.setSelectedContent(tabbedContent, true, true);
            ContentsUtil.dispose(component2);
            return;
        }
        contentManager2.removeContent(content2, true);
    }

    @Nullable
    public static Disposable getDisposable(@NotNull JComponent contentComponent) {
        Object disposable2;
        if (contentComponent == null) {
            ContentsUtil.$$$reportNull$$$0(2);
        }
        if ((disposable2 = contentComponent.getClientProperty(DISPOSABLE_KEY)) instanceof Disposable) {
            return (Disposable)disposable2;
        }
        return null;
    }

    public static void dispose(@NotNull JComponent component2) {
        Disposable disposable2;
        if (component2 == null) {
            ContentsUtil.$$$reportNull$$$0(3);
        }
        if ((disposable2 = ContentsUtil.getDisposable(component2)) == null) {
            return;
        }
        Disposer.dispose(disposable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ContentsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "closeContentTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisposable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "dispose";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

