/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageType;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.BitUtil;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageLoader
implements Serializable {
    public static final int ALLOW_FLOAT_SCALING = 1;
    public static final byte USE_CACHE = 2;
    public static final int DARK = 4;
    public static final int FIND_SVG = 8;
    public static final long CACHED_IMAGE_MAX_SIZE = (long)(SystemProperties.getFloatProperty("ide.cached.image.max.size", 1.5f) * 1024.0f * 1024.0f);
    private static LoadFunction measureLoad;
    public static final Component ourComponent;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.util.ImageLoader");
        if (logger == null) {
            ImageLoader.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void clearCache() {
        ImageDescriptorList.IO_MISS_CACHE.clear();
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(1);
        }
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(2);
        }
        return ImageLoader.loadFromUrl(url, allowFloatScaling, true, new ImageFilter[]{null}, ScaleContext.create());
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, boolean useCache, ImageFilter[] filters, ScaleContext ctx) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(3);
        }
        int flags = 8;
        if (allowFloatScaling) {
            flags |= 1;
        }
        if (useCache) {
            flags |= 2;
        }
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        return ImageLoader.loadFromUrl(url, null, flags, filters, ctx);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, @Nullable Class aClass, int flags, ImageFilter @Nullable [] filters, ScaleContext scaleContext) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(4);
        }
        return ImageLoader.loadFromUrl(url.toString(), aClass, flags, filters, scaleContext);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull String path2, @Nullable Class aClass, final int flags, ImageFilter @Nullable [] filters, final ScaleContext scaleContext) {
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(5);
        }
        return ImageDescriptorList.create(path2, flags, scaleContext).load(ImageConverterChain.create().withFilter(filters).with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDescriptor desc) {
                if (source != null && desc.type != ImageType.SVG) {
                    double scale = ImageLoader.adjustScaleFactor(BitUtil.isSet(flags, 1), scaleContext.getScale(DerivedScaleType.PIX_SCALE));
                    if (desc.scale > 1.0) {
                        scale /= desc.scale;
                    }
                    source = ImageLoader.scaleImage(source, scale);
                }
                return source;
            }
        }).withHiDPI(scaleContext), BitUtil.isSet(flags, 2), aClass);
    }

    private static double adjustScaleFactor(boolean allowFloatScaling, double scale) {
        return allowFloatScaling ? scale : (JBUIScale.isHiDPI(scale) ? 2.0 : 1.0);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, double scale) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(6);
        }
        if (scale == 1.0) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(7);
            }
            return image2;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(8);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image3 = image;
            if (image3 == null) {
                ImageLoader.$$$reportNull$$$0(9);
            }
            return image3;
        }
        int width = (int)Math.round(scale * (double)w);
        int height = (int)Math.round(scale * (double)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(10);
        }
        return bufferedImage;
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetSize) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(11);
        }
        return ImageLoader.scaleImage(image, targetSize, targetSize);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetWidth, int targetHeight) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(12);
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(targetWidth, targetHeight);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(13);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0 || w == targetWidth && h == targetHeight) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(14);
            }
            return image2;
        }
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(15);
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        Class<?> callerClass;
        if (s == null) {
            ImageLoader.$$$reportNull$$$0(16);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path2, @NotNull Class aClass) {
        if (path2 == null) {
            ImageLoader.$$$reportNull$$$0(17);
        }
        if (aClass == null) {
            ImageLoader.$$$reportNull$$$0(18);
        }
        ScaleContext scaleContext = ScaleContext.create();
        int flags = 9;
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        return ImageDescriptorList.create(path2, flags, scaleContext).load(ImageConverterChain.create().withHiDPI(scaleContext), true, aClass);
    }

    public static Image loadFromBytes(byte @NotNull [] bytes) {
        if (bytes == null) {
            ImageLoader.$$$reportNull$$$0(19);
        }
        return ImageLoader.loadFromStream(new ByteArrayInputStream(bytes));
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(20);
        }
        return ImageLoader.loadFromStream(inputStream, ScaleContext.create(), null);
    }

    @Deprecated
    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(21);
        }
        return ImageLoader.loadFromStream(inputStream, ScaleContext.create(ScaleType.OBJ_SCALE.of(scale)), null);
    }

    @Deprecated
    public static Image loadFromStream(@NotNull InputStream inputStream, int scale, ImageFilter filter2) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(22);
        }
        return ImageLoader.loadFromStream(inputStream, ScaleContext.create(ScaleType.OBJ_SCALE.of(scale)), filter2);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, @NotNull ScaleContext ctx, ImageFilter filter2) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(23);
        }
        if (ctx == null) {
            ImageLoader.$$$reportNull$$$0(24);
        }
        try {
            ImageDescriptor desc = new ImageDescriptor(ctx.getScale(DerivedScaleType.PIX_SCALE));
            Image image = desc.loadFromStream(inputStream, null, null);
            return ImageConverterChain.create().withFilter(filter2).withHiDPI(ctx).convert(image, desc);
        }
        catch (IOException ex) {
            ImageLoader.getLogger().error(ex);
            return null;
        }
    }

    @Nullable
    public static Image loadCustomIcon(@NotNull File f) throws IOException {
        Image icon2;
        if (f == null) {
            ImageLoader.$$$reportNull$$$0(25);
        }
        if ((icon2 = ImageLoader._loadImageFromFile(f)) == null) {
            return null;
        }
        int w = icon2.getWidth(null);
        int h = icon2.getHeight(null);
        if (w <= 0 || h <= 0) {
            ImageLoader.getLogger().error("negative image size: w=" + w + ", h=" + h + ", path=" + f.getPath());
            return null;
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            double s = (double)EmptyIcon.ICON_18.getIconWidth() / (double)Math.max(w, h);
            return ImageLoader.scaleImage(icon2, s);
        }
        return icon2;
    }

    @Nullable
    private static Image _loadImageFromFile(@NotNull File f) throws IOException {
        if (f == null) {
            ImageLoader.$$$reportNull$$$0(26);
        }
        ScaleContext ctx = ScaleContext.create();
        double scale = ctx.getScale(DerivedScaleType.PIX_SCALE);
        ImageDescriptor desc = new ImageDescriptor(f.toURI().toURL().toString(), scale, StringUtilRt.endsWithIgnoreCase(f.getPath(), ".svg") ? ImageType.SVG : ImageType.IMG);
        return ImageUtil.ensureHiDPI(desc.load(true), ctx);
    }

    static {
        ourComponent = new Component(){};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ImageLoader";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ImageLoader";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scaleImage";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadFromBytes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadCustomIcon";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "_loadImageFromFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        ImageConverterChain withFilter(ImageFilter @Nullable [] filters) {
            if (filters == null) {
                return this;
            }
            ImageConverterChain chain = this;
            for (ImageFilter filter2 : filters) {
                chain = chain.withFilter(filter2);
            }
            return chain;
        }

        ImageConverterChain withFilter(final ImageFilter filter2) {
            if (filter2 == null) {
                return this;
            }
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDescriptor desc) {
                    return ImageUtil.filter(source, filter2);
                }
            });
        }

        ImageConverterChain withHiDPI(final ScaleContext ctx) {
            if (ctx == null) {
                return this;
            }
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDescriptor desc) {
                    double usrScale = ctx.getScale(DerivedScaleType.EFF_USR_SCALE);
                    return ImageUtil.ensureHiDPI(source, ctx, desc.origUsrSize.getWidth() * usrScale, desc.origUsrSize.getHeight() * usrScale);
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDescriptor desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDescriptor var2);
    }

    private static final class ImageDescriptorList {
        private static final Set<String> IO_MISS_CACHE = ContainerUtil.newConcurrentSet();
        private final List<ImageDescriptor> list;
        private final String name;
        private final ImageType type;

        private ImageDescriptorList(@NotNull List<ImageDescriptor> list2, @NotNull String name, @NotNull ImageType type) {
            if (list2 == null) {
                ImageDescriptorList.$$$reportNull$$$0(0);
            }
            if (name == null) {
                ImageDescriptorList.$$$reportNull$$$0(1);
            }
            if (type == null) {
                ImageDescriptorList.$$$reportNull$$$0(2);
            }
            this.list = list2;
            this.name = name;
            this.type = type;
        }

        @Nullable
        public Image load() {
            return this.load(ImageConverterChain.create());
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters2) {
            if (converters2 == null) {
                ImageDescriptorList.$$$reportNull$$$0(3);
            }
            return this.load(converters2, true, null);
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters2, boolean useCache, @Nullable Class<?> resourceClass) {
            String cacheKey;
            if (converters2 == null) {
                ImageDescriptorList.$$$reportNull$$$0(4);
            }
            if (IO_MISS_CACHE.contains(cacheKey = this.name + "." + this.type.name())) {
                return null;
            }
            long start2 = StartUpMeasurer.isEnabled() ? StartUpMeasurer.getCurrentTime() : -1L;
            boolean ioExceptionThrown = false;
            Image result2 = null;
            for (ImageDescriptor descriptor2 : this.list) {
                try {
                    Image image = descriptor2.load(useCache, resourceClass);
                    if (image == null) continue;
                    ImageLoader.getLogger().debug("Loaded image: " + descriptor2);
                    result2 = converters2.convert(image, descriptor2);
                    if (start2 == -1L) break;
                    IconLoadMeasurer.addLoading(descriptor2.type, (int)(StartUpMeasurer.getCurrentTime() - start2));
                    break;
                }
                catch (IOException e) {
                    ioExceptionThrown = true;
                }
            }
            if (result2 == null && ioExceptionThrown) {
                IO_MISS_CACHE.add(cacheKey);
            }
            return result2;
        }

        @NotNull
        public static ImageDescriptorList create(@NotNull String path2, int flags, @NotNull ScaleContext scaleContext) {
            if (path2 == null) {
                ImageDescriptorList.$$$reportNull$$$0(5);
            }
            if (scaleContext == null) {
                ImageDescriptorList.$$$reportNull$$$0(6);
            }
            double pixScale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
            boolean retina = JBUIScale.isHiDPI(pixScale);
            ImageDescriptorListBuilder builder2 = new ImageDescriptorListBuilder(FileUtilRt.getNameWithoutExtension(path2), FileUtilRt.getExtension(path2), BitUtil.isSet(flags, 8), ImageLoader.adjustScaleFactor(BitUtil.isSet(flags, 1), pixScale));
            boolean isDark = BitUtil.isSet(flags, 4);
            if (!path2.startsWith("file:") && path2.contains("://")) {
                builder2.add(StringUtilRt.endsWithIgnoreCase(StringUtil.substringBeforeLast(path2, "?"), ".svg") ? ImageType.SVG : ImageType.IMG);
            } else if (retina && isDark) {
                builder2.add(true, true);
                builder2.add(true, false);
            } else if (isDark) {
                builder2.add(false, true);
                builder2.add(false, false);
            } else if (retina) {
                builder2.add(true, false);
            } else {
                builder2.add(false, false);
            }
            ImageDescriptorList imageDescriptorList = builder2.build();
            if (imageDescriptorList == null) {
                ImageDescriptorList.$$$reportNull$$$0(7);
            }
            return imageDescriptorList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converters";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scaleContext";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ImageLoader$ImageDescriptorList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ImageLoader$ImageDescriptorList";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ImageDescriptorListBuilder {
        private final List<ImageDescriptor> list = new SmartList<ImageDescriptor>();
        final String name;
        final String ext;
        final boolean svg;
        final double scale;

        ImageDescriptorListBuilder(String name, String ext, boolean svg, double scale) {
            this.name = name;
            this.ext = ext;
            this.svg = svg;
            this.scale = scale;
        }

        void add(boolean retina, boolean dark) {
            if (this.svg) {
                this.add(retina, dark, ImageType.SVG);
            }
            this.add(retina, dark, ImageType.IMG);
        }

        void add(boolean retina, boolean dark, ImageType type) {
            String _ext;
            String string = _ext = ImageType.SVG == type ? "svg" : this.ext;
            double _scale = ImageType.SVG == type ? this.scale : (retina ? 2.0 : 1.0);
            this.list.add(new ImageDescriptor(this.name + (dark ? "_dark" : "") + (retina ? "@2x" : "") + "." + _ext, _scale, type));
            if (retina && dark) {
                this.list.add(new ImageDescriptor(this.name + "@2x_dark." + _ext, _scale, type));
            }
            if (retina) {
                this.list.add(new ImageDescriptor(this.name + (dark ? "_dark" : "") + "." + _ext, ImageType.SVG == type ? this.scale : 1.0, type));
            }
        }

        void add(ImageType type) {
            this.list.add(new ImageDescriptor(this.name + "." + this.ext, 1.0, type, true));
        }

        @NotNull
        ImageDescriptorList build() {
            return new ImageDescriptorList(this.list, this.name, this.svg ? ImageType.SVG : ImageType.IMG);
        }
    }

    public static final class Dimension2DDouble {
        private double myWidth;
        private double myHeight;

        public Dimension2DDouble(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public void setSize(Dimension2DDouble size) {
            this.myWidth = size.myWidth;
            this.myHeight = size.myHeight;
        }

        public void setSize(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public double getWidth() {
            return this.myWidth;
        }

        public double getHeight() {
            return this.myHeight;
        }
    }

    @ApiStatus.Internal
    public static interface LoadFunction {
        public Image load(@Nullable LoadFunction var1, @NotNull ImageType var2) throws IOException;
    }
}

