/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class UriUtil {
    public static final CharMatcher PARAM_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"?#;");

    private UriUtil() {
    }

    @NotNull
    public static String trimTrailingSlashes(@NotNull String url) {
        if (url == null) {
            UriUtil.$$$reportNull$$$0(0);
        }
        String string = StringUtil.trimTrailing(url, '/');
        if (string == null) {
            UriUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String trimLeadingSlashes(@NotNull String url) {
        if (url == null) {
            UriUtil.$$$reportNull$$$0(2);
        }
        String string = StringUtil.trimLeading(url, '/');
        if (string == null) {
            UriUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String trimParameters(@NotNull String url) {
        int end;
        if (url == null) {
            UriUtil.$$$reportNull$$$0(4);
        }
        return (end = PARAM_CHAR_MATCHER.indexIn((CharSequence)url)) != -1 ? url.substring(0, end) : url;
    }

    @NotNull
    public static Couple<String> splitScheme(@NotNull String url) {
        ArrayList list2;
        if (url == null) {
            UriUtil.$$$reportNull$$$0(5);
        }
        if ((list2 = Lists.newArrayList((Iterable)Splitter.on((String)"://").limit(2).split((CharSequence)url))).size() == 1) {
            Couple<String> couple = Couple.of("", list2.get(0));
            if (couple == null) {
                UriUtil.$$$reportNull$$$0(6);
            }
            return couple;
        }
        Couple<String> couple = Couple.of(list2.get(0), list2.get(1));
        if (couple == null) {
            UriUtil.$$$reportNull$$$0(7);
        }
        return couple;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/UriUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/UriUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailingSlashes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeadingSlashes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "splitScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailingSlashes";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "trimLeadingSlashes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trimParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "splitScheme";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

