/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaitForProgressToShow {
    private WaitForProgressToShow() {
    }

    public static void runOrInvokeAndWaitAboveProgress(Runnable command) {
        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(command, ModalityState.defaultModalityState());
    }

    public static void runOrInvokeAndWaitAboveProgress(Runnable command, @Nullable ModalityState modalityState) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            command.run();
        } else {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                WaitForProgressToShow.execute(pi);
                application.invokeAndWait(command);
            } else {
                ModalityState notNullModalityState = modalityState == null ? ModalityState.NON_MODAL : modalityState;
                application.invokeAndWait(command, notNullModalityState);
            }
        }
    }

    public static void runOrInvokeLaterAboveProgress(Runnable command, @Nullable ModalityState modalityState, @NotNull Project project2) {
        Application application;
        if (project2 == null) {
            WaitForProgressToShow.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            command.run();
        } else {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                WaitForProgressToShow.execute(pi);
                application.invokeLater(command, pi.getModalityState(), o -> !project2.isOpen() || project2.isDisposed());
            } else {
                ModalityState notNullModalityState = modalityState == null ? ModalityState.NON_MODAL : modalityState;
                application.invokeLater(command, notNullModalityState, project2.getDisposed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ProgressIndicator pi) {
        if (pi.isShowing()) {
            long maxWait = 3000L;
            long start2 = System.currentTimeMillis();
            while (!pi.isPopupWasShown() && pi.isRunning() && System.currentTimeMillis() - 3000L < start2) {
                Object lock;
                Object object = lock = new Object();
                synchronized (object) {
                    try {
                        lock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ProgressManager.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/WaitForProgressToShow", "runOrInvokeLaterAboveProgress"));
    }
}

