/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

public final class BoundedTaskExecutor
extends AbstractExecutorService {
    private static final Logger LOG = Logger.getInstance(BoundedTaskExecutor.class);
    private volatile boolean myShutdown;
    @NotNull
    private final String myName;
    private final Executor myBackendExecutor;
    private final int myMaxThreads;
    private final AtomicLong myStatus;
    private final BlockingQueue<Runnable> myTaskQueue;
    private final boolean myChangeThreadName;

    BoundedTaskExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxThreads, boolean changeThreadName) {
        if (name == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(0);
        }
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(1);
        }
        this.myStatus = new AtomicLong();
        this.myTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.myName = name;
        this.myBackendExecutor = backendExecutor;
        if (maxThreads < 1) {
            throw new IllegalArgumentException("maxThreads must be >=1 but got: " + maxThreads);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxThreads = maxThreads;
        this.myChangeThreadName = changeThreadName;
    }

    @Deprecated
    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks) {
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(2);
        }
        this(ExceptionUtil.getThrowableText(new Throwable("Creation point:")), backendExecutor, maxSimultaneousTasks, true);
    }

    BoundedTaskExecutor(@NotNull String name, @NotNull Executor backendExecutor, int maxSimultaneousTasks, @NotNull Disposable parent) {
        if (name == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(3);
        }
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(5);
        }
        this(name, backendExecutor, maxSimultaneousTasks, true);
        Disposer.register(parent, () -> this.shutdownNow());
    }

    static Object info(Runnable info) {
        Runnable task2 = info;
        String extra = null;
        if (task2 instanceof FutureTask) {
            extra = ((FutureTask)task2).isCancelled() ? " (future cancelled)" : (((FutureTask)task2).isDone() ? " (future done)" : null);
            task2 = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task2.getClass(), task2, Callable.class, "callable"), task2);
        }
        if (task2 instanceof Callable && task2.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task2 = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task2.getClass(), task2, Runnable.class, "task"), task2);
        }
        return extra == null ? task2 : task2.getClass() + extra;
    }

    @Override
    public void shutdown() {
        if (this.myShutdown) {
            throw new IllegalStateException("Already shut down: " + this);
        }
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        List<Runnable> list2 = this.clearAndCancelAll();
        if (list2 == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(7);
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("you must call shutdown() or shutdownNow() first");
        }
        try {
            void unit;
            this.waitAllTasksExecuted(timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    public void execute(@NotNull @Async.Schedule Runnable task2) {
        if (task2 == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(8);
        }
        if (this.isShutdown() && !(task2 instanceof LastTask)) {
            throw new RejectedExecutionException("Already shutdown");
        }
        long status = this.incrementCounterAndTimestamp();
        int inProgress = (int)status;
        assert (inProgress > 0) : inProgress;
        if (inProgress <= this.myMaxThreads) {
            this.wrapAndExecute(task2, status);
            return;
        }
        if (!this.myTaskQueue.offer(task2)) {
            throw new RejectedExecutionException();
        }
        Runnable next = this.pollOrGiveUp(status);
        if (next != null) {
            this.wrapAndExecute(next, status);
        }
    }

    private long incrementCounterAndTimestamp() {
        return this.myStatus.updateAndGet(status -> status + 1L + 0x100000000L & Long.MAX_VALUE);
    }

    private Runnable pollOrGiveUp(long status) {
        while (true) {
            Runnable next;
            int inProgress = (int)status;
            assert (inProgress > 0) : inProgress;
            if (inProgress <= this.myMaxThreads && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                return next;
            }
            if (this.myStatus.compareAndSet(status, status - 1L)) break;
            status = this.myStatus.get();
        }
        return null;
    }

    private void wrapAndExecute(@NotNull Runnable firstTask, final long status) {
        if (firstTask == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(9);
        }
        try {
            final AtomicReference<Runnable> currentTask = new AtomicReference<Runnable>(firstTask);
            this.myBackendExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (BoundedTaskExecutor.this.myChangeThreadName) {
                        String name = BoundedTaskExecutor.this.myName;
                        if (StartUpMeasurer.isEnabled()) {
                            name = name + "[" + Thread.currentThread().getName() + "]";
                        }
                        ConcurrencyUtil.runUnderThreadName(name, this::execute);
                    } else {
                        this.execute();
                    }
                }

                private void execute() {
                    Runnable task2 = (Runnable)currentTask.get();
                    do {
                        currentTask.set(task2);
                        BoundedTaskExecutor.doRun(task2);
                    } while ((task2 = BoundedTaskExecutor.this.pollOrGiveUp(status)) != null);
                }

                public String toString() {
                    return String.valueOf(BoundedTaskExecutor.info((Runnable)currentTask.get()));
                }
            });
        }
        catch (Error | RuntimeException e) {
            this.myStatus.decrementAndGet();
            throw e;
        }
    }

    private static void doRun(@Async.Execute Runnable task2) {
        block4: {
            try {
                task2.run();
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) break block4;
                try {
                    LOG.error(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitAllTasksExecuted(long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(10);
        }
        CountDownLatch started = new CountDownLatch(this.myMaxThreads);
        CountDownLatch readyToFinish = new CountDownLatch(1);
        Runnable runnable2 = () -> {
            try {
                started.countDown();
                readyToFinish.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxThreads, null), __ -> {
            LastTask wait = new LastTask(runnable2);
            this.execute(wait);
            return wait;
        });
        try {
            if (!started.await(timeout, (TimeUnit)unit)) {
                throw new TimeoutException("Interrupted by timeout. " + this);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            readyToFinish.countDown();
        }
        for (Future future2 : futures) {
            future2.get(timeout, (TimeUnit)unit);
        }
    }

    public boolean isEmpty() {
        return (int)this.myStatus.get() == 0;
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>();
        this.myTaskQueue.drainTo(queued);
        for (Runnable task2 : queued) {
            if (!(task2 instanceof FutureTask)) continue;
            ((FutureTask)task2).cancel(false);
        }
        ArrayList<Runnable> arrayList = queued;
        if (arrayList == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public String toString() {
        return "BoundedExecutor(" + this.myMaxThreads + ")" + (this.isShutdown() ? " SHUTDOWN " : "") + "; inProgress: " + (int)this.myStatus.get() + (this.myTaskQueue.isEmpty() ? "" : "; queue: " + this.myTaskQueue.size() + "[" + ContainerUtil.map(this.myTaskQueue, BoundedTaskExecutor::info) + "]") + "; name: " + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/BoundedTaskExecutor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/BoundedTaskExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAndCancelAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndExecute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "waitAllTasksExecuted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LastTask
    extends FutureTask<Void> {
        LastTask(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                LastTask.$$$reportNull$$$0(0);
            }
            super(runnable2, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/concurrency/BoundedTaskExecutor$LastTask", "<init>"));
        }
    }
}

