/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.Invoker;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface Command<T>
extends Supplier<T>,
Consumer<T> {

    public static final class Processor {
        public final Invoker foreground;
        public final Invoker background;

        public Processor(@NotNull Invoker foreground, @NotNull Invoker background) {
            if (foreground == null) {
                Processor.$$$reportNull$$$0(0);
            }
            if (background == null) {
                Processor.$$$reportNull$$$0(1);
            }
            this.foreground = foreground;
            this.background = background;
        }

        public <T> void consume(Consumer<? super T> consumer, T value2) {
            if (consumer != null) {
                this.foreground.invoke(() -> consumer.accept((Object)value2));
            }
        }

        public <T> void process(Command<T> command) {
            if (command != null) {
                this.background.compute(command).onSuccess(value2 -> this.consume(command, value2));
            }
        }

        public <T> void process(Supplier<? extends T> supplier, Consumer<? super T> consumer) {
            if (supplier != null) {
                this.background.compute(supplier).onSuccess(value2 -> this.consume(consumer, value2));
            } else {
                this.consume(consumer, null);
            }
        }

        public int getTaskCount() {
            if (this.foreground == this.background) {
                return this.background.getTaskCount();
            }
            return this.foreground.getTaskCount() + this.background.getTaskCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foreground";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/concurrency/Command$Processor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

