/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.util.Comparing;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractProperty<T> {
    public static final Comparator<AbstractProperty> NAME_COMPARATOR = (property, property1) -> property.getName().compareTo(property1.getName());

    @NonNls
    public abstract String getName();

    public abstract T getDefault(AbstractPropertyContainer var1);

    public abstract T copy(T var1);

    public boolean areEqual(T value1, T value2) {
        return Comparing.equal(value1, value2);
    }

    public T get(AbstractPropertyContainer container2) {
        return (T)container2.getValueOf(this);
    }

    public void set(AbstractPropertyContainer container2, T value2) {
        container2.setValueOf(this, value2);
    }

    public final T cast(Object value2) {
        return (T)value2;
    }

    public String toString() {
        return this.getName();
    }

    public static abstract class AbstractPropertyContainer<PropertyImpl extends AbstractProperty> {
        public static final AbstractPropertyContainer EMPTY = new AbstractPropertyContainer(){

            public Object getValueOf(AbstractProperty property) {
                return property.getDefault(this);
            }

            public void setValueOf(AbstractProperty property, Object value2) {
                throw new UnsupportedOperationException("Property: " + property.getName() + " value: " + value2);
            }

            @Override
            public boolean hasProperty(AbstractProperty property) {
                return false;
            }
        };

        protected abstract Object getValueOf(PropertyImpl var1);

        protected abstract void setValueOf(PropertyImpl var1, Object var2);

        public abstract boolean hasProperty(AbstractProperty var1);

        protected final <T> void delegateSet(AbstractPropertyContainer container2, AbstractProperty<T> property, T value2) {
            container2.setValueOf(property, value2);
        }

        protected final <T> T delegateGet(AbstractPropertyContainer container2, AbstractProperty<T> property) {
            return (T)container2.getValueOf(property);
        }

        public final void copyFrom(AbstractPropertyContainer source, AbstractProperty[] properties) {
            for (AbstractProperty property : properties) {
                this.setValueOf(property, source.getValueOf(property));
            }
        }

        public final boolean areValueEqual(AbstractPropertyContainer other, AbstractProperty[] properties) {
            for (AbstractProperty property : properties) {
                if (property.areEqual(this.getValueOf(property), other.getValueOf(property))) continue;
                return false;
            }
            return true;
        }
    }
}

