/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SmartList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.Externalizer;
import com.intellij.util.config.IntProperty;
import com.intellij.util.config.ListProperty;
import com.intellij.util.config.StorageProperty;
import com.intellij.util.config.StringProperty;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExternalizablePropertyContainer
extends AbstractProperty.AbstractPropertyContainer {
    private static final Logger LOG = Logger.getInstance(ExternalizablePropertyContainer.class);
    private final Map<AbstractProperty, Object> myValues = new THashMap<AbstractProperty, Object>();
    private final Map<AbstractProperty, Externalizer> myExternalizers = new THashMap<AbstractProperty, Externalizer>();

    public <T> void registerProperty(AbstractProperty<T> property, Externalizer<T> externalizer) {
        String name = property.getName();
        LOG.assertTrue(!this.myExternalizers.containsKey(property), name);
        this.myExternalizers.put(property, externalizer);
    }

    public void rememberKey(AbstractProperty property) {
        LOG.assertTrue(this.myExternalizers.get(property) == null, property.getName());
        this.myExternalizers.put(property, null);
    }

    public void registerProperty(BooleanProperty property) {
        this.registerProperty(property, Externalizer.BOOLEAN);
    }

    public void registerProperty(StringProperty property) {
        this.registerProperty(property, Externalizer.STRING);
    }

    public void registerProperty(IntProperty property) {
        this.registerProperty(property, Externalizer.INTEGER);
    }

    public void registerProperty(StorageProperty property) {
        this.registerProperty(property, Externalizer.STORAGE);
    }

    public <T> void registerProperty(ListProperty<T> property, @NonNls String itemTagName, Externalizer<T> itemExternalizer) {
        this.registerProperty(property, ExternalizablePropertyContainer.createListExternalizer(itemExternalizer, itemTagName));
    }

    @Deprecated
    public <T extends JDOMExternalizable> void registerProperty(ListProperty<T> property, @NonNls String itemTagName, Factory<? extends T> factory) {
        this.registerProperty(property, itemTagName, Externalizer.FactoryBased.create(factory));
    }

    private static <T> Externalizer<List<T>> createListExternalizer(Externalizer<T> itemExternalizer, String itemTagName) {
        return new ListExternalizer<T>(itemExternalizer, itemTagName);
    }

    public void readExternal(@NotNull Element element2) {
        if (element2 == null) {
            ExternalizablePropertyContainer.$$$reportNull$$$0(0);
        }
        THashMap<String, AbstractProperty> propertyByName = new THashMap<String, AbstractProperty>();
        for (AbstractProperty abstractProperty : this.myExternalizers.keySet()) {
            propertyByName.put(abstractProperty.getName(), abstractProperty);
        }
        for (Element child2 : element2.getChildren()) {
            Externalizer externalizer;
            AbstractProperty property = (AbstractProperty)propertyByName.get(child2.getName());
            if (property == null || (externalizer = this.myExternalizers.get(property)) == null) continue;
            try {
                this.myValues.put(property, externalizer.readValue(child2));
            }
            catch (Exception e) {
                LOG.info(e);
            }
        }
    }

    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            ExternalizablePropertyContainer.$$$reportNull$$$0(1);
        }
        if (this.myExternalizers.isEmpty()) {
            return;
        }
        ArrayList<AbstractProperty> properties = new ArrayList<AbstractProperty>(this.myExternalizers.keySet());
        Collections.sort(properties, AbstractProperty.NAME_COMPARATOR);
        for (AbstractProperty property : properties) {
            Object propValue;
            Externalizer externalizer = this.myExternalizers.get(property);
            if (externalizer == null || Comparing.equal(propValue = property.get(this), property.getDefault(this))) continue;
            Element child2 = new Element(property.getName());
            externalizer.writeValue(child2, propValue);
            if (JDOMUtil.isEmpty(child2)) continue;
            element2.addContent(child2);
        }
    }

    protected Object getValueOf(AbstractProperty property) {
        Object value2 = this.myValues.get(property);
        return value2 != null ? value2 : property.getDefault(this);
    }

    protected void setValueOf(AbstractProperty externalizableProperty, Object value2) {
        this.myValues.put(externalizableProperty, value2);
    }

    @Override
    public boolean hasProperty(AbstractProperty property) {
        return this.myExternalizers.containsKey(property);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/util/config/ExternalizablePropertyContainer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ListExternalizer<T>
    implements Externalizer<List<T>> {
        @NonNls
        private static final String NULL_ELEMENT = "NULL_VALUE_ELEMENT";
        private final Externalizer<T> myItemExternalizer;
        private final String myItemTagName;

        ListExternalizer(Externalizer<T> itemExternalizer, String itemTagName) {
            this.myItemExternalizer = itemExternalizer;
            this.myItemTagName = itemTagName;
        }

        @Override
        public List<T> readValue(Element dataElement) {
            SmartList<T> list2 = new SmartList<T>();
            for (Element element2 : dataElement.getChildren()) {
                if (NULL_ELEMENT.equals(element2.getName())) {
                    list2.add(null);
                    continue;
                }
                if (!this.myItemTagName.equals(element2.getName())) continue;
                T item = this.myItemExternalizer.readValue(element2);
                if (item == null) {
                    LOG.error("Can't create element " + this.myItemExternalizer);
                    return list2;
                }
                list2.add(item);
            }
            return list2;
        }

        @Override
        public void writeValue(Element dataElement, List<T> value2) {
            for (T item : value2) {
                if (item == null) {
                    dataElement.addContent(new Element(NULL_ELEMENT));
                    continue;
                }
                Element element2 = new Element(this.myItemTagName);
                this.myItemExternalizer.writeValue(element2, item);
                if (item instanceof Externalizer.SkippableValue && JDOMUtil.isEmpty(element2)) continue;
                dataElement.addContent(element2);
            }
        }
    }
}

