/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.config.Storage;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface Externalizer<T> {
    @NonNls
    public static final String VALUE_ATTRIBUTE = "value";
    public static final Externalizer<String> STRING = new BaseExternalizer<String>(){

        @Override
        public String readValue(Element dataElement) {
            return dataElement.getAttributeValue(Externalizer.VALUE_ATTRIBUTE);
        }
    };
    public static final Externalizer<Integer> INTEGER = new BaseExternalizer<Integer>(){

        @Override
        public Integer readValue(Element dataElement) {
            try {
                return new Integer(dataElement.getAttributeValue(Externalizer.VALUE_ATTRIBUTE));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    };
    public static final Externalizer<Storage> STORAGE = new StorageExternalizer();
    public static final Externalizer<Boolean> BOOLEAN = new BaseExternalizer<Boolean>(){

        @Override
        public Boolean readValue(Element dataElement) {
            return Boolean.valueOf(dataElement.getAttributeValue(Externalizer.VALUE_ATTRIBUTE));
        }
    };

    public T readValue(Element var1);

    public void writeValue(Element var1, T var2);

    public static class StorageExternalizer
    implements Externalizer<Storage> {
        @NonNls
        private static final String ITEM_TAG = "item";
        @NonNls
        private static final String KEY_ATTR = "key";
        @NonNls
        private static final String VALUE_ATTR = "value";

        @Override
        public Storage readValue(Element dataElement) {
            Storage.MapStorage storage = new Storage.MapStorage();
            for (Element element2 : dataElement.getChildren(ITEM_TAG)) {
                storage.put(element2.getAttributeValue(KEY_ATTR), element2.getAttributeValue("value"));
            }
            return storage;
        }

        @Override
        public void writeValue(Element dataElement, Storage storage) {
            Iterator<String> keys2 = ((Storage.MapStorage)storage).getKeys();
            while (keys2.hasNext()) {
                String key = keys2.next();
                String value2 = storage.get(key);
                Element element2 = new Element(ITEM_TAG);
                element2.setAttribute(KEY_ATTR, key);
                if (value2 != null) {
                    element2.setAttribute("value", value2);
                }
                dataElement.addContent(element2);
            }
        }
    }

    public static class FactoryBased<T extends JDOMExternalizable>
    implements Externalizer<T> {
        private final Factory<? extends T> myFactory;

        public FactoryBased(@NotNull Factory<? extends T> factory) {
            if (factory == null) {
                FactoryBased.$$$reportNull$$$0(0);
            }
            this.myFactory = factory;
        }

        @Override
        public T readValue(Element dataElement) {
            JDOMExternalizable data2 = (JDOMExternalizable)this.myFactory.create();
            data2.readExternal(dataElement);
            return (T)data2;
        }

        @Override
        public void writeValue(Element dataElement, T value2) {
            value2.writeExternal(dataElement);
        }

        static <T extends JDOMExternalizable> FactoryBased<T> create(@NotNull Factory<? extends T> factory) {
            if (factory == null) {
                FactoryBased.$$$reportNull$$$0(1);
            }
            return new FactoryBased<T>(factory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "factory";
            objectArray2[1] = "com/intellij/util/config/Externalizer$FactoryBased";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface SkippableValue {
    }

    public static abstract class BaseExternalizer<T>
    implements Externalizer<T> {
        @Override
        public void writeValue(Element dataElement, T value2) {
            dataElement.setAttribute(Externalizer.VALUE_ATTRIBUTE, value2.toString());
        }
    }
}

