/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.Storage;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;

public class StorageProperty
extends AbstractProperty<Storage> {
    private final String myName;

    public StorageProperty(@NonNls String name) {
        this.myName = name;
    }

    @Override
    public Storage getDefault(AbstractProperty.AbstractPropertyContainer container2) {
        Storage.MapStorage storage = new Storage.MapStorage();
        this.set(container2, storage);
        return storage;
    }

    @Override
    public Storage copy(Storage storage) {
        if (!(storage instanceof Storage.MapStorage)) {
            throw new UnsupportedOperationException(storage.getClass().getName());
        }
        Iterator<String> keys2 = ((Storage.MapStorage)storage).getKeys();
        Storage.MapStorage copy2 = new Storage.MapStorage();
        while (keys2.hasNext()) {
            String key = keys2.next();
            copy2.put(key, storage.get(key));
        }
        return copy2;
    }

    @Override
    public String getName() {
        return this.myName;
    }
}

