/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BidirectionalMultiMap<K, V> {
    private final Map<K, Set<V>> myKey2Values;
    private final Map<V, Set<K>> myValue2Keys;

    public BidirectionalMultiMap() {
        this(new HashMap(), new HashMap());
    }

    public BidirectionalMultiMap(Map<K, Set<V>> key2Values, Map<V, Set<K>> value2Keys) {
        this.myKey2Values = key2Values;
        this.myValue2Keys = value2Keys;
    }

    @NotNull
    public Set<V> getValues(K key) {
        Set<V> set = this.myKey2Values.get(key);
        Set<Object> set2 = set != null ? set : Collections.emptySet();
        if (set2 == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(0);
        }
        return set2;
    }

    @NotNull
    public Set<K> getKeys(V value2) {
        Set<K> set = this.myValue2Keys.get(value2);
        Set<Object> set2 = set != null ? set : Collections.emptySet();
        if (set2 == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(1);
        }
        return set2;
    }

    public boolean containsKey(K key) {
        return this.myKey2Values.containsKey(key);
    }

    public boolean containsValue(V value2) {
        return this.myValue2Keys.containsKey(value2);
    }

    public boolean put(K key, V value2) {
        Set<K> ks = this.myValue2Keys.get(value2);
        if (ks == null) {
            ks = this.createKeysSet();
            this.myValue2Keys.put((Set<K>)value2, (Set<V>)ks);
        }
        ks.add(key);
        Set<V> vs = this.myKey2Values.get(key);
        if (vs == null) {
            vs = this.createValuesSet();
            this.myKey2Values.put(key, vs);
        }
        return vs.add(value2);
    }

    @NotNull
    protected Set<V> createValuesSet() {
        return new HashSet();
    }

    @NotNull
    protected Set<K> createKeysSet() {
        return new HashSet();
    }

    public boolean removeKey(K key) {
        Set<V> vs = this.myKey2Values.get(key);
        if (vs == null) {
            return false;
        }
        for (V v : vs) {
            Set<K> ks = this.myValue2Keys.get(v);
            ks.remove(key);
            if (!ks.isEmpty()) continue;
            this.myValue2Keys.remove(v);
        }
        this.myKey2Values.remove(key);
        return true;
    }

    public void remove(K key, V value2) {
        Set<V> vs = this.myKey2Values.get(key);
        Set<K> ks = this.myValue2Keys.get(value2);
        if (ks != null && vs != null) {
            ks.remove(key);
            vs.remove(value2);
            if (ks.isEmpty()) {
                this.myValue2Keys.remove(value2);
            }
            if (vs.isEmpty()) {
                this.myKey2Values.remove(key);
            }
        }
    }

    public boolean isEmpty() {
        return this.myKey2Values.isEmpty() && this.myValue2Keys.isEmpty();
    }

    public boolean removeValue(V value2) {
        Set<K> ks = this.myValue2Keys.get(value2);
        if (ks == null) {
            return false;
        }
        for (K k : ks) {
            Set<V> vs = this.myKey2Values.get(k);
            vs.remove(value2);
            if (!vs.isEmpty()) continue;
            this.myKey2Values.remove(k);
        }
        this.myValue2Keys.remove(value2);
        return true;
    }

    public void clear() {
        this.myKey2Values.clear();
        this.myValue2Keys.clear();
    }

    public Set<K> getKeys() {
        return this.myKey2Values.keySet();
    }

    public Set<V> getValues() {
        return this.myValue2Keys.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/containers/BidirectionalMultiMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

