/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentBitSet;

public class ConcurrentPackedBitsArray {
    private final int bitsPerChunk;
    private final ConcurrentBitSet bits = new ConcurrentBitSet();
    private final int mask;
    private final int chunksPerWord;

    public ConcurrentPackedBitsArray(int bitsPerChunk) {
        if (bitsPerChunk <= 0 || bitsPerChunk > 32) {
            throw new IllegalArgumentException("Bits-to-pack number must be between 1 and 32, but got: " + bitsPerChunk);
        }
        this.bitsPerChunk = bitsPerChunk;
        this.mask = bitsPerChunk == 32 ? -1 : (1 << bitsPerChunk) - 1;
        this.chunksPerWord = 32 / bitsPerChunk;
    }

    public long get(int id2) {
        assert (id2 >= 0) : id2;
        int bitIndex = id2 / this.chunksPerWord * 32 + id2 % this.chunksPerWord * this.bitsPerChunk;
        return this.bits.getWord(bitIndex) >> bitIndex;
    }

    public long set(int id2, long flags) {
        assert (id2 >= 0) : id2;
        if ((flags & (long)(~this.mask)) != 0L) {
            throw new IllegalArgumentException("Flags must be between 0 and " + this.mask + " but got:" + flags);
        }
        int bitIndex = id2 / this.chunksPerWord * 32 + id2 % this.chunksPerWord * this.bitsPerChunk;
        int prevChunk = this.bits.changeWord(bitIndex, word -> word & ~(this.mask << bitIndex) | (int)flags << bitIndex) >> bitIndex;
        return prevChunk;
    }

    public void clear() {
        this.bits.clear();
    }
}

