/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposableWrapperList<E>
extends AbstractList<E> {
    @NotNull
    private final List<DisposableWrapper> myWrappedList = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    public boolean add(E element2) {
        return this.myWrappedList.add(new DisposableWrapper(this, element2));
    }

    @Override
    public void add(int index, E element2) {
        this.myWrappedList.add(index, new DisposableWrapper(this, element2));
    }

    @NotNull
    public Disposable add(E element2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DisposableWrapperList.$$$reportNull$$$0(0);
        }
        DisposableWrapper disposableWrapper = this.createDisposableWrapper(element2, parentDisposable);
        this.myWrappedList.add(disposableWrapper);
        DisposableWrapper disposableWrapper2 = disposableWrapper;
        if (disposableWrapper2 == null) {
            DisposableWrapperList.$$$reportNull$$$0(1);
        }
        return disposableWrapper2;
    }

    @NotNull
    public Disposable add(int index, E element2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DisposableWrapperList.$$$reportNull$$$0(2);
        }
        DisposableWrapper disposableWrapper = this.createDisposableWrapper(element2, parentDisposable);
        this.myWrappedList.add(index, disposableWrapper);
        DisposableWrapper disposableWrapper2 = disposableWrapper;
        if (disposableWrapper2 == null) {
            DisposableWrapperList.$$$reportNull$$$0(3);
        }
        return disposableWrapper2;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        if (collection == null) {
            DisposableWrapperList.$$$reportNull$$$0(4);
        }
        Collection<DisposableWrapper> disposableWrappers = this.wrapAll(collection);
        return this.myWrappedList.addAll(disposableWrappers);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> collection) {
        if (collection == null) {
            DisposableWrapperList.$$$reportNull$$$0(5);
        }
        Collection<DisposableWrapper> disposableWrappers = this.wrapAll(collection);
        return this.myWrappedList.addAll(index, disposableWrappers);
    }

    @Override
    public boolean remove(@Nullable Object obj) {
        ArrayList removedWrappers = new ArrayList(1);
        boolean result2 = this.myWrappedList.removeIf(disposableWrapper -> {
            if (((DisposableWrapper)disposableWrapper).delegate.equals(obj) && (removedWrappers.isEmpty() && disposableWrapper.makeUnique() || removedWrappers.contains(disposableWrapper))) {
                removedWrappers.add(disposableWrapper);
                return true;
            }
            return false;
        });
        for (DisposableWrapper disposableWrapper2 : removedWrappers) {
            disposableWrapper2.disposeWithoutRemoval();
        }
        return result2;
    }

    @Override
    @Nullable
    public E remove(int index) {
        DisposableWrapper removedWrapper = this.myWrappedList.remove(index);
        return this.unwrapAndDispose(removedWrapper);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> objects) {
        if (objects == null) {
            DisposableWrapperList.$$$reportNull$$$0(6);
        }
        return this.removeIf(element2 -> objects.contains(element2));
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter2) {
        if (filter2 == null) {
            DisposableWrapperList.$$$reportNull$$$0(7);
        }
        THashSet<DisposableWrapper> removedWrappers = ContainerUtil.newIdentityTroveSet(this.myWrappedList.size());
        boolean result2 = this.myWrappedList.removeIf(disposableWrapper -> {
            if (filter2.test((Object)((DisposableWrapper)disposableWrapper).delegate) && (disposableWrapper.makeUnique() || removedWrappers.contains(disposableWrapper))) {
                removedWrappers.add(disposableWrapper);
                return true;
            }
            return false;
        });
        for (DisposableWrapper disposableWrapper2 : removedWrappers) {
            disposableWrapper2.disposeWithoutRemoval();
        }
        return result2;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> objects) {
        if (objects == null) {
            DisposableWrapperList.$$$reportNull$$$0(8);
        }
        return this.removeIf(element2 -> !objects.contains(element2));
    }

    @Override
    public void clear() {
        this.removeIf(__ -> true);
    }

    @Override
    public int size() {
        return this.myWrappedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myWrappedList.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new DisposableWrapperListIterator(0);
    }

    @Override
    public Object @NotNull [] toArray() {
        Object[] elements2 = this.myWrappedList.toArray();
        if (elements2.length == 0) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                DisposableWrapperList.$$$reportNull$$$0(9);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        int n = elements2.length;
        for (int i = 0; i < n; ++i) {
            elements2[i] = ((DisposableWrapper)elements2[i]).delegate;
        }
        if (elements2 == null) {
            DisposableWrapperList.$$$reportNull$$$0(10);
        }
        return elements2;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] array) {
        Object[] elements2;
        int len;
        if (array == null) {
            DisposableWrapperList.$$$reportNull$$$0(11);
        }
        if (array.length < (len = (elements2 = this.myWrappedList.toArray()).length)) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), len);
        } else {
            Arrays.fill(array, len, array.length, null);
        }
        for (int i = 0; i < len; ++i) {
            array[i] = ((DisposableWrapper)elements2[i]).delegate;
        }
        if (array == null) {
            DisposableWrapperList.$$$reportNull$$$0(12);
        }
        return array;
    }

    @Override
    public E get(int index) {
        return (E)this.myWrappedList.get(index).delegate;
    }

    @Override
    public E set(int index, E element2) {
        DisposableWrapper replaced = this.myWrappedList.set(index, new DisposableWrapper(this, element2));
        return this.unwrapAndDispose(replaced);
    }

    @Override
    public boolean contains(@Nullable Object obj) {
        return obj != null && this.myWrappedList.contains(new DisposableWrapper(this, obj));
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        if (collection == null) {
            DisposableWrapperList.$$$reportNull$$$0(13);
        }
        Collection<DisposableWrapper> disposableWrappers = this.wrapAll(collection);
        return this.myWrappedList.containsAll(disposableWrappers);
    }

    @Override
    public int indexOf(@Nullable Object obj) {
        return obj == null ? -1 : this.myWrappedList.indexOf(new DisposableWrapper(this, obj));
    }

    @Override
    public int lastIndexOf(@Nullable Object obj) {
        return obj == null ? -1 : this.myWrappedList.lastIndexOf(new DisposableWrapper(this, obj));
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return new DisposableWrapperListIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return new DisposableWrapperListIterator(index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private DisposableWrapper createDisposableWrapper(E element2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DisposableWrapperList.$$$reportNull$$$0(14);
        }
        DisposableWrapper disposableWrapper = new DisposableWrapper(this, element2, true);
        Disposer.register(parentDisposable, disposableWrapper);
        DisposableWrapper disposableWrapper2 = disposableWrapper;
        if (disposableWrapper2 == null) {
            DisposableWrapperList.$$$reportNull$$$0(15);
        }
        return disposableWrapper2;
    }

    @NotNull
    private Collection<DisposableWrapper> wrapAll(@NotNull Collection<? extends E> collection) {
        if (collection == null) {
            DisposableWrapperList.$$$reportNull$$$0(16);
        }
        if (collection.isEmpty()) {
            List<DisposableWrapper> list2 = Collections.emptyList();
            if (list2 == null) {
                DisposableWrapperList.$$$reportNull$$$0(17);
            }
            return list2;
        }
        ArrayList<DisposableWrapper> result2 = new ArrayList<DisposableWrapper>(collection.size());
        for (E obj : collection) {
            result2.add(new DisposableWrapper(this, obj));
        }
        ArrayList<DisposableWrapper> arrayList = result2;
        if (arrayList == null) {
            DisposableWrapperList.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Nullable
    private E unwrapAndDispose(@Nullable DisposableWrapper disposableWrapper) {
        if (disposableWrapper == null) {
            return null;
        }
        Object unwrapped = disposableWrapper.delegate;
        disposableWrapper.disposeWithoutRemoval();
        return (E)unwrapped;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/DisposableWrapperList";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/DisposableWrapperList";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisposableWrapper";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeIf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDisposableWrapper";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "wrapAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DisposableWrapperListIterator
    implements ListIterator<E> {
        @NotNull
        private final ListIterator<DisposableWrapper> myDelegate;
        @Nullable
        private DisposableWrapper myLastReturned;

        DisposableWrapperListIterator(int initialCursor) {
            this.myDelegate = DisposableWrapperList.this.myWrappedList.listIterator(initialCursor);
        }

        @Override
        public boolean hasNext() {
            return this.myDelegate.hasNext();
        }

        @Override
        public E next() {
            this.myLastReturned = this.myDelegate.next();
            return this.myLastReturned.delegate;
        }

        @Override
        public boolean hasPrevious() {
            return this.myDelegate.hasPrevious();
        }

        @Override
        public E previous() {
            this.myLastReturned = this.myDelegate.previous();
            return this.myLastReturned.delegate;
        }

        @Override
        public int nextIndex() {
            return this.myDelegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.myDelegate.previousIndex();
        }

        @Override
        public void remove() {
            if (this.myLastReturned == null) {
                throw new NoSuchElementException();
            }
            if (this.myLastReturned.makeUnique()) {
                this.myDelegate.remove();
                this.myLastReturned.disposeWithoutRemoval();
                this.myLastReturned = null;
            }
        }

        @Override
        public void set(E element2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E element2) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return this.myDelegate.equals(((DisposableWrapperListIterator)obj).myDelegate);
        }
    }

    private class DisposableWrapper
    extends AtomicBoolean
    implements Disposable {
        @NotNull
        private final E delegate;
        private boolean removeFromContainer;
        final /* synthetic */ DisposableWrapperList this$0;

        DisposableWrapper(@NotNull DisposableWrapperList disposableWrapperList, E obj) {
            if (obj == null) {
                DisposableWrapper.$$$reportNull$$$0(0);
            }
            this(disposableWrapperList, obj, false);
        }

        DisposableWrapper(@NotNull DisposableWrapperList disposableWrapperList, E delegate, boolean removeFromContainer) {
            if (delegate == null) {
                DisposableWrapper.$$$reportNull$$$0(1);
            }
            this.this$0 = disposableWrapperList;
            this.delegate = delegate;
            this.removeFromContainer = removeFromContainer;
        }

        @Override
        public void dispose() {
            if (this.removeFromContainer) {
                this.makeUnique();
                this.this$0.myWrappedList.remove(this);
            }
        }

        void disposeWithoutRemoval() {
            if (this.removeFromContainer) {
                this.removeFromContainer = false;
                Disposer.dispose(this);
            }
        }

        boolean makeUnique() {
            return this.compareAndSet(false, true);
        }

        private boolean isUnique() {
            return this.get();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DisposableWrapper other = (DisposableWrapper)obj;
            return this.delegate.equals(other.delegate) && !this.isUnique() && !other.isUnique();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "obj";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/DisposableWrapperList$DisposableWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

