/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.RefValueHashMap;
import com.intellij.util.containers.SimpleEntry;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class IntKeyWeakValueHashMap<V>
implements IntObjectMap<V> {
    private final TIntObjectHashMap<MyReference<V>> myMap = new TIntObjectHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    IntKeyWeakValueHashMap() {
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            int key = ref.key;
            this.myMap.remove(key);
        }
        return;
    }

    @Override
    public final V get(int key) {
        return (V)SoftReference.dereference(this.myMap.get(key));
    }

    @Override
    public final V put(int key, @NotNull V value2) {
        if (value2 == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(0);
        }
        this.processQueue();
        MyReference ref = new MyReference(key, value2, this.myQueue);
        MyReference oldRef = this.myMap.put(key, ref);
        return (V)SoftReference.dereference(oldRef);
    }

    @Override
    public final V remove(int key) {
        this.processQueue();
        MyReference<V> ref = this.myMap.remove(key);
        return SoftReference.dereference(ref);
    }

    @Override
    public final void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public final int size() {
        return this.myMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public final boolean containsKey(int key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    @NotNull
    public final Collection<V> values() {
        Object[] refs;
        ArrayList result2 = new ArrayList();
        for (Object o : refs = this.myMap.getValues()) {
            Object value2 = ((MyReference)o).get();
            if (value2 == null) continue;
            result2.add(value2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public int @NotNull [] keys() {
        throw new IncorrectOperationException("keys() makes no sense for weak/soft map because GC can clear the value any moment now");
    }

    @Override
    public boolean containsValue(@NotNull V value2) {
        if (value2 == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(2);
        }
        return this.values().contains(value2);
    }

    @Override
    @NotNull
    public Set<IntObjectMap.Entry<V>> entrySet() {
        return new MyEntrySetView();
    }

    @NotNull
    private Iterator<IntObjectMap.Entry<V>> entriesIterator() {
        final MovingIterator<V> entryIterator = new MovingIterator<V>(this.myMap);
        return new Iterator<IntObjectMap.Entry<V>>(){
            private IntObjectMap.Entry<V> nextVEntry;
            private int lastReturned;
            {
                this.nextAliveEntry();
            }

            @Override
            public boolean hasNext() {
                return this.nextVEntry != null;
            }

            @Override
            public IntObjectMap.Entry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntObjectMap.Entry result2 = this.nextVEntry;
                this.lastReturned = result2.getKey();
                this.nextAliveEntry();
                return result2;
            }

            private void nextAliveEntry() {
                while (entryIterator.hasNext()) {
                    entryIterator.advance();
                    MyReference ref = (MyReference)entryIterator.value();
                    Object v = ref.get();
                    if (v == null) continue;
                    int key = entryIterator.key();
                    this.nextVEntry = new SimpleEntry(key, v);
                    return;
                }
                this.nextVEntry = null;
            }

            @Override
            public void remove() {
                IntKeyWeakValueHashMap.this.myMap.remove(this.lastReturned);
                entryIterator.removed();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/IntKeyWeakValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/IntKeyWeakValueHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MovingIterator<V>
    extends TIntObjectIterator<MyReference<V>> {
        MovingIterator(TIntObjectHashMap<MyReference<V>> map2) {
            super(map2);
        }

        void removed() {
            --this._expectedSize;
        }
    }

    private class MyEntrySetView
    extends AbstractSet<IntObjectMap.Entry<V>> {
        private MyEntrySetView() {
        }

        @Override
        @NotNull
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            Iterator iterator2 = IntKeyWeakValueHashMap.this.entriesIterator();
            if (iterator2 == null) {
                MyEntrySetView.$$$reportNull$$$0(0);
            }
            return iterator2;
        }

        @Override
        public int size() {
            return IntKeyWeakValueHashMap.this.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/IntKeyWeakValueHashMap$MyEntrySetView", "iterator"));
        }
    }

    private static class MyReference<T>
    extends WeakReference<T> {
        private final int key;

        private MyReference(int key, @NotNull T referent, ReferenceQueue<? super T> q) {
            if (referent == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            super(referent, q);
            this.key = key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/IntKeyWeakValueHashMap$MyReference", "<init>"));
        }
    }
}

