/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 3 / 2, 10));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public T removeLast() {
        if (this.myLast == 0) {
            this.isWrapped = !this.isWrapped;
            this.myLast = this.myArray.length;
        }
        --this.myLast;
        T result2 = this.getRaw(this.myLast);
        this.myArray[this.myLast] = null;
        return result2;
    }

    private T getRaw(int last) {
        return (T)this.myArray[last];
    }

    public T peekLast() {
        int last = this.myLast;
        if (last == 0) {
            last = this.myArray.length;
        }
        return this.getRaw(last - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    @NotNull
    public List<T> toList() {
        List<T> list2 = Arrays.asList(this.normalize(this.size()));
        if (list2 == null) {
            Queue.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public Object @NotNull [] toArray() {
        return this.normalize(this.size());
    }

    public T @NotNull [] toArray(T[] array) {
        if (array.length < this.size()) {
            array = ArrayUtil.newArray(ArrayUtil.getComponentType(array), this.size());
        }
        return this.normalize(array);
    }

    public T pullFirst() {
        T result2 = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result2;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        return this.getRaw(this.myFirst);
    }

    private int copyFromTo(int first, int last, Object[] result2, int destinationPos) {
        int length = last - first;
        System.arraycopy(this.myArray, first, result2, destinationPos, length);
        return length;
    }

    private T @NotNull [] normalize(int capacity) {
        Object[] result2 = new Object[capacity];
        return this.normalize(result2);
    }

    private T @NotNull [] normalize(T[] result2) {
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result2, 0);
            this.copyFromTo(0, this.myLast, result2, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result2, 0);
        }
        if (result2 == null) {
            Queue.$$$reportNull$$$0(1);
        }
        return result2;
    }

    public void clear() {
        Arrays.fill(this.myArray, null);
        this.myLast = 0;
        this.myFirst = 0;
        this.isWrapped = false;
    }

    public T set(int index, T value2) {
        int arrayIndex = this.myFirst + index;
        if (this.isWrapped && arrayIndex >= this.myArray.length) {
            arrayIndex -= this.myArray.length;
        }
        T old = this.getRaw(arrayIndex);
        this.myArray[arrayIndex] = value2;
        return old;
    }

    public T get(int index) {
        int arrayIndex = this.myFirst + index;
        if (this.isWrapped && arrayIndex >= this.myArray.length) {
            arrayIndex -= this.myArray.length;
        }
        return this.getRaw(arrayIndex);
    }

    public boolean process(@NotNull Processor<? super T> processor2) {
        if (processor2 == null) {
            Queue.$$$reportNull$$$0(2);
        }
        if (this.isWrapped) {
            T t;
            int i;
            for (i = this.myFirst; i < this.myArray.length; ++i) {
                t = this.getRaw(i);
                if (processor2.process(t)) continue;
                return false;
            }
            for (i = 0; i < this.myLast; ++i) {
                t = this.getRaw(i);
                if (processor2.process(t)) continue;
                return false;
            }
        } else {
            for (int i = this.myFirst; i < this.myLast; ++i) {
                T t = this.getRaw(i);
                if (processor2.process(t)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        return this.isWrapped ? "[ " + this.sub(this.myFirst, this.myArray.length) + " ||| " + this.sub(0, this.myLast) + " ]" : "[ " + this.sub(this.myFirst, this.myLast) + " ]";
    }

    private Object sub(int start2, int end) {
        if (start2 == end) {
            return "";
        }
        return Arrays.asList(this.myArray).subList(start2, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/Queue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/Queue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

