/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.SLRUCache;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentStringInterner {
    private final int myStripeMask;
    private final SLRUCache<String, String>[] myInterns;
    private final Lock[] myStripeLocks;

    public RecentStringInterner(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RecentStringInterner.$$$reportNull$$$0(0);
        }
        int stripes = 16;
        this.myInterns = new SLRUCache[16];
        this.myStripeLocks = new Lock[this.myInterns.length];
        int capacity = 8192;
        for (int i = 0; i < this.myInterns.length; ++i) {
            this.myInterns[i] = new SLRUCache<String, String>(capacity / 16, capacity / 16){

                @Override
                @NotNull
                public String createValue(String key) {
                    String string = key;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                protected void putToProtectedQueue(String key, @NotNull String value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.putToProtectedQueue(value2, value2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/util/containers/RecentStringInterner$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "value";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/util/containers/RecentStringInterner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "putToProtectedQueue";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myStripeLocks[i] = new ReentrantLock();
        }
        assert (Integer.highestOneBit(16) == 16);
        this.myStripeMask = 15;
        LowMemoryWatcher.register(this::clear, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Contract(value="null -> null")
    public String get(@Nullable String s) {
        if (s == null) {
            return null;
        }
        int stripe = Math.abs(s.hashCode()) & this.myStripeMask;
        try {
            this.myStripeLocks[stripe].lock();
            String string = this.myInterns[stripe].get(s);
            return string;
        }
        finally {
            this.myStripeLocks[stripe].unlock();
        }
    }

    public void clear() {
        for (int i = 0; i < this.myInterns.length; ++i) {
            try {
                this.myStripeLocks[i].lock();
                this.myInterns[i].clear();
                continue;
            }
            finally {
                this.myStripeLocks[i].unlock();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/containers/RecentStringInterner", "<init>"));
    }
}

