/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import gnu.trove.Equality;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class TransferToEDTQueue<T> {
    private static final int DEFAULT_THRESHOLD = 30;
    private final String myName;
    private final Processor<? super T> myProcessor;
    private volatile boolean stopped;
    private final Condition<?> myShutUpCondition;
    private final int myMaxUnitOfWorkThresholdMs;
    private final Queue<T> myQueue;
    private final AtomicBoolean invokeLaterScheduled;
    private final Runnable myUpdateRunnable;

    public TransferToEDTQueue(@NotNull @NonNls String name, @NotNull Processor<? super T> processor2, @NotNull Condition<?> shutUpCondition) {
        if (name == null) {
            TransferToEDTQueue.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            TransferToEDTQueue.$$$reportNull$$$0(1);
        }
        if (shutUpCondition == null) {
            TransferToEDTQueue.$$$reportNull$$$0(2);
        }
        this(name, processor2, shutUpCondition, 30);
    }

    public TransferToEDTQueue(@NotNull @NonNls String name, @NotNull Processor<? super T> processor2, @NotNull Condition<?> shutUpCondition, int maxUnitOfWorkThresholdMs) {
        if (name == null) {
            TransferToEDTQueue.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            TransferToEDTQueue.$$$reportNull$$$0(4);
        }
        if (shutUpCondition == null) {
            TransferToEDTQueue.$$$reportNull$$$0(5);
        }
        this.myQueue = new Queue(10);
        this.invokeLaterScheduled = new AtomicBoolean();
        this.myUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                boolean b = TransferToEDTQueue.this.invokeLaterScheduled.compareAndSet(true, false);
                assert (b);
                if (TransferToEDTQueue.this.stopped || TransferToEDTQueue.this.myShutUpCondition.value(null)) {
                    TransferToEDTQueue.this.stop();
                    return;
                }
                long start2 = System.currentTimeMillis();
                while (TransferToEDTQueue.this.processNext()) {
                    long finish = System.currentTimeMillis();
                    if (TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs == -1 || finish - start2 <= (long)TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs) continue;
                    break;
                }
                if (!TransferToEDTQueue.this.isEmpty()) {
                    TransferToEDTQueue.this.scheduleUpdate();
                }
            }

            public String toString() {
                return TransferToEDTQueue.this.getClass().getSimpleName() + "[" + TransferToEDTQueue.this.myName + "]";
            }
        };
        this.myName = name;
        this.myProcessor = processor2;
        this.myShutUpCondition = shutUpCondition;
        this.myMaxUnitOfWorkThresholdMs = maxUnitOfWorkThresholdMs;
    }

    public static TransferToEDTQueue<Runnable> createRunnableMerger(@NotNull @NonNls String name) {
        if (name == null) {
            TransferToEDTQueue.$$$reportNull$$$0(6);
        }
        return TransferToEDTQueue.createRunnableMerger(name, 30);
    }

    public static TransferToEDTQueue<Runnable> createRunnableMerger(@NotNull @NonNls String name, int maxUnitOfWorkThresholdMs) {
        if (name == null) {
            TransferToEDTQueue.$$$reportNull$$$0(7);
        }
        return new TransferToEDTQueue<Runnable>(name, runnable2 -> {
            runnable2.run();
            return true;
        }, Conditions.alwaysFalse(), maxUnitOfWorkThresholdMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.isEmpty();
        }
    }

    private boolean processNext() {
        T thing = this.pullFirst();
        if (thing == null) {
            return false;
        }
        if (!this.myProcessor.process(thing)) {
            this.stop();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T pullFirst() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.isEmpty() ? null : (T)this.myQueue.pullFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(@NotNull T thing) {
        if (thing == null) {
            TransferToEDTQueue.$$$reportNull$$$0(8);
        }
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.addLast(thing);
        }
        this.scheduleUpdate();
        return true;
    }

    public boolean offerIfAbsent(@NotNull T thing) {
        if (thing == null) {
            TransferToEDTQueue.$$$reportNull$$$0(9);
        }
        return this.offerIfAbsent(thing, ContainerUtil.canonicalStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsent(@NotNull T thing, @NotNull Equality<? super T> equality) {
        if (thing == null) {
            TransferToEDTQueue.$$$reportNull$$$0(10);
        }
        if (equality == null) {
            TransferToEDTQueue.$$$reportNull$$$0(11);
        }
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            boolean absent = this.myQueue.process(t -> !equality.equals(t, thing));
            if (absent) {
                this.myQueue.addLast(thing);
                this.scheduleUpdate();
            }
            return absent;
        }
    }

    private void scheduleUpdate() {
        if (!this.stopped && this.invokeLaterScheduled.compareAndSet(false, true)) {
            this.schedule(this.myUpdateRunnable);
        }
    }

    protected void schedule(@NotNull Runnable updateRunnable) {
        if (updateRunnable == null) {
            TransferToEDTQueue.$$$reportNull$$$0(12);
        }
        SwingUtilities.invokeLater(updateRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<T> dump() {
        Queue<T> queue = this.myQueue;
        // MONITORENTER : queue
        List<T> list2 = this.myQueue.toList();
        // MONITOREXIT : queue
        if (list2 != null) return list2;
        TransferToEDTQueue.$$$reportNull$$$0(13);
        return list2;
    }

    public void drain() {
        int processed2 = 0;
        while (this.processNext()) {
            ++processed2;
        }
    }

    public void waitFor() {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.schedule(semaphore::up);
        semaphore.waitFor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shutUpCondition";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thing";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateRunnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/TransferToEDTQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/TransferToEDTQueue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRunnableMerger";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "offer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "offerIfAbsent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

