/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class UnsignedShortArrayList
implements Cloneable {
    private char[] myData;
    private int mySize;

    public UnsignedShortArrayList(int initialCapacity) {
        this.myData = new char[initialCapacity];
    }

    public UnsignedShortArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void fill(int fromIndex, int toIndex, int value2) {
        UnsignedShortArrayList.assertShort(value2);
        if (toIndex > this.mySize) {
            this.ensureCapacity(toIndex);
            this.mySize = toIndex;
        }
        Arrays.fill(this.myData, fromIndex, toIndex, (char)value2);
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int element2) {
        UnsignedShortArrayList.assertShort(element2);
        return this.indexOf(element2) >= 0;
    }

    public int indexOf(int element2) {
        UnsignedShortArrayList.assertShort(element2);
        return this.indexOf(element2, 0, this.mySize);
    }

    public int indexOf(int element2, int startIndex, int endIndex) {
        UnsignedShortArrayList.assertShort(element2);
        if (startIndex < 0 || endIndex < startIndex || endIndex > this.mySize) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + "; endIndex: " + endIndex + "; mySize: " + this.mySize);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (element2 != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int element2) {
        UnsignedShortArrayList.assertShort(element2);
        for (int i = this.mySize - 1; i >= 0; --i) {
            if (element2 != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            UnsignedShortArrayList v = (UnsignedShortArrayList)super.clone();
            v.myData = (char[])this.myData.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int @NotNull [] toArray() {
        int[] nArray = this.toArray(0, this.mySize);
        if (nArray == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(0);
        }
        return nArray;
    }

    public int @NotNull [] toArray(int @NotNull [] a) {
        if (a == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(1);
        }
        if (a.length < this.mySize) {
            a = new int[this.mySize];
        }
        for (int i = 0; i < this.mySize; ++i) {
            int c;
            a[i] = c = this.myData[i];
        }
        if (a == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(2);
        }
        return a;
    }

    public int @NotNull [] toArray(int startIndex, int length) {
        int[] result2 = new int[length];
        for (int i = startIndex; i < length; ++i) {
            int c;
            result2[i - startIndex] = c = this.myData[i];
        }
        if (result2 == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(3);
        }
        return result2;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public int getQuick(int index) {
        return this.myData[index];
    }

    public int set(int index, int element2) {
        this.checkRange(index);
        char oldValue = this.myData[index];
        this.setQuick(index, element2);
        return oldValue;
    }

    public void setQuick(int index, int element2) {
        UnsignedShortArrayList.assertShort(element2);
        this.myData[index] = (char)element2;
    }

    private static void assertShort(int element2) {
        assert (element2 >= 0 && element2 < 65536) : element2;
    }

    public void add(int element2) {
        this.ensureCapacity(this.mySize + 1);
        this.setQuick(this.mySize++, element2);
    }

    public void add(int index, int element2) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
        this.setQuick(index, element2);
        ++this.mySize;
    }

    public int remove(int index) {
        this.checkRange(index);
        char oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    public void copyRange(int fromIndex, int length, int toIndex) {
        if (length < 0 || fromIndex < 0 || fromIndex + length > this.mySize || toIndex < 0 || toIndex + length > this.mySize) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; length: " + length + "; toIndex: " + toIndex + "; mySize: " + this.mySize);
        }
        System.arraycopy(this.myData, fromIndex, this.myData, toIndex, length);
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

