/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFileGistImpl<Data>
implements VirtualFileGist<Data> {
    private static final Logger LOG = Logger.getInstance(VirtualFileGist.class);
    private static final int ourInternalVersion = 2;
    @NotNull
    private final String myId;
    private final int myVersion;
    @NotNull
    private final VirtualFileGist.GistCalculator<Data> myCalculator;
    @NotNull
    private final DataExternalizer<Data> myExternalizer;
    private static final Map<Pair<String, Integer>, FileAttribute> ourAttributes = FactoryMap.create(key -> new FileAttribute((String)key.first, (Integer)key.second, false));

    VirtualFileGistImpl(@NotNull String id2, int version2, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData) {
        if (id2 == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(1);
        }
        if (calcData == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(2);
        }
        this.myId = id2;
        this.myVersion = version2;
        this.myExternalizer = externalizer;
        this.myCalculator = calcData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Data getFileData(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileGistImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (!(file2 instanceof VirtualFileWithId)) {
            return this.myCalculator.calcData(project2, file2);
        }
        int stamp = PersistentFS.getInstance().getModificationCount(file2) + ((GistManagerImpl)GistManager.getInstance()).getReindexCount();
        try (DataInputStream stream = this.getFileAttribute(project2).readAttribute(file2);){
            if (stream != null && DataInputOutputUtil.readINT(stream) == stamp) {
                Data Data2 = stream.readBoolean() ? (Data)this.myExternalizer.read(stream) : null;
                return Data2;
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        Data result2 = this.myCalculator.calcData(project2, file2);
        this.cacheResult(stamp, result2, project2, file2);
        return result2;
    }

    private void cacheResult(int modCount, @Nullable Data result2, Project project2, VirtualFile file2) {
        try (DataOutputStream out = this.getFileAttribute(project2).writeAttribute(file2);){
            DataInputOutputUtil.writeINT(out, modCount);
            out.writeBoolean(result2 != null);
            if (result2 != null) {
                this.myExternalizer.save(out, result2);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAttribute getFileAttribute(@Nullable Project project2) {
        Map<Pair<String, Integer>, FileAttribute> map2 = ourAttributes;
        synchronized (map2) {
            return ourAttributes.get(Pair.create(this.myId + (project2 == null ? "###noProject###" : project2.getLocationHash()), this.myVersion + 2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calcData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/gist/VirtualFileGistImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

