/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.openapi.util.Pair;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GraphGenerator<Node>
implements Graph<Node> {
    private final InboundSemiGraph<Node> myGraph;
    private final Map<Node, List<Node>> myOuts;

    @NotNull
    public static <T> Graph<T> generate(@NotNull InboundSemiGraph<T> graph2) {
        if (graph2 == null) {
            GraphGenerator.$$$reportNull$$$0(0);
        }
        return new GraphGenerator<T>(graph2);
    }

    private GraphGenerator(@NotNull InboundSemiGraph<Node> graph2) {
        if (graph2 == null) {
            GraphGenerator.$$$reportNull$$$0(1);
        }
        this.myGraph = graph2;
        this.myOuts = new THashMap<Node, List<Node>>();
        this.buildOuts();
    }

    private void buildOuts() {
        THashSet<Pair<Node, Node>> edges = new THashSet<Pair<Node, Node>>();
        for (Node node : this.myGraph.getNodes()) {
            Iterator<Node> inIt = this.myGraph.getIn(node);
            while (inIt.hasNext()) {
                Node inNode = inIt.next();
                if (!edges.add(Pair.create(inNode, node))) continue;
                List<Node> edgesFromInNode = this.myOuts.get(inNode);
                if (edgesFromInNode == null) {
                    edgesFromInNode = new ArrayList<Node>();
                    this.myOuts.put(inNode, edgesFromInNode);
                }
                edgesFromInNode.add(node);
            }
        }
    }

    @Override
    @NotNull
    public Collection<Node> getNodes() {
        Collection<Node> collection = this.myGraph.getNodes();
        if (collection == null) {
            GraphGenerator.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @NotNull
    public Iterator<Node> getIn(Node n) {
        Iterator<Node> iterator2 = this.myGraph.getIn(n);
        if (iterator2 == null) {
            GraphGenerator.$$$reportNull$$$0(3);
        }
        return iterator2;
    }

    @Override
    @NotNull
    public Iterator<Node> getOut(Node n) {
        List<Node> outNodes = this.myOuts.get(n);
        Iterator<Object> iterator2 = outNodes != null ? outNodes.iterator() : Collections.emptyIterator();
        if (iterator2 == null) {
            GraphGenerator.$$$reportNull$$$0(4);
        }
        return iterator2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/graph/GraphGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/graph/GraphGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

