/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileBasedIndex {
    @Deprecated
    public static final boolean ourEnableTracingOfKeyHashToVirtualFileMapping = true;
    @ApiStatus.Internal
    public static final boolean ourSnapshotMappingsEnabled = SystemProperties.getBooleanProperty("idea.index.snapshot.mappings.enabled", true);
    private static final Key<Boolean> INDEX_SYMLINK = Key.create("index symlink");
    private static final boolean ourDisableIndexAccessDuringDumbMode = SystemProperties.getBooleanProperty("idea.disable.index.access.during.dumb.mode", false);

    public abstract void iterateIndexableFiles(@NotNull ContentIterator var1, @NotNull Project var2, ProgressIndicator var3);

    public void iterateIndexableFilesConcurrently(@NotNull ContentIterator processor2, @NotNull Project project2, @NotNull ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndex.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            FileBasedIndex.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            FileBasedIndex.$$$reportNull$$$0(2);
        }
        this.iterateIndexableFiles(processor2, project2, indicator);
    }

    @Nullable
    public abstract VirtualFile getFileBeingCurrentlyIndexed();

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public DumbModeAccessType getCurrentDumbModeAccessType() {
        throw new UnsupportedOperationException();
    }

    public abstract void registerIndexableSet(@NotNull IndexableFileSet var1, @Nullable Project var2);

    public abstract void removeIndexableSet(@NotNull IndexableFileSet var1);

    public static FileBasedIndex getInstance() {
        return ApplicationManager.getApplication().getService(FileBasedIndex.class);
    }

    public static int getFileId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndex.$$$reportNull$$$0(3);
        }
        if (file2 instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)((Object)file2)).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + file2 + ", implementation class: " + file2.getClass().getName());
    }

    @Deprecated
    public abstract VirtualFile findFileById(Project var1, int var2);

    public void requestRebuild(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(4);
        }
        this.requestRebuild(indexId, new Throwable());
    }

    @NotNull
    public abstract <K, V> List<V> getValues(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public abstract <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    public abstract <K, V> boolean processValues(@NotNull ID<K, V> var1, @NotNull K var2, @Nullable VirtualFile var3, @NotNull ValueProcessor<? super V> var4, @NotNull GlobalSearchScope var5);

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter2, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(5);
        }
        if (dataKey == null) {
            FileBasedIndex.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            FileBasedIndex.$$$reportNull$$$0(7);
        }
        if (filter2 == null) {
            FileBasedIndex.$$$reportNull$$$0(8);
        }
        return this.processValues(indexId, dataKey, inFile, processor2, filter2);
    }

    public abstract <K, V> long getIndexModificationStamp(@NotNull ID<K, V> var1, @NotNull Project var2);

    public abstract <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> var1, @NotNull Collection<? extends K> var2, @NotNull GlobalSearchScope var3, @Nullable Condition<? super V> var4, @NotNull Processor<? super VirtualFile> var5);

    @NotNull
    public abstract <K> Collection<K> getAllKeys(@NotNull ID<K, ?> var1, @NotNull Project var2);

    @ApiStatus.Internal
    public abstract <K> void ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3);

    public abstract void requestRebuild(@NotNull ID<?, ?> var1, Throwable var2);

    public abstract <K> void scheduleRebuild(@NotNull ID<K, ?> var1, @NotNull Throwable var2);

    public abstract void requestReindex(@NotNull VirtualFile var1);

    public abstract <K, V> boolean getFilesWithKey(@NotNull ID<K, V> var1, @NotNull Set<? extends K> var2, @NotNull Processor<? super VirtualFile> var3, @NotNull GlobalSearchScope var4);

    @ApiStatus.Experimental
    public void ignoreDumbMode(@NotNull Runnable command, @NotNull Project project2, @NotNull DumbModeAccessType dumbModeAccessType) {
        if (command == null) {
            FileBasedIndex.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            FileBasedIndex.$$$reportNull$$$0(10);
        }
        if (dumbModeAccessType == null) {
            FileBasedIndex.$$$reportNull$$$0(11);
        }
        throw new UnsupportedOperationException();
    }

    public abstract <K> boolean processAllKeys(@NotNull ID<K, ?> var1, @NotNull Processor<? super K> var2, @Nullable Project var3);

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(12);
        }
        if (processor2 == null) {
            FileBasedIndex.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            FileBasedIndex.$$$reportNull$$$0(14);
        }
        return this.processAllKeys(indexId, processor2, scope.getProject());
    }

    @NotNull
    public abstract <K, V> Map<K, V> getFileData(@NotNull ID<K, V> var1, @NotNull VirtualFile var2, @NotNull Project var3);

    public static void iterateRecursively(@NotNull VirtualFile root, @NotNull ContentIterator processor2, @Nullable ProgressIndicator indicator, @Nullable Set<? super VirtualFile> visitedRoots, @Nullable ProjectFileIndex projectFileIndex) {
        if (root == null) {
            FileBasedIndex.$$$reportNull$$$0(15);
        }
        if (processor2 == null) {
            FileBasedIndex.$$$reportNull$$$0(16);
        }
        VirtualFileFilter acceptFilter2 = file2 -> {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (visitedRoots != null && !root.equals(file2) && file2.isDirectory() && !visitedRoots.add(file2)) {
                return false;
            }
            return projectFileIndex == null || ReadAction.compute(() -> projectFileIndex.isExcluded(file2)) == false;
        };
        VirtualFileFilter symlinkFilter = file2 -> {
            if (acceptFilter2.accept(file2)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    if (!Registry.is("indexer.follows.symlinks")) {
                        return false;
                    }
                    Boolean indexSymlink = file2.getUserData(INDEX_SYMLINK);
                    if (indexSymlink != null) {
                        return indexSymlink;
                    }
                    VirtualFile canonicalFile = file2.getCanonicalFile();
                    if (canonicalFile != null) {
                        return acceptFilter2.accept(canonicalFile);
                    }
                }
                return true;
            }
            return false;
        };
        VfsUtilCore.iterateChildrenRecursively(root, symlinkFilter, processor2);
    }

    public void invalidateCaches() {
        throw new IncorrectOperationException();
    }

    @ApiStatus.Internal
    public void setSymlinkIndexingStatus(@NotNull VirtualFile symlink, @Nullable Boolean indexingStatus) {
        if (symlink == null) {
            FileBasedIndex.$$$reportNull$$$0(17);
        }
        symlink.putUserData(INDEX_SYMLINK, indexingStatus);
    }

    @ApiStatus.Internal
    public static boolean isIndexAccessDuringDumbModeEnabled() {
        return !ourDisableIndexAccessDuringDumbMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbModeAccessType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symlink";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateIndexableFilesConcurrently";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "requestRebuild";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processValues";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreDumbMode";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllKeys";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateRecursively";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "setSymlinkIndexingStatus";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FileTypeSpecificInputFilter
    extends InputFilter {
        public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> var1);
    }

    @FunctionalInterface
    public static interface InputFilter {
        public boolean acceptInput(@NotNull VirtualFile var1);
    }

    @FunctionalInterface
    public static interface ValueProcessor<V> {
        public boolean process(@NotNull VirtualFile var1, V var2);
    }
}

